/*ScianPreferences.h
  Eric Pepke
  June 15, 1991
  Public stuff for preferences
*/

/*Preference types*/
#define PT_STRING	1		/*String*/		
#define PT_YNBOOL	2		/*Yes/no boolean*/
#define PT_AMBOOL	3		/*Automatic/manual boolean*/
#define PT_AFFINT	4		/*Automatic/fast/full integer*/
#define PT_SFBOOL	5		/*Safe/fast bool*/
#define PT_RPINT	6		/*RGB/PostScript integer*/

/*Values for drawMoving*/
#define DM_FULL		0		/*Draw with full res while moving*/
#define DM_SKELETON	1		/*Draw as skeleton while moving*/
#define DM_AUTO		2		/*Automatically choose based on speed*/

/*Available preferences, start with 0 and grow contiguously*/
#define PREF_DEFDIR		0	/*Default directory to open*/
#define PREF_ROTINERTIA 	1	/*Inertia on rotation?*/
#define PREF_NEWWINPLACE	2	/*New window placement*/
#define PREF_DRAWMOVING		3	/*Draw while moving*/
#define PREF_STAGGERICONS	4	/*Stagger icons?*/
#define PREF_SAVESCREEN		5	/*Save screen as what kind of file*/
#define PREF_RECKLESSGC		6	/*Reckless garbage collection*/
#define NPREFERENCES		7
#define NRELEASEPREFERENCES	5	/*Number of release preferences*/

#ifdef PROTO
void InitPreferences(void);
Bool PrefExists(int);
char *GetPrefString(int);
Bool GetPrefTruth(int);
long GetPrefInteger(int);
void DoShowPreferences(void);
void KillPreferences(void);
#else
void InitPreferences();
Bool PrefExists();
char *GetPrefString();
Bool GetPrefTruth();
long GetPrefInteger();
void KillPreferences();
void DoShowPreferences();
#endif
