/*ScianLights.h
  Lights external definitions
  Eric Pepke
  May 21, 1991
*/

typedef struct
    {
	real theta;			/*Theta of light position*/
	real phi;			/*Phi of light position*/
	real baseColor[3];		/*Base color of light*/
	real brightness;		/*Brightness of light*/
	Bool enabled;			/*True iff enabled*/
    } lightSpec;

#define IsLight(object) IntVarEql(object, CLASSID, CLASS_LIGHT)

#ifdef PROTO
void InitLights(void);
void KillLights(void);
ObjPtr NewLights(void);
void StartLights(ObjPtr, ObjPtr, Bool);
void StopLights(ObjPtr);
void DrawLights(ObjPtr, ObjPtr, int, real);
void TwoSided(Bool);
#else
void InitLights();
void KillLights();
ObjPtr NewLights();
void StartLights();
void StopLights();
void DrawLights();
void TwoSided();
#endif
