/*ScianSockets.h
  External stuff for sockets in Scian
  Eric Pepke
*/

extern int socketState;

/*Socket connection structure*/
typedef struct 
    {
	Thing thing;			/*The thing part*/
	int sock;			/* socket fd */
	int gotCmdEnd;			/* true if we found a \n or a \0 */
	int template;			/*File descriptor template,
					  ONLY used on listener*/
    } Connection, *ConnectionPtr;

#define CMD(s)  ((s)[0] * 16777216 + (s)[1] * 65536 + (s)[2] * 256 + (s)[3])

/*Timeouts*/
#define TRYLATERTIME	5.0		/*Try later in 5.0 seconds*/
#define JOHNSTIMEOUT	10.0		/*read/write timeout for sockets */

extern ObjPtr allAdvertised;
extern ObjPtr advertiseableClass;		/*Class of advertiseable objects*/

/*Methods*/
ObjPtr AdvertiseObject();

#ifdef PROTO
int writen(int, char *, long);
int readn(int, char *, long);
void InitSockets(void);
void KillSockets(void);
Bool AllConnectionsIdle(Bool);
Bool IdleAllConnections(void);
Bool IdleConnection(ObjPtr);
void DoConnectToComputer(void);
void DoEnablePublication(void);
void SendSocketCommandLater(ObjPtr connection, char *command);
void SendObjectLater(ObjPtr, ObjPtr);
ObjPtr NewLocalDaemonConnection(void);
ObjPtr NewRemoteDaemonConnection(char *machineName);
ObjPtr NewRemoteScianConnection(char *machineName, int port, ObjPtr process);
ObjPtr NewListenerConnection(void);
ObjPtr NewLocalScianConnection(int file);
ObjPtr FindRemoteObject(ObjPtr, int, Bool);
Bool WaitForNetObjectElement(ObjPtr, unsigned long);
Bool WaitForNetObjectVar(ObjPtr, VarsPtr);
Bool WaitForNetObject(ObjPtr, unsigned long);
Bool ThisWouldBeAReallyBadThing(NameTyp var);
Bool IsNetworkIDWaiting(ObjPtr process, unsigned long netid);
void NetworkIDIsWaiting(ObjPtr process, unsigned long netid, Bool flag);
#else
int writen();
int readn();
void InitSockets();
void KillSockets();
Bool AllConnectionsIdle();
Bool IdleAllConnections();
Bool IdleConnection();
void DoConnectToComputer();
void DoEnablePublication();
void SendSocketCommandLater();
void SendObjectLater();
ObjPtr NewLocalDaemonConnection();
ObjPtr NewRemoteDaemonConnection();
ObjPtr NewRemoteScianConnection();
ObjPtr NewListenerConnection();
ObjPtr NewLocalScianConnection();
ObjPtr FindRemoteObject();
Bool WaitForNetObjectElement();
Bool WaitForNetObjectVar();
Bool WaitForNetObject();
Bool ThisWouldBeAReallyBadThing();
Bool IsNetworkIDWaiting();
void NetworkIDIsWaiting();
#endif
