/* ScianIDsParser.c: John R. Murray. Writes ScianIDsDefiner.c based on the
 * contents of ScianIDs.h. Really!
 */

#include "Scian.h"
#include "ScianTypes.h"
#include "ScianNames.h"

#define TMPBUFSIZ 1024
#define INFILE "ScianIDs.h"
#define OUTFILE "ScianIDsDefiner.c"

main()
{
    FILE *inFile;
    FILE *outFile;
    char tmpBuf[TMPBUFSIZ];
    char tmpStr[TMPBUFSIZ];
    NameTyp tmpNum;

    if (!(inFile = fopen(INFILE, "r")))
    {
	fprintf(stderr, "ScianIDsParser: Couldn't open %s\n", INFILE);
	exit(-1);
    }

    if (!(outFile = fopen(OUTFILE, "w")))
    {
	fprintf(stderr, "ScianIDsParser: Couldn't open %s\n", OUTFILE);
	exit(-1);
    }

    fprintf(outFile, "/* %s: John R. Murray\n", OUTFILE);
    fprintf(outFile, " * WARNING! This file is automatically generated by ScianIDsParser.c. Any\n");
    fprintf(outFile, " * changes that you make to this file will be squashed like a tiny little\n");
    fprintf(outFile, " * bug the next time someone (for example, 'make') runs ScianIDsParser\n");
    fprintf(outFile, " */\n\n");
    fprintf(outFile, "#include \"Scian.h\"\n");
    fprintf(outFile, "#include \"ScianTypes.h\"\n");
    fprintf(outFile, "#include \"ScianNames.h\"\n");
    fprintf(outFile, "#include \"ScianIDsDefiner.h\"\n\n");
    fprintf(outFile, "void ParseScianIDs()\n");
    fprintf(outFile, "{\n");

    while (fgets(tmpBuf, TMPBUFSIZ, inFile))
    {
	if (2 == sscanf(tmpBuf, "#define%s%ld", tmpStr, &tmpNum))
	{
	    fprintf(outFile, "    DefineID(\"%s\", %ld);\n", tmpStr, tmpNum);
	}
    }

    fprintf(outFile, "}\n");
    fclose(outFile);
}

