
#include "rtep.h"

/***************************************************************************/
/* FUNCTION: int opt_index()
/*
/* DESCRIPTION:
/*    Fill out an array which is the same size as argv[] (from main())
/*    containing information about where command line options
/*    are located in argv[].  (command line options are assumed to 
/*    begin with "-")
/*
/* USAGE:
/*    error_ret = opt_index(clargs,opt_array,nargs,nopts,opt_loc);
/*
/* ARGUMENTS:
/*    char  *clargs[]    (in)  : command line arguments (i.e. argv[])
/*    char  *opt_array[] (in)  : array of command line option strings
/*                             : options must begin with "-"
/*    int   nargs        (in)  : array size of *clargs[]
/*    int   nopts        (in)  : array size of *opt_array[]
/*    int   opt_loc[]    (out) : index into clargs[] of where
/*                             : opt_array[i] can be found
/*
/* RETURNS: (int)
/*    0 : function call completed successfully
/*    1 : no options were found in clargs[]
/*
/* COMMENTS:
/*    Command line options must begin with the character "-".
/*
/* EXAMPLE:
/*    opt_array[1] = "-asc"; opt_array[2] = "-bin";
/*    err_ret = opt_index(argv,opt_array,argc,nopts,opt_loc);
/*    Typing the following on the command line:
/*           test -bin -asc junk.in junk.out
/*    would return the following:
/*           opt_loc[1] = 2
/*           opt_loc[2] = 1
/*
/* SEE ALSO:
/*    prog_opts(), prog_title().
/*
/* INFO:
/*    Author		: Ray Idaszak
/*    Date		: November 14, 1988
/*    Last Modified	: January 13, 1989
/*    email		: rayi@ncsa.uiuc.edu
/***************************************************************************/

#define TRUE 1
#define FALSE 0

int opt_index(clargs,opt_array,nargs,nopts,opt_loc)
char *clargs[],*opt_array[];
int nargs,nopts;
int opt_loc[];
{
	int i,j,argopts;
	int err_ret;
	register int i1;
	int *iptr;
	unsigned char *tf,*tptr;
	char *cptr;

	i1 = nopts;
	iptr = &opt_loc[0];
	do{
		i1--;
		*iptr++ = 0;
	}while(i1);

	err_ret = 0;
	i1 = nargs;

/* 
   comment out the following block of code if command line options
   will begin with any character other than '-'.
*/
/* begin "-" block */
	do{
		i1--;
		cptr = clargs[i1]; 

/*
   all references to 'isdigit()' heretoforth refers to code which
   ignores negative numerals on the command line so as not to confuse
   these with command line options
*/

		if ((*clargs[i1] == '-') && !(isdigit((int)*++cptr)) ) break;
	}while(i1);
	if (!i1){
		err_ret = 1;
		goto error;
	}
	i1++;
/* end "-" block */

	argopts = i1;
	tf = (unsigned char *)malloc(i1);
	tptr = tf;
	do{
		i1--;
		*tptr++ = FALSE;
	}while(i1);

	for(i=1; i<argopts; i++){
		if (!(*clargs[i] == '-')) continue; 
		for(j=1; j<nopts; j++){
			if (!strcmp(clargs[i],opt_array[j])){
				opt_loc[j] = i;
				tf[i] = TRUE;
			}
		}
	}

/* print out all illegal options */

	for(i=1; i<argopts; i++){
	   cptr = clargs[i]; 
	   if ((*clargs[i] == '-') && !(isdigit((int)*++cptr)) && !(tf[i])){
		   printf("ERROR   : illegal option %s\n",clargs[i]);
		}
	}

	free(tf);

error:
#if RTE_PRERR
	err_msg("opt_index",err_ret);
#endif
	return(err_ret);

}

