/*
 * Copyright (C) 1992, Board of Trustees of the University of Illinois.
 *
 * Permission is granted to copy and distribute source with out fee.
 * Commercialization of this product requires prior licensing
 * from the National Center for Supercomputing Applications of the
 * University of Illinois.  Commercialization includes the integration of this 
 * code in part or whole into a product for resale.  Free distribution of 
 * unmodified source and use of NCSA software is not considered 
 * commercialization.
 *
 */


#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/StringDefs.h>
#include <X11/Intrinsic.h>
#include <dtm/dtm.h>

#include "viewer.h"
#include "view.h"
#include "net.h"


#define ABS(x)  ((x)>0) ? (x): (-1.0*(x))


extern int NetSendCommand();


extern NetPort *outP;
extern GC	selGC;
extern Display	*myDpy;
extern int	Swidth, Sheight, Sascent;


static int last_x, last_y;



void
StartPolyview(V, w, win_x, win_y)
	View *V;
	Widget w;
	int win_x, win_y;
{
	last_x = win_x;
	last_y = win_y;
}


void
MovePolyview(V, w, win_x, win_y)
	View *V;
	Widget w;
	int win_x, win_y;
{
	int dx, dy;
	char command[1024];

	dx = ABS(win_x - last_x);
	dy = ABS(win_y - last_y);
	if ((dx > 4)||(dy > 4))
	{
		sprintf(command, "polyview movecursor %d %d", win_x, win_y);
		NetSendCommand(outP, "Polyview", command, NULL, NULL);
		last_x = win_x;
		last_y = win_y;
	}
}


void
DonePolyview(V, w, win_x, win_y)
	View *V;
	Widget w;
	int win_x, win_y;
{
	char command[1024];

	if ((last_x != win_x)||(last_y != win_y))
	{
		sprintf(command, "polyview movecursor %d %d", win_x, win_y);
		NetSendCommand(outP, "Polyview", command, NULL, NULL);
		last_x = win_x;
		last_y = win_y;
	}
	NetSendCommand(outP, "Polyview", "polyview movecursorend", NULL, NULL);
}

