/*
 * Copyright (C) 1992, Board of Trustees of the University of Illinois.
 *
 * Permission is granted to copy and distribute source with out fee.
 * Commercialization of this product requires prior licensing
 * from the National Center for Supercomputing Applications of the
 * University of Illinois.  Commercialization includes the integration of this 
 * code in part or whole into a product for resale.  Free distribution of 
 * unmodified source and use of NCSA software is not considered 
 * commercialization.
 *
 */
#if ! defined(lint) && ! defined(LINT)
static char rcs_id[] = "$Id: drawline.c,v 1.2 1993/05/05 16:12:49 gbourhis Exp $";
#endif


#include <stdio.h>
#include <math.h>
#ifndef M_PI
#define M_PI            3.14159265358979323846
#endif

#include <X11/Intrinsic.h>

#include "doodle.h"
#include "view.h"
#include "viewer.h"
#include "net.h"

#if defined(ultrix) || defined(_IBMR2) || defined(sgi) || defined(MOTOROLA) \
  || defined(__hpux)
#define sincos(x,s,c)  *(s) = sin(x); *(c) = cos(x)
#endif


extern void FillLine();
extern void DrawPoints();
extern int MySendDoodle();


extern NetPort *outP;
extern POINT drawDoodle[];
extern long doodleLength;
extern GC invGC;
extern Display *myDpy;
extern Cdata *currentObject;


static int start_x, end_x, start_y, end_y;



void
RubberLine(w)
	Widget w;
{
	XDrawLine(myDpy, XtWindow(w), invGC, start_x, start_y,
		end_x, end_y);
}


void
InitDrawLine(V, w, win_x, win_y)
	View *V;
	Widget w;
	int win_x, win_y;
{
	start_x = win_x;
	start_y = win_y;
	end_x = start_x;
	end_y = start_y;
	RubberLine(w);
	doodleLength = 0;
}


void
DrawLine(V, w, win_x, win_y)
	View *V;
	Widget w;
	int win_x, win_y;
{
	if ((win_x != end_x)||(win_y != end_y))
	{
		RubberLine(w);
		end_x = win_x;
		end_y = win_y;
		RubberLine(w);
	}
}


void
DoneDrawLine(V, w, win_x, win_y)
	View *V;
	Widget w;
	int win_x, win_y;
{
	long	start;
	int     status;

	drawDoodle[doodleLength].x = start_x;
	drawDoodle[doodleLength].y = start_y;
	doodleLength++;
	drawDoodle[doodleLength].x = end_x;
	drawDoodle[doodleLength].y = end_y;
	start = doodleLength - 1;
	FillLine(drawDoodle, &doodleLength, MAXDRAWDOODLE);

	RubberLine(w);
	DrawPoints(V, V->cData, drawDoodle, start, doodleLength,
		V->doodleColor, V->doodleWidth);
	doodleLength++;

	/*
	 * Send Doodle
	 */
	status = MySendDoodle(V, V->doodleWidth, doodleLength, drawDoodle,
		True, True);
}


void
DoneDrawArrow(V, w, win_x, win_y)
	View *V;
	Widget w;
	int win_x, win_y;
{
	int     status;
	int ax, ay;
	int dx, dy;

	drawDoodle[doodleLength].x = start_x;
	drawDoodle[doodleLength].y = start_y;
	doodleLength++;
	drawDoodle[doodleLength].x = end_x;
	drawDoodle[doodleLength].y = end_y;
	FillLine(drawDoodle, &doodleLength, MAXDRAWDOODLE);

	dx = end_x - start_x;
	dy = end_y - start_y;
	if ((dx <= 0)&&(dy > 0))
	{
		double theta;
		double s, c;

		s = c = 0.0;
		doodleLength++;
		theta = atan2((double)dy, (double)-dx);
		sincos((theta + (M_PI / 4)), &s, &c);
		ax = end_x + (int)(10.0 * c);
		ay = end_y - (int)(10.0 * s);
		drawDoodle[doodleLength].x = ax;
		drawDoodle[doodleLength].y = ay;
		FillLine(drawDoodle, &doodleLength, MAXDRAWDOODLE);
		doodleLength++;
		drawDoodle[doodleLength].x = end_x;
		drawDoodle[doodleLength].y = end_y;
		doodleLength++;
		sincos((theta - (M_PI / 4)), &s, &c);
		ax = end_x + (int)(10.0 * c);
		ay = end_y - (int)(10.0 * s);
		drawDoodle[doodleLength].x = ax;
		drawDoodle[doodleLength].y = ay;
		FillLine(drawDoodle, &doodleLength, MAXDRAWDOODLE);
	}
	else if ((dx < 0)&&(dy <= 0))
	{
		double theta;
		double s, c;

		s = c = 0.0;
		doodleLength++;
		theta = atan2((double)-dy, (double)-dx);
		sincos((theta + (M_PI / 4)), &s, &c);
		ax = end_x + (int)(10.0 * c);
		ay = end_y + (int)(10.0 * s);
		drawDoodle[doodleLength].x = ax;
		drawDoodle[doodleLength].y = ay;
		FillLine(drawDoodle, &doodleLength, MAXDRAWDOODLE);
		doodleLength++;
		drawDoodle[doodleLength].x = end_x;
		drawDoodle[doodleLength].y = end_y;
		doodleLength++;
		sincos((theta - (M_PI / 4)), &s, &c);
		ax = end_x + (int)(10.0 * c);
		ay = end_y + (int)(10.0 * s);
		drawDoodle[doodleLength].x = ax;
		drawDoodle[doodleLength].y = ay;
		FillLine(drawDoodle, &doodleLength, MAXDRAWDOODLE);
	}
	else if ((dx > 0)&&(dy >= 0))
	{
		double theta;
		double s, c;

		s = c = 0.0;
		doodleLength++;
		theta = atan2((double)dy, (double)dx);
		sincos((theta + (M_PI / 4)), &s, &c);
		ax = end_x - (int)(10.0 * c);
		ay = end_y - (int)(10.0 * s);
		drawDoodle[doodleLength].x = ax;
		drawDoodle[doodleLength].y = ay;
		FillLine(drawDoodle, &doodleLength, MAXDRAWDOODLE);
		doodleLength++;
		drawDoodle[doodleLength].x = end_x;
		drawDoodle[doodleLength].y = end_y;
		doodleLength++;
		sincos((theta - (M_PI / 4)), &s, &c);
		ax = end_x - (int)(10.0 * c);
		ay = end_y - (int)(10.0 * s);
		drawDoodle[doodleLength].x = ax;
		drawDoodle[doodleLength].y = ay;
		FillLine(drawDoodle, &doodleLength, MAXDRAWDOODLE);
	}
	else if ((dx >= 0)&&(dy < 0))
	{
		double theta;
		double s, c;

		s = c = 0.0;
		doodleLength++;
		theta = atan2((double)-dy, (double)dx);
		sincos((theta + (M_PI / 4)), &s, &c);
		ax = end_x - (int)(10.0 * c);
		ay = end_y + (int)(10.0 * s);
		drawDoodle[doodleLength].x = ax;
		drawDoodle[doodleLength].y = ay;
		FillLine(drawDoodle, &doodleLength, MAXDRAWDOODLE);
		doodleLength++;
		drawDoodle[doodleLength].x = end_x;
		drawDoodle[doodleLength].y = end_y;
		doodleLength++;
		sincos((theta - (M_PI / 4)), &s, &c);
		ax = end_x - (int)(10.0 * c);
		ay = end_y + (int)(10.0 * s);
		drawDoodle[doodleLength].x = ax;
		drawDoodle[doodleLength].y = ay;
		FillLine(drawDoodle, &doodleLength, MAXDRAWDOODLE);
	}

	RubberLine(w);
	DrawPoints(V, V->cData, drawDoodle, 0, doodleLength,
		V->doodleColor, V->doodleWidth);
	doodleLength++;

	/*
	 * Send Doodle
	 */
	status = MySendDoodle(V, V->doodleWidth, doodleLength, drawDoodle,
		True, True);
}

