
/*************************************************************************
**									**
**	MODULE NAME 	:	3d.c					**
**									**
**	MODULE TYPE 	:	Point/vector manipulation module	**
**									**
**	MODULE AUTHOR 	:	Philip J. Schneider			**
**                                                                      **
**      Last Modified   :       March 18, 1991                          **
**      By              :       Lian Wang                               **
**************************************************************************
*************************************************************************/

/************************************************************************
*									*
*			3d.c : includes					*
*									*
************************************************************************/
#include <stdio.h>
#include <math.h>
#include "3d.h"


/************************************************************************
*									*
*			3d.c : procedure declarations			*
*									*
************************************************************************/


double V3Dot(V1, V2)
    Vector3 *V1, *V2;
{
    return (V1->x*V2->x + V1->y*V2->y + V1->z*V2->z);
}

double	V3DistanceBetween2Points(a, b)
    Point3 *a, *b;
{
    double dx;
    double dy;
    double dz;
    double	dist;
    dx = a->x - b->x;
    dy = a->y - b->y;
    dz = a->z - b->z;
    dist = (sqrt((dx*dx)+(dy*dy)+(dz*dz)));
    return (dist);
}

Vector3	*V3Negate(v)
    Vector3	*v;
{
    v->x = -(v->x);
    v->y = -(v->y);
    v->z = -(v->z);
    return(v);
}


Vector3	*V3Scale(v, newlen)
    Vector3	*v;
    double	newlen;
{
    double len;

    len = V3Length(v);
    if (len != 0.0) {
	v->x *= newlen/len;
	v->y *= newlen/len;
	v->z *= newlen/len;
    }
    return (v);
}

double V3Length(v)
    Vector3	*v;
{
    double len;

    len = sqrt(v->x * v->x + v->y * v->y + v->z * v->z);

    return (len);
}

double V3SquaredLength(v)
    Vector3	*v;
{
    double len;

    len = v->x * v->x + v->y * v->y + v->z * v->z;

    return len;
}



Vector3 *V3Normalize(v)
    Vector3 *v;
{
    double len;

    len = V3Length(v);

    if (len != 0) {
	v->x /= len;
	v->y /= len;
	v->z /= len;
    }

    return (v);
}

Vector3 *V3Add(a, b, c)
    Vector3	*a, *b, *c;
{
    c->x = a->x + b->x;
    c->y = a->y + b->y;
    c->z = a->z + b->z;

    return (c);
}



/*
Vector3 *V3Sub(a, b, c)
    Vector3	*a, *b, *c;
{
    c->x = a->x - b->x;
    c->y = a->y - b->y;
    c->z = a->z - b->z;

    return (c);
}
*/

Vector3 V3AddII(a, b)
    Vector3 a, b;
{
    Vector3	c;

    c.x = a.x + b.x;  c.y = a.y + b.y; c.z = a.z + b.z;
    return (c);
}


Vector3 V3ScaleII(v, s)
    Vector3	v;
    double	s;
{
    Vector3 result;

    result.x = v.x * s; result.y = v.y * s;
    result.z = v.z * s; 
    return (result);
}

Vector3 V3Sub(a, b)
    Vector3	a, b;
{
    Vector3	c;
    c.x = a.x - b.x; c.y = a.y - b.y; c.z = a.z -b.z;
    return (c);
}
