/*************************************************************************
**									**
**	MODULE NAME 	:	2d.c					**
**									**
**	MODULE TYPE 	:	Point/vector manipulation module	**
**									**
**	MODULE AUTHOR 	:	Philip J. Schneider			**
**                                                                      **
**                                                                      **
**************************************************************************
*************************************************************************/

/************************************************************************
*									*
*			2d.c : includes					*
*									*
************************************************************************/
#include <stdio.h>
#include <math.h>
#include "2d.h"


/************************************************************************
*									*
*			2d.c : procedure declarations			*
*									*
************************************************************************/


double V2Dot(V1, V2)
    Vector2 *V1, *V2;
{
    return (V1->x*V2->x + V1->y*V2->y);
}

double	V2DistanceBetween2Points(a, b)
    Point2 *a, *b;
{
    double dx;
    double dy;
    double	dist;
    dx = a->x - b->x;
    dy = a->y - b->y;
    dist = (sqrt((dx*dx)+(dy*dy)));
    return (dist);
}

Vector2	*V2Negate(v)
    Vector2	*v;
{
    v->x = -(v->x);
    v->y = -(v->y);
    return(v);
}


Vector2	*V2Scale(v, newlen)
    Vector2	*v;
    double	newlen;
{
    double len;

    len = V2Length(v);
    if (len != 0.0) {
	v->x *= newlen/len;
	v->y *= newlen/len;
    }
    return (v);
}

double V2Length(v)
    Vector2	*v;
{
    double len;

    len = sqrt(v->x * v->x + v->y * v->y);

    return (len);
}

double V2SquaredLength(v)
    Vector2	*v;
{
    double len;

    len = v->x * v->x + v->y * v->y;

    return len;
}



Vector2 *V2Normalize(v)
    Vector2 *v;
{
    double len;

    len = V2Length(v);

    if (len != 0) {
	v->x /= len;
	v->y /= len;
    }

    return (v);
}

Vector2 *V2Add(a, b, c)
    Vector2	*a, *b, *c;
{
    c->x = a->x + b->x;
    c->y = a->y + b->y;

    return (c);
}



/*
Vector2 *V2Sub(a, b, c)
    Vector2	*a, *b, *c;
{
    c->x = a->x - b->x;
    c->y = a->y - b->y;

    return (c);
}
*/

Vector2 V2AddII(a, b)
    Vector2 a, b;
{
    Vector2	c;

    c.x = a.x + b.x;  c.y = a.y + b.y;
    return (c);
}


Vector2 V2ScaleII(v, s)
    Vector2	v;
    double	s;
{
    Vector2 result;

    result.x = v.x * s; result.y = v.y * s;
    return (result);
}

Vector2 V2Sub(a, b)
    Vector2	a, b;
{
    Vector2	c;
    c.x = a.x - b.x; c.y = a.y - b.y;
    return (c);
}
