/*
** File: CopyPath.c
** Purpose: Make a copy of a path.
** Author: James Painter, David Meyers
** Last Modified: 8 November 1989
*/

#include <stdio.h>
#include <TypeDefinitions.h>
#include "TorGraph.h"

extern void exit();

void CopyPath( In, Out )
 PathType *In, *Out;
 {
  int i;

  if (Out->Rows != In->Rows || Out->Columns != In->Columns)
   {
    (void) fprintf(stderr, "Internal error in CopyPath.  Path size wrong.\n" );
    exit ( -1 );
   }
  Out->StartR = In->StartR;
  Out->StartC = In->StartC;
  for (i=0; i<2*In->Rows; i++)
     Out->LeavesRowInCol[i] = In->LeavesRowInCol[i];
  for (i=0; i<2*In->Columns; i++)
     Out->LeavesColInRow[i] = In->LeavesColInRow[i];
 }
