/*
  File: TypeDefinitions.h
  Author: David Meyers
  Last Modified: 27 June 1990
  Purpose: Collect all the type definitions for the Surfaces from Contours
           stuff into one place
 */


#ifndef BOOLEAN

#  define BOOLEAN
   typedef char Boolean;
#ifndef FALSE
#  define FALSE 0
#endif FALSE
#ifndef TRUE
#  define TRUE !FALSE
#endif TRUE
#endif BOOLEAN
#define EPSILON (1.0e-16)
#define REAL float

typedef int *BitArray;

typedef struct xyz { REAL x, y, z; } PointType;
 
typedef struct nPoints { int n;  PointType *P; } PointsType;


typedef enum {TowardsLeft, TowardsRight, DontKnow} WhichWayType; /* For Bias */


typedef enum {UP, LEFT} DirectionType;

typedef struct FixedNode 
                {
                 REAL UpCost, LeftCost;
                } NodeType;

typedef struct PerSearchNode
                {
                 REAL BestCost;
                 DirectionType WhichWay;
                } PSNodeType;

typedef struct Graph
                {
                  int Rows, Columns;
                  NodeType **N;     /* [MaxRows][MaxColumns] */
                  PSNodeType **PSN; /* [MaxRows+1][MaxColumns+1] */
                } GraphType;

typedef struct Path
                {
 	          int Rows, Columns;    /* Size of associated graph */
                  int StartR, StartC;   /* Starting row and column */
		  int *LeavesRowInCol;  /* Last column for each row */
                  int *LeavesColInRow;  /* Last row for each column */
                } PathType;


typedef PointType VectorType;
typedef PointsType VectorsType;

typedef struct Adj {
  char Name[80];     /* Name of the adjacent contour */
  int LocalIndex;    /* Index in the local contour to connect to adj contour */
  int AdjacentIndex; /* Index in adj contour to which connection is made */
  struct Adj *next;
  struct Adj *prev;
 } Adjacency;

/* 
  AdjIndex is used for maintaining a list of pairs of contours which share a 
  common point
 */
typedef struct AdjI {
  int FirstContour;   /* Index into an array of contours */
  int FCPoint;        /* Index into the points array of the contour */
  int SecondContour;  /* Index into an array of contours */
  int SCPoint;        /* Index into the points array of the contour */
  char Name[80];      /* The unique name of the point */
  struct AdjI *next;
 } AdjIndex;

typedef struct {
  int Visited;               /* for control of tiling operations */
  char Name[80];             /* name of the contour */
  int NAliases;              /* number of Aliases for this contour name */
  char *Aliases;             /* array of names of contours above or below */
  PointsType *ContourPoints; /* pointer to the list of points of the contour */
  Adjacency *AdjContPrev;    /* Contours which merge above */
  Adjacency *AdjContNext;    /* Contours which merge below */
 } Contour;

typedef struct Cdesc {
  char SectionName[80]; /* name of the section in which the contour is found */
  char Name[80];        /* name of the contour */
  int Index;            /* index into the array of Contours of this section */
  int Npts;             /* how many points in this segment of the contour */
  int FirstPoint;       /* index to the first point of this segment */
  int LastPoint;        /* index to the last point of segment, wraparound ok */
  struct Cdesc *next;
 } ContourDescriptor;

typedef struct {
  char Name[80];         /* a string identifying the section */
  int NContours;         /* the number of Contours included in this section */
  Contour *TheContours;  /* an array of Contours included in this section */
  AdjIndex *TheIndex;    /* pairs of identical (contour, point) pairs */
  int Last;              /* last used element of TheIndex */
 } Section;

typedef struct Pt {   /* for use with the polygon tiler only */
  char PointName[80];
  double x, y;
  struct Pt *next;
  struct Pt *prev;
 } TPointType;
