/*
 *                 (c) Copyright AT&T 1991.
 *
 * License granted for use only in connection with ISO and CCITT evaluations.
 *     AT&T offers no warranties of any kind, expressed or implied.
 *     Contact D. L. Duttweiler (d.l.duttweiler@att.com) for email copies.
 */

/*
 * Version S1R4.1		First version
 * Version S1R4.2		Corrects TPB2CTX, a la Yoshida
 * Version S1R4.3		Inhibits AT counting for last 2 pixels
 *				  in bottom layer processing
 * Version S1R4.4		Calloc of image memory to elimate upper
 *				  bound on image width
 * Version S1R4.5		SDE's move in pieces between pxf and psf
 */

/*
 * Usage as encoder:
 *	s1r4 prefix 0 ndl nd np nxtop nytop lps0 nm hitolo seq ileave smid
 *	     lrltwo vlength tpdon tpbon dpon
 *	where	prefix:		prefix for forming file names
 *		ndl:		D sub L in specification
 *		nd:		D in specification
 *		np:		P in specification
 *		nxtop:		X sub D in specification
 *		nytop:		Y sub D in specification
 *		lps0:		L sub 0 in specification
 *		nm:		M sub X in specification
 *		hitolo:		HITOLO in specification
 *		seq		SEQ in specification
 *		ileave		ILEAVE in specification
 *		smid		SMID in specification
 *		lrltwo		LRLTWO in specification
 *		vlength		VLENGTH in specification
 *		tpdon:		TPDON in specification
 *		tpbon:		TPBON in specification
 *		dpon:		DPON in specification
 *   Files expected to be readable:
 *	${PRE}r${d}p${n}:	Input images, d=nd and 0<=p<P
 *   Files written:
 *	${PRE}r${d}p${n}:	ndl<=d<nd; 0<=n<P
 *	${PRE}s:		general statistics
 *	${PRE}a:		AT statistics
 *	${PRE}bie:		BIE as in specification
 *	${PRE}x:		SDE's in natural order for program (scratch)
 *
 * Usage as decoder:
 *	s1r4 prefix 1
 *	where	prefix:		prefix for forming file names
 *   Files expected to be readable:
 *	${PRE}bie:		BIE as in specification
 *   Files written:
 *	${PRE}r${d}p${n}:	ndl<=d<=nd; 0<=n<P
 *	${PRE}s:		general statistics
 */

/*
 * Notes:
 *	1)	This is not particularly fast code.  The execution speed
 *		achieved by this code in non-progressive mode is about
 *		1/2 that reported for more optimized code in JBIG-N379
 *		and JBIG-N383.  The code is even more suboptimal for
 *		non-progressive modes.  The factor there is more like
 *		1/4 (see JBIG-N379).  There is lots more to optimize and
 *		play with in the progressive version.
 *
 *		Preliminary data for assembly language coding suggests
 *		that good assembly language code should execute
 *		about 10 (non-progressive) to 20 (progressive) times faster
 *		than this code.
 *
 *		You get what you pay for!
 *
 *	2)	Be very careful with how images are stored.  The conventions
 *		here are:
 *			black = 1,
 *			8 pixels per byte,
 *			lines filled to integer bytes,
 *			LSB leftmost (the IREAD and IWRITE macros could
 *			  easily be modified for LSB rightmost)
 *
 *	3)	There will be int versus long problems if you try
 *		to compile this on a 16 bit machine.  Globally substituting
 *		long for int will get it working, but there will be quite a
 *		performance penalty.  Careful thought is needed and I have
 *		no interest in giving it.
 *
 *	4)	I've exercised many parameterizations, but it is likely
 *		there will be lingering bugs.  If you find problems
 *		(and especially if you fix them) please pass the information
 *		along.
 *
 *	5)	This code has compiled and run successfully on
 *			MIPS R2000 running RISC/os (UMIPS) 4.51
 *			Sun Sparcstation II running SunOS Release 4.1.1
 *			Sun 3/50 running SunOS Release 4.0.1
 *		It is written in "Kernighan and Ritchie" c rather than
 *		ANSI c.
 */

#include <stdio.h>
#include "emacros.h"
#include "pres.h"
#include "dp.h"

/********************** Symbolic constants ************************************/
#define ATALL		2048		/* minimum AT count */
#define ATMOVE		0x06		/* AT movement */
#define DPMISS		2		/* array value when DP can't predict */
#define ESC		0xff		/* escape */
#define IMMATERIAL	0		/* useful in keeping lint happy */
#define LCLCD		2		/* latency, coloring to coding */
#define NCX		(1<<12)		/* number of contests */
#define ND		6		/* maximum number of delta layers */
#define NM		16		/* maximum AT lag allowed */
#define NP		32		/* maximum number of planes */
#define NPH		4		/* number of phases */
#define NPREFIX		200		/* maximum length of prefix */
#define NS		100		/* maximum number of stripes */
#define NSDE		512		/* SDE transfer size */
#define NWL		4		/* lines in low resolution window */
#define SDNORM		0x02		/* normal stripe data end */
#define SDRST		0x03		/* reset at stripe data end */
#define STUFF		0x00		/* escape escape */
#define TPB2CTX		0x159		/* pseudo context for bottom TP
					   erroneously given as 0x169 in
					   earlier version */
#define TPB3CTX		0x1c9		/* pseudo context for bottom TP */
#define TPDCTX		0xfc3		/* pseudo context for diff TP */
/********************** Derived symbolic constants ****************************/
#define NML		((NM+1)/2)
#define NMH		(2*NML)
#define NWH		(2*NWL)
#define NATC		(NM-1)
/********************** Strings ***********************************************/
#define IRLOOP		for(ir=ndl;ir<=nd;ir++)
#define IPLOOP		for(ip=0;ip<np;ip++)
#define ISLOOP		for(is=0;is<ns;is++)
/********************** Level 0 macros ****************************************/
#define ATCOUNT(A,B)	{ if(atcheck && ixh>=nm && (id!=0 || ixh<nxh-2)) { \
			    if(*php0) { \
			      atc[0] += *(phm1+(A)-2); \
			      for(i=1;i<natc;i++) atc[i] += *(php0-i-B); } \
			    else { \
			      atc[0] += 1-(*(phm1+(A)-2)); \
			      for(i=1;i<natc;i++) atc[i] += 1-(*(php0-i-B)); } \
			    atall++; } }
#define ATSWOK		{ if(atcheck && atall>ATALL) { \
			    atcheck = 0; \
			    cold = atc[iat]; \
			    tmax = 1; lmax = atc[1]; lmin = atc[1]; \
			    for(i=2;i<natc;i++) { \
			      if(atc[i] > lmax) { lmax = atc[i]; tmax = i; } \
			      if(atc[i] < lmin) lmin = atc[i]; } \
			    if(atc[0] >= lmax) { cmax = atc[0]; tmax = 0; } \
			    else cmax = lmax; \
			    cmin = atc[0]<lmin? atc[0]: lmin; \
			    if((8*cmax>7*atall) && \
			       (cmax-cold > atall-cmax) && \
			       (cmax-cold > atall>>4) && \
			       (cmax-(atall-cold) > atall-cmax) && \
			       (cmax-(atall-cold) > atall>>4) && \
			       (cmax-cmin > atall>>2) && \
			       (iat!=0 || (lmax-lmin)>atall>>3)) { \
			      FPF(paf,"id,iyh,new,old = %2d %5d %2d %2d\n", \
				id,iyh,tmax,iat); \
			      FPF(paf,"atall = %4d\natc =",atall); \
			      for(i=0;i<natc;i++) FPF(paf," %4d",atc[i]); \
			      FPF(paf,"\n"); \
			      iatnext = tmax; \
			      yat = 0; } } }
#define FOPEN(A,B,C)	{ STRCPY(file,prefix); STRCAT(file,A); \
			  if((B=fopen(file,C))==NULL) \
			    E1(could not open %s, file); }
#define IOPEN(A,B,C)	{ SPRINTF(file,"%sr%dp%d",prefix,C,ip); \
			  if((A=fopen(file,B))==NULL) \
			    E1(could not open %s,file); }
#define IREAD(A,B)	{ if(rbit==8) { rchar = getc(B); rbit = 0; } \
			  A = (rchar>>rbit++)&1; }
#define IWRITE(A,B)	{ wchar += A<<(wbit++); \
			  if(wbit==8) {FPC(wchar,B); wchar=0; wbit=0;} }
#define MODHGH(A)	imghgh + ((iyh+NWH+(A))%NWH)*nrh + NMH;
#define MODLOW(A)	imglow + ((iyl+NWL+(A))%NWL)*nrl + NML;
#define SDEPARSE	{ id = hitolo? nd+ndl-ir: ir; \
			  sdestrt[ip][id][is] = (int)ftell(pbf); \
			  sdelgth[ip][id][is] = partition(pbf); }
#define SDEWRITE	{ id = hitolo? nd+ndl-ir: ir; \
			  if(fseek(pxf,(long)sdestrt[ip][id][is],0)) \
			    E0(bad seek); \
			  i = sdelgth[ip][id][is]; \
			  while(i>0) { \
			    j = i>NSDE? NSDE: i; \
			    if( fread(sde,1,j,pxf) != j) E0(sde  read error); \
			    if(fwrite(sde,1,j,pbf) != j) E0(sde write error); \
			    i -= j; } }
#define XPUT(A)		{ FPC((int)(A),pxf); }
/********************** Level 1 macros ****************************************/
#define ATMV		{ if(ivh==yat && iat!=iatnext) { \
			    iat = iatnext; nat++; \
			    if(encode) { \
			      XPUT(ESC); XPUT(ATMOVE); \
			      XPUT(0); XPUT(0); \
			      XPUT(ivh>>8); XPUT(ivh&0xff); \
			      XPUT(iatnext>0? iatnext+2: 0); XPUT(0); } } }

int atc[NATC],cstate[NCX],*dpnext,mps[NCX],
  sdelgth[NP][ND+1][NS],sdestrt[NP][ND+1][NS];
char file[NPREFIX],*imghgh,*imglow,sde[NSDE],*solid;

FILE *paf,*pbf,*psf,*pxf;
int decode,dpon,encode,iatnext,id,ip,lps0,lrltwo,nbyte,nd,nm,nstuff,
  nxtop,nytop,pacfeed,tpbon,tpdon,yat;
char *prefix,*prgname,*strcat(),*strcpy();
void exit();

main(argc,argv)
int argc;
char *argv[];
{
  FILE *fopen();
  int hitolo,i,iarg,ileave,iph,ir,is,j,
    ndl,np,ns,nxl,options,order,seq,smid,vlength;
  char *malloc();
  void bottom(),delta();
  prgname = argv[0];
/*********************** Get parameters ***************************************/
  if(argc<3) E0(wrong argument count);
  iarg = 1;
  prefix = argv[iarg++];
  decode = atoi(argv[iarg++])? 1:0; encode = 1-decode;
  if(encode) {
    if(argc!=19) E0(wrong encoder argument count);
    FOPEN("bie",pbf,"w");
    ndl = atoi(argv[iarg++]); FPC(ndl,pbf);
    nd = atoi(argv[iarg++]); FPC(nd,pbf);
    np = atoi(argv[iarg++]); FPC(np,pbf);
    FPC(0,pbf);
    nxtop = atoi(argv[iarg++]);
    for(i=0;i<4;i++) FPC((nxtop>>(24-(i<<3)))&0xff,pbf);
    nytop = atoi(argv[iarg++]);
    for(i=0;i<4;i++) FPC((nytop>>(24-(i<<3)))&0xff,pbf);
    lps0  = atoi(argv[iarg++]);
    for(i=0;i<4;i++) FPC((lps0 >>(24-(i<<3)))&0xff,pbf);
    nm = atoi(argv[iarg++]); FPC(nm,pbf);
    FPC(0,pbf);
    hitolo = atoi(argv[iarg++])? 1:0;
    seq = atoi(argv[iarg++])? 1:0;
    ileave = atoi(argv[iarg++])? 1:0;
    smid = atoi(argv[iarg++])? 1:0;
    FPC((hitolo<<3)+(seq<<2)+(ileave<<1)+(smid<<0),pbf);
    lrltwo = atoi(argv[iarg++])? 1:0;
    vlength= atoi(argv[iarg++])? 1:0;
    tpdon = atoi(argv[iarg++])? 1:0;
    tpbon = atoi(argv[iarg++])? 1:0;
    dpon = atoi(argv[iarg++])? 1:0;
    FPC((lrltwo<<6)+(vlength<<5)+(tpdon<<4)+(tpbon<<3)+(dpon<<2),pbf); }
  else {
    if(argc!=3) E0(wrong decoder argument count);
    FOPEN("bie",pbf,"r");
    ndl = getc(pbf);
    nd = getc(pbf);
    np = getc(pbf);
    (void)getc(pbf);
    for(i=0,nxtop=0;i<4;i++) nxtop = (nxtop<<8)+getc(pbf);
    for(i=0,nytop=0;i<4;i++) nytop = (nytop<<8)+getc(pbf);
    for(i=0,lps0=0;i<4;i++) lps0 = (lps0<<8)+getc(pbf);
    nm = getc(pbf);
    if(getc(pbf)!=0) E0(no support for MY != 0);
    options = getc(pbf); if(options&0xf0) E0(bad order byte);
    hitolo = options&0x08? 1:0;
    seq = options&0x04? 1:0;
    ileave = options&0x02? 1:0;
    smid = options&0x01? 1:0;
    options = getc(pbf); if(options&0x83) E0(unsupported options requested);
    lrltwo = options&0x40? 1:0;
    vlength = options&0x20? 1:0;
    tpdon = options&0x10? 1:0;
    tpbon = options&0x08? 1: 0;
    dpon = options&0x04? 1:0; }
/*********************** Check parameters *************************************/
  if(ndl<0 || ndl>ND) E0(ndl is out of range);
  if(nd<0 || nd>ND) E0(nd is out of range);
  if(ndl>nd) E0(ndl is greater than nd);
  if(np<1 || np>NP) E0(np is out of range)
  if(nxtop<1) E0(nxtop is out of range);
  if(nytop<1) E0(nytop is out of range);
  if(lps0<1) E0(lps0 must be at least 1);
  if(nm<0 || nm>NM) E0(nm is out of range);
/*********************** Allocate memory **************************************/
  nxl = (nxtop+1)>>1;
  dpnext = (int *)malloc((unsigned int)(4*nxl));
  solid = malloc((unsigned int)nxl);
  imglow = malloc((unsigned int)(NWL*(nxl+2*NML)));
  imghgh = malloc((unsigned int)(NWH*(nxtop+2*NMH)));
/*********************** Open files *******************************************/
  FOPEN("s",psf,"w");
  if(encode) { FOPEN("a",paf,"w"); FOPEN("x",pxf,"w"); }
/*********************** Initialize *******************************************/
  if(!dpon) for(iph=0;iph<NPH;iph++) {
    if(iph<2) for(i=0;i<(1<<(8+iph));i++) dppredict[iph][i] = DPMISS;
    else for(i=0;i<(1<<(9+iph));i++) dppredict[iph][i] = DPMISS; }
  ns = ((nytop-1)>>nd)/lps0+1;
  if(ns>NS) E0(NS is too small);
  FPF(psf,"%3s%3s%5s%5s%9s","IP","ID","NAT","NLTP","NEX");
  FPF(psf,"%9s%9s%9s%9s%9s\n","NTP","NDP","NENCODE","NBYTE","NSTUFF");
  order = (seq<<2) + (ileave<<1) + (smid<<0);
  if(order==5 || order==7) E0(bad order);
  if(encode) {
    for(ip=0;ip<np;ip++) {
      for(id=nd;id>=ndl;id--) {
	if(id!=0) delta(); else bottom(); } }
    FCLOSE(pxf);
    FOPEN("x",pxf,"r");
    switch(order) {
      case 0: IPLOOP IRLOOP ISLOOP SDEWRITE; break;
      case 1: IPLOOP ISLOOP IRLOOP SDEWRITE; break;
      case 2: IRLOOP IPLOOP ISLOOP SDEWRITE; break;
      case 3: IRLOOP ISLOOP IPLOOP SDEWRITE; break;
      case 4: ISLOOP IPLOOP IRLOOP SDEWRITE; break;
      case 6: ISLOOP IRLOOP IPLOOP SDEWRITE; break; } }
  else {
    switch(order) {
      case 0: IPLOOP IRLOOP ISLOOP SDEPARSE; break;
      case 1: IPLOOP ISLOOP IRLOOP SDEPARSE; break;
      case 2: IRLOOP IPLOOP ISLOOP SDEPARSE; break;
      case 3: IRLOOP ISLOOP IPLOOP SDEPARSE; break;
      case 4: ISLOOP IPLOOP IRLOOP SDEPARSE; break;
      case 6: ISLOOP IRLOOP IPLOOP SDEPARSE; break; }
    for(ip=0;ip<np;ip++) {
      for(id=ndl;id<=nd;id++) {
	if(id!=0) delta(); else bottom(); } } }
  return 0;
}

void bottom()
{
  FILE *fopen(),*phf;
  int atall,atcheck,cmax,cmin,cold,
    i,iat,is,ivh,ixh,iyh,lmax,lmin,nat,natc,
    ndp,nencode,nex,nltp,nrh,ntp,nvh,nxh,nxyh,nyh,
    rbit,rchar,same,skip,skiplast,state,tmax,tpbctx,wbit,wchar;
  char *phat,*phats,*php0,*php0s,*phm1,*phm1s,*phm2,*phm2s;
  if(encode) { IOPEN(phf,"r",id); } else { IOPEN(phf,"w",id); }
  nxh = ((nxtop-1)>>(nd-id))+1; nyh = ((nytop-1)>>(nd-id))+1;
  nvh = lps0<<id; nrh = nxh+2*NMH; nxyh = NWH*nrh;
  if(lrltwo) natc = nm<=4? 1: nm-3; else natc = nm<=2? 1: nm-1;
  tpbctx = lrltwo? TPB2CTX: TPB3CTX;
/*********************** Per image initializations ****************************/
  wchar = 0; wbit = 0; rbit = 8;
  for(i=0;i<NCX;i++) { mps[i] = 0; cstate[i] = 0; }
  for(i=0;i<nxyh;i++) imghgh[i] = 0;
  skip = 0; skiplast = 0;
  iat = 0; iatnext = 0; yat = IMMATERIAL;
  nat = nbyte = nltp = nex = ntp = ndp = nencode = nstuff = 0;
  is = 0;
/*********************** Main loop ********************************************/
  for(iyh=0;iyh<nyh;iyh++) {
    ivh = iyh%nvh;
/*********************** Per stripe initialization ****************************/
    if(ivh==0) {
      if(encode) {
	sdestrt[ip][id][is] = (int)ftell(pxf);
	(void)einit();
	atcheck = encode && natc!=1? 1:0;
	atall = 0; for(i=0;i<natc;i++) atc[i] = 0; }
      else {
	if(fseek(pbf,(long)sdestrt[ip][id][is],0)) E0(bad seek);
	pacfeed = 0; (void)dinit(); } }
    ATMV;
    phm2s = MODHGH(-2); phm1s = MODHGH(-1); php0s = MODHGH(0);
    if(lrltwo) phats = iat==0? phm1s+2: php0s-iat-4;
    else       phats = iat==0? phm1s+2: php0s-iat-2;
    if(encode) {
      for(php0=php0s;php0<php0s+nxh;php0++) IREAD(*php0,phf); rbit = 8;
      if(tpbon) {
        skip = 1;
        for(php0=php0s,phm1=phm1s;php0<php0s+nxh;php0++,phm1++)
          if(*php0 != *phm1) { skip = 0; }
        same = skip==skiplast;
	(void)encoder(same,&cstate[tpbctx],&mps[tpbctx]); }
/*   2 1 0
   7 6 5 4(3)            5 4 3 2 1(0)
   9 8 ?               9 8 7 6 ?       */
      if(!skip) {
        php0 = php0s-1; phm1 = phm1s; phm2 = phm2s; phat = phats;
        if(lrltwo) {
          state = ((*phm1++)<<1);
	  for(ixh=0;ixh<nxh;ixh++) {
	    state = ((state<<1)&0x3bc) + ((*phat++)   )
		  + ((*phm1++)<<1) + ((*php0++)<<6);
	    (void)encoder((int)*php0,&cstate[state],&mps[state]);
	    ATCOUNT(2,4); } }
        else {
	  state = ((*phm1++)<<4)+(*phm2++);
	  for(ixh=0;ixh<nxh;ixh++) {
	    state = ((state<<1)&0x2e6) + ((*phat++)<<3) + (*phm2++)
		  + ((*phm1++)<<4) + ((*php0++)<<8);
	    (void)encoder((int)*php0,&cstate[state],&mps[state]);
	    ATCOUNT(2,2); } } }
      ATSWOK; }
    if(decode) {
      if(tpbon) {
        same = decoder(&cstate[tpbctx],&mps[tpbctx]);
	skip = same? skiplast: 1-skiplast; }
      if(!skip) {
        php0 = php0s-1; phm1 = phm1s; phm2 = phm2s; phat = phats;
        if(lrltwo) {
          state = ((*phm1++)<<1);
	  for(ixh=0;ixh<nxh;ixh++) {
	    state = ((state<<1)&0x3bc) + ((*phat++)   )
		  + ((*phm1++)<<1) + ((*php0++)<<6);
	    *php0 = decoder(&cstate[state],&mps[state]);
	    IWRITE(*php0,phf); } }
        else {
	  state = ((*phm1++)<<4)+(*phm2++);
	  for(ixh=0;ixh<nxh;ixh++) {
	    state = ((state<<1)&0x2e6) + ((*phat++)<<3) + (*phm2++)
		  + ((*phm1++)<<4) + ((*php0++)<<8);
	    *php0 = decoder(&cstate[state],&mps[state]);
	    IWRITE(*php0,phf); } } }
      else for(php0=php0s,phm1=phm1s;php0<php0s+nxh;php0++,phm1++) {
        *php0 = *phm1;
	IWRITE(*php0,phf); }
      if(wbit!=0) { FPC(wchar,phf); wbit = 0; wchar = 0; } }
    if(skip) { nltp += 1; ntp += nxh; } else { nencode += nxh; }
    skiplast = skip;
/*********************** End of stripe processing *****************************/
    if(ivh==nvh-1 || iyh==nyh-1) {
      if(encode) {
	(void)eflush(); XPUT(ESC); XPUT(SDNORM);
	sdelgth[ip][id][is] = (int)ftell(pxf)-sdestrt[ip][id][is]; }
      is++; } }
  FPF(psf,"%3d%3d%5d%5d%9d%9d%9d%9d%9d%9d\n",ip,id,nat,nltp,
    nex,ntp,ndp,nencode,nbyte,nstuff);
  FCLOSE(phf);
  return;
}

void delta()
{
  FILE *fopen(),*phf,*plf;
  int atall,atcheck,cmax,cmin,cold,cxhgh,cxlow,
    dpstate,dptable,i,iat,icol,irow,iph,is,ivh,ivl,ixl,ixh,iyh,iyl,
    j,lmax,lmin,lspecial,nat,natc,ndp,nencode,nex,nltp,nrh,nrl,
    ntp,nvh,nvl,nxh,nxl,nxyl,nxyh,nyh,nyl,rbit,rchar,
    slideok,state,tpcolor,tmax,wbit,wchar;
  char *phat,*phats,*phm1,*phm1s,*phm2,*phm2s,*php0,*php0s,
    *plm1,*plm1s,*plp0,*plp0s,*plp1,*plp1s;
  if(encode) { IOPEN(phf,"r",id); IOPEN(plf,"w",id-1); }
  else       { IOPEN(phf,"w",id); IOPEN(plf,"r",id-1); }
  nxh = ((nxtop-1)>>(nd-id))+1; nyh = ((nytop-1)>>(nd-id))+1;
  nvh = lps0<<id; nvl = nvh>>1;
  nxl = (nxh+1)>>1; nyl = (nyh+1)>>1;
  nrl = nxl+2*NML; nrh = nxh+2*NMH;
  nxyl = NWL*nrl; nxyh = NWH*nrh;
  natc = nm<=2? 1: nm-1;
/*********************** Per image initializations ****************************/
  wchar = 0; wbit = 0; rbit = 8;
  for(i=0;i<NCX;i++) { mps[i] = 0; cstate[i] = 0; }
  for(i=0;i<nxyh;i++) imghgh[i] = 0;	/* Needed to set margins to zero */
  for(i=0;i<nxyl;i++) imglow[i] = 0;
  iat = 0; iatnext = 0; yat = IMMATERIAL;
  nat = nbyte = nltp = nex = ntp = ndp = nencode = nstuff = 0;
  lspecial = 1; 
  is = 0;
  for(j=0;j<2*(nyl+LCLCD);j++) {
/*********************** Zero latency processing ******************************/
    iyh = j; iyl = iyh>>1; irow = iyh&1;
    phm2s = MODHGH(-2); phm1s = MODHGH(-1); php0s = MODHGH( 0);
    plm1s = MODLOW(-1); plp0s = MODLOW( 0);
    if(encode && iyh<nyh) {		/* Read image */
      for(php0=php0s;php0<php0s+nxh;php0++) IREAD(*php0,phf);
      rbit = 8; }
    if(encode && iyh==nyh && iyl<nyl)	/* Replicate high for PRES */
      for(php0=php0s,phm1=phm1s;php0<php0s+nxh;php0++,phm1++) *php0 = *phm1;
    if(encode && irow && iyl<nyl) {	/* Color and write low resolution */
      phm2 = phm2s; phm1 = phm1s; php0 = php0s;
      plm1 = plm1s; plp0 = plp0s-1;
      state = 0;
      for(ixl=0;ixl<nxl;ixl++) {
        state = ((state<<2)&0x124) + ((*phm2++)<<7) + ((*phm1++)<<4)
	      + ((*php0++)<<1) + ((*(plm1-1))<<11);
        state += ((*phm2++)<<6) + ((*phm1++)<<3) + (*php0++)
	      + ((*plm1++)<<10) + ((*plp0++)<<9);
	*plp0 = pres[state];
	IWRITE(*plp0,plf); }
      if(wbit!=0) { FPC(wchar,plf); wbit = 0; wchar = 0; } }
    if(decode && irow && iyl<nyl) {	/* Read low resolution */
      for(plp0=plp0s;plp0<plp0s+nxl;plp0++) IREAD(*plp0,plf);
      rbit = 8; }
/*********************** Latent processing ************************************/
    iyh = j-2*LCLCD; ivh = iyh%nvh; iyl = iyh>>1; ivl = ivh>>1; irow = iyh&1; 
    if(iyh>=0 && iyh<nyh) {
/*********************** Per stripe initialization ****************************/
      if(ivh==0) {
	if(encode) {
	  sdestrt[ip][id][is] = (int)ftell(pxf);
	  (void)einit();
	  atcheck = encode && natc!=1? 1:0;
	  atall = 0; for(i=0;i<natc;i++) atc[i] = 0; }
        else {
	  if(fseek(pbf,(long)sdestrt[ip][id][is],0)) E0(bad seek);
	  pacfeed = 0; (void)dinit(); } }
      ATMV;
      phm2s = MODHGH(-2); phm1s = MODHGH(-1); php0s = MODHGH( 0);
      plm1s = MODLOW(-1); plp0s = MODLOW( 0); plp1s = MODLOW( 1);
      phats = iat==0? phm1s-1: php0s-iat-2;
      if(ivl==nvl-1 || iyl==nyl-1) plp1s = plp0s;
/* 6 7 8
   3 4 5
   0 1 2 */
      plm1 = plm1s; plp0 = plp0s; plp1 = plp1s;
      if(tpdon && !irow) {		/* Preprocessing for TP */
	tpcolor = ((*plm1++)<<8) + ((*plp0++)<<5) + ((*plp1++)<<2);
	for(ixl=0;ixl<nxl;ixl++) {
	  tpcolor = ((tpcolor>>1)&0xdb)
	          + ((*plm1++)<<8) + ((*plp0++)<<5) + ((*plp1++)<<2);
	  solid[ixl] = tpcolor==511 || tpcolor==0; }
	if(decode) lspecial = decoder(&cstate[TPDCTX],&mps[TPDCTX]);
	if(encode) {
	  lspecial = 0;
	  for(ixl=0,plp0=plp0s,php0=php0s;ixl<nxl;ixl++,plp0++,php0+=2) {
	    if(solid[ixl]) {
	      if(*(php0      ) != *plp0) { nex++; lspecial = 1; }
	      if(*(php0+1    ) != *plp0) { nex++; lspecial = 1; }
	      if(*(php0  +nrh) != *plp0) { nex++; lspecial = 1; }
	      if(*(php0+1+nrh) != *plp0) { nex++; lspecial = 1; } } }
	  (void)encoder(lspecial,&cstate[TPDCTX],&mps[TPDCTX]); }
	nltp += (1-lspecial); }
      slideok = 0;
      for(ixh=0;ixh<nxh;ixh++) {
        ixl = ixh>>1; icol = ixh&1; iph = irow+irow+icol;
	if(!lspecial && solid[ixl]) {
          slideok = 0; ntp++; if(decode) *(php0s+ixh) = *(plp0s+ixl); }
        else {				/* TP has missed */
/*     5            3 2
    (4)3 2          1 0
   1 0                   */
	  if(!slideok) {
	    slideok = 1;
	    phat = phats+ixh;
	    phm2 = phm2s+ixh; phm1 = phm1s+ixh;   php0 = php0s+ixh-2;
	    plm1 = plm1s+ixl; plp0 = plp0s+ixl-1; plp1 = plp1s+ixl-1;
	    cxhgh  = ((*phm1++)<<2) + ((*php0++)   );
	    cxlow  = ((*plp0++)<<3) + ((*plp1++)<<1);
	    cxlow += ((*plp0++)<<2) + ((*plp1++)   ); }
	  cxhgh = ((cxhgh<<1)&0xa) + ((*phm2++)<<5) + ((*phat++)<<4)
		+ ((*phm1++)<<2) + ((*php0++)   );
	  if(icol) cxlow = ((cxlow<<1)&0xa) + ((*plp0++)<<2) + ((*plp1++)   );
	  if(iph==0) {
	    dpstate = ((*(php0-1))<<7) + ((*(phm1-1))<<6) + ((*(phm1-2))<<5)
		    + ((*(phm1-3))<<4) + ((*(plp0-1))<<3) + ((*(plp0-2))<<2)
		    + ((*(plm1  ))<<1) + ((*(plm1-1))   ) ;
	    plm1++; }
	  else {
	    if(iph==2) dpstate = dpnext[ixl]+((*(php0-1))<<10);
	    else dpstate = dpnext[ixl]; }
	  dptable = dppredict[iph][dpstate];
	  if(dptable!=DPMISS) {
	    ndp++;
	    if(encode) { if(*php0 != dptable) E0(DP problems); }
	    else *php0 = dptable; }
	  else {			/* TP and DP have missed */
	    nencode++;
	    state = (cxhgh<<6) + (cxlow<<2) + iph;
	    if(encode) (void)encoder((int)*php0,&cstate[state],&mps[state]);
	    else *php0 = decoder(&cstate[state],&mps[state]);
	    ATCOUNT(-1,2); }
	  dpnext[ixl] = dpstate + (*(php0s+ixh)<<(8+iph+irow)); } }
      if(decode) {
        for(php0=php0s;php0<php0s+nxh;php0++) IWRITE(*php0,phf); }
/*********************** Line end processing **********************************/
      ATSWOK;
      if(decode && wbit!=0) { FPC(wchar,phf); wbit = 0; wchar = 0; }
/*********************** End of stripe processing *****************************/
      if(ivh==nvh-1 || iyh==nyh-1) {
        if(encode) {
	  (void)eflush(); XPUT(ESC); XPUT(SDNORM);
	  sdelgth[ip][id][is] = (int)ftell(pxf)-sdestrt[ip][id][is]; }
	is++; } } }
  FPF(psf,"%3d%3d%5d%5d%9d%9d%9d%9d%9d%9d\n",ip,id,nat,nltp,
    nex,ntp,ndp,nencode,nbyte,nstuff);
  FCLOSE(phf); FCLOSE(plf);
  return;
}

dread()
{
  int i;
  if(pacfeed) return 0;
  else {
    loop: if((i=getc(pbf))!=ESC) { nbyte++;  return i; }
    else switch(getc(pbf)) {
      case STUFF: nstuff++; nbyte++; return(ESC);
      case ATMOVE: {
        if(getc(pbf)!=0) E0(impossibly large yat);
        if(getc(pbf)!=0) E0(impossibly large yat);
	yat = getc(pbf); yat = (yat<<8) + getc(pbf);
	iatnext = getc(pbf); if(iatnext>0) iatnext -= 2;
        if(getc(pbf)!=0) E0(no support for MY != 0);
	goto loop; }
      case SDNORM:  pacfeed = 1; return 0;
      case SDRST: E0(no support for SDRST);
      case EOF: E0(EOF in dread);
      default: E0(DBID problem in switch); } }
  return 0;				/* keeps lint happy */
}

ewrite(c)
int c;
{
  nbyte++;
  XPUT(c);
  if(c==ESC) { XPUT(STUFF); nstuff++; }
  return 0;
}

int partition(pf)
FILE *pf;
{
  int c,i,inside,nsde;
  nsde = 0;
  inside = 0;
  loop: if((c=getc(pf))==EOF) E0(bie partitioning error);
  nsde++;
  if(c==ESC) {
    if((c=getc(pf))==EOF) E0(bie partitioning error);
    nsde++;
    switch(c) {
      case STUFF:   inside = 1; break;
      case SDNORM:  return nsde;
      case SDRST:   return nsde;
      case ATMOVE:
        if(inside) E0(bie partitioning error);
        for(i=0;i<6;i++) { if(getc(pf)==EOF) E0(bie partitioning error); }
        nsde += 6; break;
      default: E0(unrecognized marker); } }
  else inside = 1;
  goto loop;
}
