/*
 *                 (c) Copyright AT&T 1991.
 *
 * License granted for use only in connection with ISO and CCITT evaluations.
 *     AT&T offers no warranties of any kind, expressed or implied.
 *     Contact D. L. Duttweiler (d.l.duttweiler@att.com) for email copies.
 */

/*
 * Version S1R4.1
 */

/*
 * Encoder Usage:
 *	einit()
 *	while("symbols to encode") encoder(symbol,&st[cx],&mps[cx])
 *		where	symbol = 1 or 0
 *			st[NCX] and mps[NCX] are arrays of integers
 *			that are allocated and initialized in
 *			the calling routine.  The dimension NCX must at
 *			least equal the number of contexts.
 *	eflush()
 *
 * Decoder Usage:
 *	dinit()
 *	while(symbols to decode) symbol = decoder(&st[cx],mps[cx])
 *
 * External routines:
 *	ewrite(byte)
 *	byte = dread()
 */

#include <stdio.h>
#include "qm.h"

#define EUP		{ *pst = nmps[*pst]; }
#define SUP		{ *pmps = swtch[*pst]? 1-*pmps: *pmps; \
			  *pst = nlps[*pst]; }
#define BYTEIN		{ c += (unsigned)dread()<<8; ct = 8; }
#define RENORME		while(a<0x8000) { \
			  a <<= 1; c <<= 1; ct--; \
			  if(ct==0) (void)byteout(); }
#define RENORMD		do { \
			  if(ct==0) BYTEIN; \
			  a <<= 1; c <<= 1; ct--; } while(a<0x8000);
#define OUT(A)		if(stflag) stflag = 0; else { \
			  if((A)==0) nzero++; \
			  else { \
			    while(nzero>0) {nzero--; (void)ewrite(0x00);} \
			    (void)ewrite(A); } }
#define OUT00		if(stflag) stflag = 0; else nzero++;
#define OUTFF		if(stflag) stflag = 0; else { \
			  while(nzero>0) {nzero--; (void)ewrite(0x00);} \
			  (void)ewrite(0xFF); }

static unsigned c;			/* Coding register */
static int a;				/* Size of coding interval*/
static int stflag;			/* Flag to inhibit first write */
static int nzero;			/* Potential trailing zeros */
static int sc;				/* Number of FF bytes */
static int buffer;			/* Bits buffered for output or input */
static int ct;				/* Shift counter */

decoder(pst,pmps)
int *pst,*pmps;
{
  int pix;
  a -= lsz[*pst];
  if((c>>16) < a) {
    if(a<0x8000) { 
      if(a < lsz[*pst]) { pix = 1-*pmps; SUP; } else { pix = *pmps; EUP; }
      RENORMD }
    else pix = *pmps; }
  else {
    if(a<lsz[*pst]) { pix= *pmps;
      c -= (unsigned)a<<16; a=lsz[*pst]; EUP; RENORMD }
    else { pix = 1-*pmps;
      c -= (unsigned)a<<16; a=lsz[*pst]; SUP; RENORMD } }
  return pix;
}

dinit()
{
  c = 0; BYTEIN; c <<= 8; BYTEIN; c <<= 8; BYTEIN;
  a = 0x10000;
  return 0;
}

einit()
{
  c = 0; a = 0x10000;
  buffer = 0x00; nzero = 0; stflag = 1; sc = 0; ct = 11;
  return 0;
}

encoder(pix,pst,pmps)
int *pmps,*pst,pix;
{
  a -= lsz[*pst];
  if(pix==*pmps) { if(a<0x8000) {
    if(a<lsz[*pst]) { c += a; a = lsz[*pst]; }
    EUP; RENORME } }
  else {
    if(a>=lsz[*pst]) { c += a; a = lsz[*pst]; }
    SUP; RENORME }
  return 0;
}

eflush()
{
  int temp;
  temp = (c+a-1)&0xffff0000;
  if(temp<c) c = temp+0x8000; else c = temp;
  c <<= ct;
  if(c>0x7ffffff) { OUT(buffer+1) while(sc>0) { sc--; OUT00 } }
  else { OUT(buffer) while(sc>0) { sc--; OUTFF } }
  OUT((int)((c>>19)&0xff))
  OUT((int)((c>>11)&0xff))
  return 0;
}

static byteout()
{
  int temp;
  temp = (c>>19)&0x1ff;
  if(temp>0xff) {
    OUT(buffer+1) while(sc>0) { sc--; OUT00 } buffer = temp&0xff; }
  else {
    if(temp==0xff) sc++;
    else {
      OUT(buffer) while(sc>0) { sc--; OUTFF } buffer = temp; } }
  c &= 0x7ffff; ct = 8;
  return 0;
}
