/*
 * Decompiled with CFR 0.152.
 */
package jde.debugger.command;

import com.sun.jdi.ObjectReference;
import com.sun.jdi.ThreadGroupReference;
import com.sun.jdi.ThreadReference;
import java.util.Iterator;
import jde.debugger.Etc;
import jde.debugger.JDEException;
import jde.debugger.command.DebugProcessCommand;

public class Resume
extends DebugProcessCommand {
    public void doCommand() throws JDEException {
        if (this.args.size() > 0) {
            Iterator it = this.args.iterator();
            while (it.hasNext()) {
                Long uniqueID = Etc.safeGetLong(it.next(), "thread(group)");
                ObjectReference oRef = this.proc.getStore().get(uniqueID);
                if (oRef == null) {
                    throw new JDEException("Invalid ThreadID, or the thread/threadgroup is dead");
                }
                if (oRef instanceof ThreadReference) {
                    ((ThreadReference)oRef).resume();
                    continue;
                }
                if (oRef instanceof ThreadGroupReference) {
                    ((ThreadGroupReference)oRef).resume();
                    continue;
                }
                throw new JDEException("The object is not a thread or a threadgroup");
            }
            this.jde.signalCommandResult(this.procID, this.cmdID);
        } else {
            try {
                this.proc.getVM().resume();
                this.jde.signalCommandResult(this.procID, this.cmdID);
            }
            catch (Exception ex) {
                throw new JDEException("Unable to resume the application");
            }
        }
    }

    public Object clone() {
        return new Resume();
    }
}

