/*
 * Decompiled with CFR 0.152.
 */
package jde.debugger.command;

import java.util.List;
import jde.debugger.Debug;
import jde.debugger.JDE;
import jde.debugger.JDEException;
import jde.debugger.Jdebug;
import jde.debugger.ProcessRegistry;
import jde.debugger.Protocol;
import jde.debugger.command.CommandRegistry;

public abstract class DebugCommand
extends Thread
implements Protocol,
Cloneable {
    Integer procID;
    Integer cmdID;
    String cmdName;
    List args;
    protected JDE jde = JDE.getJDE();
    protected Jdebug jdebug = Jdebug.getTheDebugger();
    protected ProcessRegistry procRegistry = ProcessRegistry.getRegistry();

    public DebugCommand() {
        super("JDEbug command");
    }

    public void init(Integer procID, Integer cmdID, String cmdName, List args) throws JDEException {
        this.procID = procID;
        this.cmdID = cmdID;
        this.cmdName = cmdName;
        this.args = args;
        this.setName("JDEbug command(" + procID + " " + cmdID + " " + cmdName + ")");
    }

    protected abstract void doCommand() throws JDEException;

    public void run() {
        CommandRegistry commandRegistry = CommandRegistry.getTheRegistry();
        if (commandRegistry.commandExists(this.cmdID)) {
            this.jde.signalCommandError(Jdebug.debuggerID, Jdebug.debuggerID, "Duplicate cmd_id '" + this.cmdID + "'");
            return;
        }
        commandRegistry.addCommand(this.cmdID);
        try {
            try {
                this.doCommand();
            }
            catch (JDEException ex) {
                Debug.printIf(ex);
                this.jde.signalCommandError(Jdebug.debuggerID, this.cmdID, ex.getMessage());
                Object var5_3 = null;
                commandRegistry.removeCommand(this.cmdID);
                return;
            }
            catch (Exception ex) {
                Debug.printIf(ex);
                this.jde.signalCommandError(Jdebug.debuggerID, this.cmdID, "Unspecified error: " + ex.toString());
                Object var5_4 = null;
                commandRegistry.removeCommand(this.cmdID);
                return;
            }
            Object var5_2 = null;
            commandRegistry.removeCommand(this.cmdID);
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            commandRegistry.removeCommand(this.cmdID);
            throw throwable;
        }
    }

    public abstract Object clone();
}

