(defvar ws:xa-cb-terminate (intern-atom "_CB_TERMINATE"))
(defvar ws:xa-cb-editable (intern-atom "_CB_EDITABLE"))
(defvar ws:xa-cb-true (intern-atom "_CB_TRUE"))
(defvar ws:xa-cb-false (intern-atom "_CB_FALSE"))

;;; value of a client message is ( type source . data )
;;;
(defun ws:handle-terminate (type data screen)

  "Handle the receipt of a CB_TERMINATE client message"

  (delete-screen screen)
)

(defun ws:handle-editable (type data screen)

  "Handle the receipt of a CB_EDITABLE message"

  (let*
    (
      (data (cddr value))
      (flag (if (listp data) (car data) data))
      (buff (window-buffer (epoch::selected-window screen)))
    )
    (setq bob flag)
    (save-excursion (set-buffer buff)
      (setq buffer-read-only (not (equal flag ws:xa-cb-true)))
      (redisplay-screen screen)
)))

(pop-message ws:xa-cb-editable)
(push-message ws:xa-cb-editable 'ws:handle-editable)

(defun ws:screen-cleanup () (interactive)

  "Cleanup all psuedo-dead screens. This is a screen whose X window
has been destroyed, but is still present in Epoch. All such screens
are deleted by this function, WITHOUT MERCY!."

  (let ((count 0))
    (dolist (s (screen-list t))
      (when (not (query-tree s))
	(delete-screen s)
	(incf count)
    ))
    (if (> count 0)
      (message (format "Terminated %d screens" count))
      (message "No screens were purged")
)))
