/* This file is part of the 
 *
 *	Delta Project  (ConversationBuilder)  
 *	Human-Computer Interaction Laboratory
 *	University of Illinois at Urbana-Champaign
 *	Department of Computer Science
 *	1304 W. Springfield Avenue
 *	Urbana, Illinois 61801
 *	USA
 *
 *	c 1989,1990,1991,1992 Board of Trustees
 *		University of Illinois
 *		All Rights Reserved
 *
 * This code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY. No author or distributor accepts
 * responsibility to anyone for the consequences of using this code
 * or for whether it serves any particular purpose or works at all,
 * unless explicitly stated in a written agreement.
 *
 * Everyone is granted permission to copy, modify and redistribute
 * this code, except that the original author(s) must be given due credit,
 * and this copyright notice must be preserved on all copies.
 *
 *	Author:  Alan Carroll (carroll@cs.uiuc.edu)
 *      Modified:  Doug Bogia (bogia@cs.uiuc.edu)
 *
 *	Project Leader:  Simon Kaplan (kaplan@cs.uiuc.edu)
 *	Direct enquiries to the project leader please.
 */


/*	util.c: Various utility routines. */
/* widget server utilities */
/* $Source: /export/kaplan/stable/sun4.os4.1/cb-2.0/src/data/node123.text,v $ */

static char rcsid[] = "util.c $Revision: 1.0.1.3 $ $Date: 92/05/28 09:21:49 $ $State: Exp $ $Author: CBmgr $";

/* ------------------------------------------------------------------------ */
#include "header.h"
#include <Xm/PushB.h>
#include <Xm/CascadeB.h>
#include <Xm/CascadeBG.h>
#include <Xm/Label.h>
#include <Xm/LabelG.h>
#include <Xm/Form.h>
#include <Xm/Frame.h>
/* ------------------------------------------------------------------------ */
void
fatal_error(str) char *str;
{
  fprintf(stderr, "%s\n", str);
  exit(1);
}
/* ------------------------------------------------------------------------ */
/* Return a duplicate of the nth element in a list, so that it doesn't get
 * free'd later on.
 */
t_sexp
Getnth(sexp, n)
     t_sexp sexp;
     int n;
{
  if (!MB_CONSP(sexp)) return NULL;
  return MBduplicate(MBnth(sexp, n));
}
/* ------------------------------------------------------------------------ */
XmString
CtoXmString(str) char *str;
{
  XmString xm_string = NULL;
  if (NULL != str)
    xm_string = XmStringCreateLtoR(str, XmSTRING_DEFAULT_CHARSET);
  if (NULL == xm_string)
    xm_string = XmStringCreate("", XmSTRING_DEFAULT_CHARSET);
  return xm_string;
}
/* ------------------------------------------------------------------------ */
void
WidgetAtMouse(w) Widget w;
{
  Window root, child;
  int x, y, root_x, root_y;
  unsigned int state;
  Dimension width, height;

  /* Where is the mousie? */
  XQueryPointer(XtDisplay(w), RootWindowOfScreen(XtScreen(w)),
		&root, &child, &root_x, &root_y, &x, &y, &state);
  /* get the size of the widget, and offset by half that */
  XtVaGetValues(w, XmNwidth, &width, XmNheight, &height, NULL);

  /* If no size yet, use a small value */
  if (width < 10) width = 10;
  if (height < 10) height = 10;

  /* Move it! */
  XtVaSetValues(w, XmNx, x - (width/2), XmNy, y - (height/2), NULL);
}
/* ------------------------------------------------------------------------ */
void
SetPositionArgs(argl) Arg *argl;
{
  Window root, child;
  int x, y, root_x, root_y;
  unsigned int state;
  
  XQueryPointer(XtDisplay(toplevel_widget),
		RootWindowOfScreen(XtScreen(toplevel_widget)),
		&root, &child, &root_x, &root_y, &x, &y, &state);
  XtSetArg(argl[0], XmNx, x);
  XtSetArg(argl[1], XmNy, y);
}
/* ------------------------------------------------------------------------ */
void
WindowAtMouse(w) Widget w;
{
  Window root, child;
  int x, y, root_x, root_y;
  unsigned int state;
  
  XQueryPointer(XtDisplay(w), RootWindowOfScreen(XtScreen(w)),
		&root, &child, &root_x, &root_y, &x, &y, &state);
  XMoveWindow(XtDisplay(w), XtWindow(w), x, y);
}
/* ------------------------------------------------------------------------ */
Widget
CreateTitle(title,parent)
     char *title;
     Widget parent;
{
  Widget label;
  Arg argl[1];
  XmString xm_title = XmStringCreateLtoR(title, XmSTRING_DEFAULT_CHARSET);

  XtSetArg(argl[0], XmNlabelString, xm_title);
  label = XtCreateWidget("title", xmLabelGadgetClass,
			 parent, argl, XtNumber(argl));
  XmStringFree(xm_title);

  return label;
}
/* ------------------------------------------------------------------------ */
char *
SetTitle(w, title)
     Widget w;
     char *title;
{
  Arg argl[1];
  XmString xm_string;

  xm_string = XmStringCreate(title, XmSTRING_DEFAULT_CHARSET);
  XtSetArg(argl[0], XmNlabelString, xm_string);
  XtSetValues(w, argl, XtNumber(argl));
  XmStringFree(xm_string);

  return title;
}
/* ------------------------------------------------------------------------ */
Widget
CreatePushButton(title,parent,func, data)
     char *title;
     Widget parent;
     void (*func)();
     caddr_t data;
{
  Widget button;
  Arg argl[1];
  XmString xm_title = XmStringCreate(title, XmSTRING_DEFAULT_CHARSET);

  XtSetArg(argl[0], XmNlabelString, xm_title);
  button = XtCreateManagedWidget("label", xmPushButtonWidgetClass,
				  parent, argl, XtNumber(argl));

  if (NULL != func) XtAddCallback(button, XmNactivateCallback, func, data);

  XmStringFree(xm_title);

  return button;
}
/* ------------------------------------------------------------------------ */
Widget
CreateSubmenuButton(title, parent, sub_menu)
     char *title;
     Widget parent;
     Widget sub_menu;
{
  Arg argl[2];
  Widget button;
  XmString xm_title = XmStringCreate(title, XmSTRING_DEFAULT_CHARSET);

  XtSetArg(argl[0], XmNlabelString, xm_title);
  XtSetArg(argl[1], XmNsubMenuId, sub_menu);

  button = XtCreateManagedWidget("submenu", xmCascadeButtonGadgetClass,
				 parent, argl, XtNumber(argl));
  XmStringFree(xm_title);
  return button;
}
/*----------------------------------------------------------------------*/
int
CountWidgetList(list)
  t_generic_widget list;
{
  t_generic_widget item;
  int count;
  for ( count = 0, item = list ; NULL != item ; item = item->next, ++count )
    ;
  return count;
}  
/* ------------------------------------------------------------------------ */
int
ManageWidgetList(list)
     t_generic_widget list;
{
  int count;
  Widget *child;
  t_generic_widget item;

  if (NULL == list) return 0;

  count = CountWidgetList(list);
  child = (Widget *) XtMalloc(count * sizeof(Widget));
  for ( count = 0, item = list ; NULL != item ; item = item->next, ++count )
    child[count] = item->widget;
  XtManageChildren(child, count);

  return count;
}
/* ------------------------------------------------------------------------ */
void
UpdateWidgetList(list, sexp)
     t_generic_widget list;
     t_sexp sexp;
{
  t_generic_widget next;

  /* Watch out, an update message can cause a widget to disappear out
   * of the linked list
   */
  while (NULL != list)
    {
      next = list->next;
      list->class->update(list, sexp);
      list = next;
    }
}
/* ------------------------------------------------------------------------ */
void
EditableWidgetList(list, flag)
     t_generic_widget list;
     int flag;
{
  for ( ; NULL != list ; list = list->next )
    list->class->editable(list, flag);
}
/* ------------------------------------------------------------------------ */
void
TransmitWidgetList(message, orig_reply, list)
  t_sexp message;
  t_mbus_reply orig_reply;
  t_generic_widget list;
{
  for ( ; NULL != list ; list = list->next )
    list->class->transmit(message, orig_reply, list);
}
/* ------------------------------------------------------------------------ */
void
RemoveWidgetList(list) t_generic_widget list;
{
  t_generic_widget next;

  while (NULL != list)
    {
      next = list->next;		/* have to save this because */
      list->class->remove(list);	/* this free()'s the item */
      list = next;			/* move to next item */
    }
}
/* ------------------------------------------------------------------------ */
t_generic_widget
RemoveChildFromList(list, child)
     t_generic_widget list;
     t_generic_widget child;
{
  t_generic_widget prev, item;

  if (list == child) return list->next;

  for ( prev = list, item = list->next
       ; NULL != item
       ; prev = item, item = item->next)
    {
      if (item == child)
	{
	  prev->next = item->next;
	  break;
	}
    }
  return list;
}
/* ------------------------------------------------------------------------ */
void
ChildSetSensitive(list, id, flag)
     t_generic_widget list;		/* list of children */
     t_sexp id;				/* identifier */
     Boolean flag;			/* sensitive flag */
{
  for ( ; NULL != list ; list = list->next )
    {
      if (MBequal(id, list->id)) XtSetSensitive(list->widget, flag);
    }
}
/* ------------------------------------------------------------------------ */
char *
strdup(s) char *s;
{
  char *new;
  if (NULL == s) return NULL;
  new = (char *)XtMalloc(strlen(s)+1);
  strcpy(new,s);
  return new;
}
/* ------------------------------------------------------------------------ */
int
CalcColumns(n) int n;			/* n is the number of items */
{
  int c, c_count, f, f_count, c_spill, f_spill;

  /* Find the ceil of the sqrt. Since we expect the number of fields
   * to be small (< 10), this is reasonably efficient.
   */
  for ( c = 1 ; c * c < n ; ++c )
    ;

  c_count = c * c;			/* number of slots for ceiling */
  if (c_count == n) return c;
  f = c - 1;
  f_count = f * f;
  c_spill = c_count - n;
  f_spill = n - f_count;

  return c_spill < f_spill ? c : f;
}
/* ------------------------------------------------------------------------ */
/* If the argument is a list, return the C string representation of the list,
 * minus leading and trailing parens
 */
char *
ContextString(sexp) t_sexp sexp;
{
  char *s = NULL;
  t_sexp result;

  if (!NULLP(sexp))
    {
      result = MBprint(sexp, NULL);
      if (MB_CONSP(sexp))
	{
	  s = MBCsubstring(result, 0, -1);
	  *s = ' ';			/* add a space, remove open paren */
	}
      else
	s = MBCstring(result);

      MBfree(result);
    }
  return s;
}
/* ------------------------------------------------------------------------ */
void
GenericReply(self, reply)
     t_generic_widget self;
     t_mbus_reply reply;
{
  self->parent->class->reply(self->parent, reply);
}
/* ------------------------------------------------------------------------ */
void
SendReply(reply) t_mbus_reply reply;
{
  t_sexp message = MBGetString();
  char *result;
  /* In order the reply, we require a non-NULL reply pointer */
  if (NULL == reply) return;

#ifdef OLD_CODE
  MBtransmit_Cstring(mbus, "( ");
  MBtransmit_Cstring(mbus, reply->header);
  if (reply->wrap) MBtransmit_Cstring(mbus, " (");
  else MBtransmit_Cstring(mbus, " ");
  MBtransmit_Cstring(mbus, reply->tag);
  MBtransmit_Cstring(mbus, " ");
  MBtransmit_Cstring(mbus, reply->args);
  MBtransmit_Cstring(mbus, " ");
  MBtransmit_Cstring(mbus, reply->key);
  MBtransmit_Cstring(mbus, " ");
  MBtransmit_Cstring(mbus, reply->value);
  if (NULL != reply->hook) reply->hook(reply->hook_data);
  MBtransmit_Cstring(mbus, " ");
  MBtransmit_Cstring(mbus, reply->context);
  if (reply->wrap) MBtransmit_Cstring(mbus, "))");
  else MBtransmit_Cstring(mbus, ")");
#else
  /* To actually send the data, the reply needs to be editable and have
   * a header address to send it to.
   */
  if (reply->transmit && reply->header)
  {
    /* We are going to build the message up in a chunk so we can build
     * up multiple outgoing transmit messages at the same time.  Then when
     * they are fully built, we can send them all at once.
     */
    MBput_Cstring(message, "( ");
    MBput_Cstring(message, reply->header);
    if (reply->wrap)
	MBput_Cstring(message, " (");
    else
	MBput_Cstring(message, " ");
    MBput_Cstring(message, reply->tag);
    MBput_Cstring(message, " ");
    MBput_Cstring(message, reply->args);
  }
  /* We pass along the message either way.  This is for safety just in
   * case something that is not editable decides to write data anyway.
   * Also, notice that we call the hook regardless of whether it is
   * editable.  This is done since some of our sub-parts might be editable
   * even though this level isn't.
   */
  if (NULL != reply->hook) reply->hook(message, reply, reply->hook_data);
  if (reply->transmit && reply->header)
  {
    /* Finish off the message */
    MBput_Cstring(message, " ");
    MBput_Cstring(message, reply->key);
    MBput_Cstring(message, " ");
    MBput_Cstring(message, reply->value);
    MBput_Cstring(message, " ");
    MBput_Cstring(message, reply->context);
    if (reply->wrap)
	MBput_Cstring(message, "))");
    else
	MBput_Cstring(message, ")");
    result = MBCstring(message);
    MBtransmit_Cstring(mbus, result);
    free(result);
  }
  MBfree(message);
#endif
}
/* ------------------------------------------------------------------------ */
t_mbus_reply
NewReply()
{
  t_mbus_reply reply = NEW_STRUCT(mbus_reply_struct);

  reply->header = NULL;
  reply->tag = NULL;
  reply->id = NULL;
  reply->args = NULL;
  reply->context = NULL;
  reply->key = NULL;
  reply->value = NULL;
  reply->wrap = 1;
  reply->status = NONE_PROVIDED;
  /* Default is to say the object is transmittable (can be transmitted) */
  reply->transmit = 1;
  reply->hook = NULL;
  reply->hook_data = NULL;

  return reply;
}
/* ------------------------------------------------------------------------ */
void
FreeReply(reply) t_mbus_reply reply;
{
  if (NULL == reply) return;

  XtFree(reply->header);
  XtFree(reply->tag);
  XtFree(reply->id);
  XtFree(reply->args);
  XtFree(reply->context);
  XtFree(reply->key);
  XtFree(reply->value);
  XtFree(reply);
}
/* ------------------------------------------------------------------------ */
void
ReplyCallback(w, thing, data)
     Widget w;
     t_generic_widget thing;
     caddr_t data;
{
  t_mbus_reply reply = NewReply();

  thing->class->reply(thing, reply);
  SendReply(reply);
  FreeReply(reply);
}
/* ------------------------------------------------------------------------ */
char *
QuotifyString(str) char *str;
{
  t_sexp s_str = MBGetString(), tmp;
  char *result;

  MBput_Cstring(s_str, str);
  tmp = MBprint(s_str, NULL);
  result = MBCstring(tmp);
  MBfree(s_str); MBfree(tmp);
  return result;
}
/* ------------------------------------------------------------------------ */
void
SendClientMessage(dpy, window, type, data1, data2)
     Display *dpy;
     Window window;
     Atom type;
     XID data1, data2;
{
  XEvent event;

  memset((char *)&event.xclient.data, 5 * sizeof(XID), 0);
  event.xany.type = ClientMessage;

  event.xclient.window = window;
  event.xclient.data.l[0] = data1;
  event.xclient.data.l[1] = data2;
  event.xclient.format = 32;
  event.xclient.message_type = type;

  XSendEvent(dpy, window, False, 0, &event);
}
/* ------------------------------------------------------------------------ */
int
WXErrorHandler(dpy, error)
     Display *dpy;
     XErrorEvent *error;
{
  char type[64];
  XGetErrorText(dpy, error->error_code, type, 64);
  fprintf(stderr,"X window error %d %s Serial #%d\nOpcode %d . %d\nResource 0x%x\n",
	  error->type, type, error->serial,
	  error->request_code, error->minor_code,
	  error->resourceid);
  return 0;
}
/* ------------------------------------------------------------------------ */
void
ActKeyword(widget, key)
     t_generic_widget widget;
     t_sexp key;
{
  if (!MBcompare_Cstring(key, ":reply"))
    {
      t_mbus_reply reply = NewReply();

      widget->class->reply(widget, reply);
      SendReply(reply);
      FreeReply(reply);
    }
  else if (!MBcompare_Cstring(key, ":transmit"))
    ShellPrepareTransmit(widget->top, NULL);
  else if (!MBcompare_Cstring(key, ":delete-top"))
    XtDestroyWidget(widget->top->widget);
  else if (!MBcompare_Cstring(key, ":unmap-top"))
    XtUnmapWidget(widget->top->widget);
  else if (!MBcompare_Cstring(key, ":map-top"))
    XtMapWidget(widget->top->widget);
  else if (!MBcompare_Cstring(key, ":map"))
    XtMapWidget(widget->widget);
  else if (!MBcompare_Cstring(key, ":unmap"))
    XtUnmapWidget(widget->widget);
}
/* ------------------------------------------------------------------------ */
void
ActMessage(widget, mess, local)
     t_generic_widget widget;
     t_sexp mess;
     int local;
{
  t_sexp tag = MB_CAR(mess);

  /* If the local flag is set and the message is an action (update), then
   * just do the local shell, and bypass the more general mechanisms.
   */
  
  if (local &&
      (!MBcompare_Cstring(tag, "action") || !MBcompare_Cstring(tag, "update"))
      )
    widget->top->class->update(widget->top, mess);
  else HandleBusMessage(mess);
}
/* ------------------------------------------------------------------------ */
void
Act(widget, actions, local)
     t_generic_widget widget;		/* widget that's acting */
     t_sexp actions;			/* actions to perform */
     int local;				/* local actions only? */
{
  t_sexp act;

  act = MB_CAR(actions);

  /* Just a single keyword, just do it and go on. */
  if (MB_NAMEP(actions)) ActKeyword(widget, actions);
  /* not a keyword and not a list, it's bogus, just ignore it */
  else if (!MB_CONSP(actions))
    ;					/* nothing */
  else if (MB_NAMEP(act) && ':' != MBpeek_char(act))
    ActMessage(widget, actions, local);
  else					/* list of things to do */
    {
      while (MB_CONSP(actions))
	{
	  act = MB_CAR(actions);
	  if (MB_NAMEP(act)) ActKeyword(widget, act);
	  else if (MB_CONSP(act)) ActMessage(widget, act, local);
	  actions = MB_CDR(actions);
	}
    }
}
/* ------------------------------------------------------------------------ */
static struct keyword_entry_struct drkw[] =
{
  { ":tag", NULL, KEYWORD_RAW },
  { ":key", NULL, KEYWORD_RAW },
};

t_mbus_reply
ParseReplyList(e) t_sexp e;
{
  t_mbus_reply reply;
  int n;

  reply = NewReply();
  MBparse_keywords(e, drkw, ARRAY_SIZE(drkw));
  n = 0;
  reply->tag = (char *)drkw[n++].result;
  reply->key = (char *)drkw[n++].result;

  return reply;
}
/* ------------------------------------------------------------------------ */

/*
 *  GetColor takes a character string that is the color that the user
 *  desires and a widget (which is always the toplevel widget for us
 *  at least for now, and returns the unsigned long integer representing
 *  the color that the user has selected.  If, for whatever reason, the
 *  color cannot be parsed, then the default foreground color is returned.
*/
Pixel
GetColor (widget, color)
     Widget widget;
     char *color;
{
  XColor c;
  Colormap Cmap;
  Display *dpy;

  dpy = XtDisplay(widget);

  Cmap = DefaultColormap(dpy, DefaultScreen(dpy));

  if (color && XParseColor(dpy, Cmap, color, &c)) {
    c.flags = DoRed + DoGreen + DoBlue;
    if (!XAllocColor(dpy,Cmap,&c))
    {
      if (MBLogLevel > 1) fprintf(stderr, "Unable to alloc color\n");
      return 0;			/* Can't get it, give 'em color 0 */
    }
  }
  return c.pixel;
}

/*
 *  The routine GetFont takes a character string that is the name of
 *  a font, and tries to get a font structure for this font.
*/
XFontStruct *
GetFont(widget, font)
     Widget widget;
     char *font;
{
  Display *dpy;
  XFontStruct *new_font = NULL;

  dpy = XtDisplay(widget);
  if (font)
      new_font = XLoadQueryFont(dpy, font);
  return new_font;		/* Can return NULL */
}
