/* This file is part of the 
 *
 *	Delta Project  (ConversationBuilder)  
 *	Human-Computer Interaction Laboratory
 *	University of Illinois at Urbana-Champaign
 *	Department of Computer Science
 *	1304 W. Springfield Avenue
 *	Urbana, Illinois 61801
 *	USA
 *
 *	c 1989,1990,1991,1992 Board of Trustees
 *		University of Illinois
 *		All Rights Reserved
 *
 * This code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY. No author or distributor accepts
 * responsibility to anyone for the consequences of using this code
 * or for whether it serves any particular purpose or works at all,
 * unless explicitly stated in a written agreement.
 *
 * Everyone is granted permission to copy, modify and redistribute
 * this code, except that the original author(s) must be given due credit,
 * and this copyright notice must be preserved on all copies.
 *
 *	Author:  Alan Carroll (carroll@cs.uiuc.edu)
 *
 *	Project Leader:  Simon Kaplan (kaplan@cs.uiuc.edu)
 *	Direct enquiries to the project leader please.
 */

/*	toggle.c: The toggle (button) widget */
/* widget server toggle support */
/* $Source: /export/kaplan/stable/sun4.os4.1/cb-2.0/src/data/node122.text,v $ */

static char rcsid[] = "toggle.c $Revision: 1.1 $ $Date: 92/05/08 15:25:06 $ $State: Exp $ $Author: CBmgr $";

/* ------------------------------------------------------------------------ */
#include "header.h"
#include <Xm/ToggleBG.h>
/* ------------------------------------------------------------------------ */
extern void
  ToggleRemove(), ToggleUpdate(), ToggleReply(), ToggleRealized(),
  ToggleTransmit(), ToggleEditable();

extern t_generic_widget ToggleHandle();

struct widget_class_struct ToggleClassRecord =
{
  WS_TOGGLE, "toggle",
  ToggleHandle, ToggleRemove, NULL, ToggleUpdate, ToggleReply,
  ToggleRealized, ToggleTransmit, ToggleEditable,
} ;
/* ------------------------------------------------------------------------ */
typedef struct toggle_widget_struct
{
  DECLARE_STANDARD_WIDGET_SLOTS;
  char *key;
  char *set_value;
  char *unset_value;
} * t_toggle_widget;

/* ------------------------------------------------------------------------ */
/* Create a toggle button. The sexp should be of the form
 * (toggle "id" "label" &key :key :set :unset :state :sensitive)
 */
static struct keyword_entry_struct ToggleKeywords[] =
{
  { ":key", NULL, KEYWORD_RAW },
  { ":set", NULL, KEYWORD_RAW },
  { ":unset", NULL, KEYWORD_RAW },
  { ":sensitive", (void*)KEYWORD_FALSE, KEYWORD_FLAG },
  { ":state", (void*)KEYWORD_FALSE, KEYWORD_FLAG },
};

t_generic_widget
ToggleHandle(parent,sexp)
     t_generic_widget parent;
     t_sexp sexp;
{
  t_toggle_widget toggle;
  t_sexp s_label, s_id;
  Boolean sensitive, state;
  char *label;
  XmString xm_label;
  int n, columns;
  Arg argl[10];

  /* check required arguments first */
  s_id = MBnth(sexp,1);
  s_label = MBnth(sexp,2);

  if (NULL == s_id || (!MB_STRINGP(s_label) && !MB_NAMEP(s_label)))
    return NULL;

  toggle = NEW_STRUCT(toggle_widget_struct);
  toggle->type = WS_TOGGLE;
  toggle->next = NULL;
  toggle->parent = parent;
  toggle->top = parent->top;
  toggle->class = &ToggleClassRecord;
  toggle->id = Getnth(sexp, 1);
  label = MBCstring(s_label);
  xm_label = CtoXmString(label);
  
  /* get the keywords */
  MBparse_keywords(MBnthcdr(sexp,3),
		   ToggleKeywords, ARRAY_SIZE(ToggleKeywords));
  toggle->key = (char *)ToggleKeywords[0].result;
  toggle->set_value = (char *)ToggleKeywords[1].result;
  toggle->unset_value = (char *)ToggleKeywords[2].result;
  sensitive = (t_keyword_flag)ToggleKeywords[3].result == KEYWORD_TRUE
    ? True : False;
  state = (t_keyword_flag)ToggleKeywords[4].result == KEYWORD_TRUE
    ? True : False;

  n = 0;
  XtSetArg(argl[n], XmNsensitive, sensitive), ++n;
  XtSetArg(argl[n], XmNset, state), ++n;
  XtSetArg(argl[n], XmNlabelString, xm_label), ++n;
  toggle->widget = XtCreateWidget("toggle", xmToggleButtonGadgetClass,
				    parent->widget, argl, n);

  XtFree(label); XtFree(xm_label);
  return (t_generic_widget)toggle;
}
/* ------------------------------------------------------------------------ */
void
ToggleRemove(self) t_toggle_widget self;
{
  XtFree(self->set_value);
  XtFree(self->unset_value);
  XtFree(self->key);
  XtFree(self);
}
/* ------------------------------------------------------------------------ */
/* Accept an update message and update the toggle */
static struct keyword_entry_struct ToggleUpdateKeys[] =
{
  { ":label", NULL, KEYWORD_COOKED },
  { ":tag", NULL, KEYWORD_RAW },
  { ":value", NULL, KEYWORD_RAW },
};

void
ToggleUpdate(self,sexp)
     t_toggle_widget self;
     t_sexp sexp;
{
}
/* ------------------------------------------------------------------------ */
void
ToggleReply(self, reply)
     t_toggle_widget self;
     t_mbus_reply reply;
{
}
/* ------------------------------------------------------------------------ */
void
ToggleRealized(self) t_toggle_widget self;
{
}
/* ------------------------------------------------------------------------ */
void
ToggleTransmit(message, orig_reply, self)
  t_sexp message;
  t_mbus_reply orig_reply;
  t_toggle_widget self;
{
  if (NULL != self->key)
    {
      MBput_Cstring(message, " ");
      MBput_Cstring(message, self->key);
      if (XmToggleButtonGadgetGetState(self->widget))
	{
	  if (NULL == self->set_value)
	    MBput_Cstring(message, " t");
	  else
	    {
	      MBput_Cstring(message, " ");
	      MBput_Cstring(message, self->set_value);
	    }
	}
      else				/* unset */
	{
	  if (NULL == self->unset_value)
	    MBput_Cstring(message, " nil");
	  else
	    {
	      MBput_Cstring(message, " ");
	      MBput_Cstring(message, self->unset_value);
	    }
	}
    }
}
/* ------------------------------------------------------------------------ */
void
ToggleEditable(self, flag)
     t_toggle_widget self;
     int flag;
{
  XtSetSensitive(self->widget, flag ? True : False);
}
/* ------------------------------------------------------------------------ */
