/* This file is part of the 
 *
 *	Delta Project  (ConversationBuilder)  
 *	Human-Computer Interaction Laboratory
 *	University of Illinois at Urbana-Champaign
 *	Department of Computer Science
 *	1304 W. Springfield Avenue
 *	Urbana, Illinois 61801
 *	USA
 *
 *	c 1989,1990,1991,1992 Board of Trustees
 *		University of Illinois
 *		All Rights Reserved
 *
 * This code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY. No author or distributor accepts
 * responsibility to anyone for the consequences of using this code
 * or for whether it serves any particular purpose or works at all,
 * unless explicitly stated in a written agreement.
 *
 * Everyone is granted permission to copy, modify and redistribute
 * this code, except that the original author(s) must be given due credit,
 * and this copyright notice must be preserved on all copies.
 *
 *	Author:  Alan Carroll (carroll@cs.uiuc.edu)
 *
 *	Project Leader:  Simon Kaplan (kaplan@cs.uiuc.edu)
 *	Direct enquiries to the project leader please.
 */

/*	mbus.h: Internal definitions for MBus structures and functions. */
/* The various structure definitions for the MessageBuss. */
/* $Source: /import/kaplan/kaplan/carroll/cb/mbus/lib/RCS/mbus.h,v $ */

/* $Revision: 2.1.1.2 $
 * $Date: 91/11/15 13:35:20 $
 * $State: Exp $
 * $Author: carroll $
 */

#ifndef MB_MBUS_H
#define MB_MBUS_H
/* ------------------------------------------------------------------------- */

/* Data blocks are the lowest level of storage. These shouldn't been seen
 * very much by the AP code.
 */

typedef unsigned int t_block_int;
typedef unsigned char t_block_char;

#define BLOCK_STUB							\
  t_block_int count;			/* amount of data in block */	\
  t_block_int size;			/* block size */		\
  unsigned int flags;			/* various status flags */	\
  struct mb_block_struct *next		/* linked list */

/* Stub version for size computations (handle possible alignment problems) */
struct mb_block_stub_struct
{
  BLOCK_STUB;
} ;

/* The actual struct */
typedef struct mb_block_struct
{
  BLOCK_STUB;
  t_block_char data[1];			/* the data */
} * t_mb_block;


/* A chunk is a linked list of blocks, containing additional global
 * information about the size of the contents. It can be extended
 * indefinitely (memory limits only)
 */

struct mb_chunk
{
  struct mb_block_struct *head;		/* start of the Chunk */
  t_block_int hindex;			/* head index */
  struct mb_block_struct *tail;		/* end of the Chunk */
  t_block_int tindex;			/* tail index */
  t_block_int count;			/* total size of the Chunk */
};

/* Used for stepping through a chunk, when we only want to look in it
 * and not modify the chunk.
 */
struct mb_chunk_pointer
{
  int c;				/* current char for quick access */
  struct mb_block_struct *block;		/* current block */
  t_block_int index;			/* current block index */
};

/* regular expressions */
struct mb_regexp
{
  t_block_char regstart;		/* Internal use only. */
  t_block_char reganch;		/* Internal use only. */
  t_block_char *regmust;		/* Internal use only. */
  int regmlen;		/* Internal use only. */
  struct mb_block_struct *program; /* Unwarranted chumminess with compiler. */
};

/* magic value for checking validity */
#define	MB_REGEXP_MAGIC	0234

struct mb_cons
{
  struct mb_object *car;
  struct mb_object *cdr;
};

/* Now we need the various object types */

typedef enum
{
  MB_INVALID,				/* 0, make all valid ones non-zero */
  MB_CONS,				/* cons block */
  MB_NAME,				/* a raw chunk */
  MB_STRING,				/* a string stored in a chunk */
  MB_CHUNK_POINTER,			/* pointer into a chunk */
  MB_REGEXP,				/* compiled regular expression */
  MB_RAW,				/* raw data object */
  MB_NULL,				/* the nil object */
} t_mb_object_type;

/* The generic object */

struct mb_object
{
  t_mb_object_type type;
  long check_word;		/* for checking validity of object */
  struct mb_object *next;		/* for GC and free lists */
  unsigned int flags;			/* status flags */
  union
    {
      struct mb_cons cons;
      struct mb_chunk chunk;
      struct mb_chunk_pointer cp;
      struct mb_regexp re;
    } object;
};

/* Definitions for the various status flags for objects and blocks */

#define MB_IN_USE	1		/* not in free list flag */
#define MB_MARKED	2		/* mark flag for GC */

/* Hey, mom, I put the brothers in - "BADC". Lucky you named us with
 * hex constants in mind :-)
 */
#define MB_CHECK_WORD_VALUE 0xBADC1234

#define L_PAREN '('
#define R_PAREN ')'
#define MB_MACRO_CHAR '#'
#define MB_MACRO_RAW_CHAR '!'

/* Parsing structures */

typedef enum
{
  MB_PARSE_NORMAL, MB_PARSE_STRING, MB_PARSE_COMPLETE,
  MB_PARSE_MACRO_START, MB_PARSE_MACRO_LENGTH, MB_PARSE_MACRO_RECOVER,
  MB_PARSE_RAW_READ,
} t_mb_parse_state;

struct mb_parse_state
{
  t_mb_parse_state state;		/* current state */
  int depth;				/* nesting depth */
  struct mb_object *sexp;		/* current object block */
  struct mb_object base;		/* base object block */
  char open;				/* pending open paren? */
  char escape;				/* pending escaped character? */
  char delimiter;			/* saw a delimiter go by */
  char error;				/* set if error encountered */
  long count;				/* macro count value */
};

/* Short cut macros */

#define MB_CONSP(e) ( NULL != (e) && (e)->type == MB_CONS )
#define MB_CAR(e) (MB_CONSP(e) ? (e)->object.cons.car : NULL)
#define MB_CDR(e) (MB_CONSP(e) ? (e)->object.cons.cdr : NULL)
#define MB_SETCAR(e,v) (MB_CONSP(e) ? (e)->object.cons.car = (v) : NULL)
#define MB_SETCDR(e,v) (MB_CONSP(e) ? (e)->object.cons.cdr = (v) : NULL)
#define MB_CHUNKP(e) (NULL != (e) && ((e)->type == MB_NAME || (e)->type == MB_STRING || (e)->type == MB_RAW))
#define MB_NAMEP(e) (NULL != (e) && (e)->type == MB_NAME)
#define MB_STRINGP(e) (NULL != (e) && (e)->type == MB_STRING)
#define MB_RAWP(e) (NULL != (e) && (e)->type == MB_RAW)

/* ------------------------------------------------------------------------- */
/* Various functions */
#ifdef __STDC__
extern struct mb_chunk *MBChunkPutBuffer(struct mb_chunk *, char *, int);
extern int MBChunkMoveN(struct mb_chunk *, struct mb_chunk *, int);
extern int MBChunkDropChars(struct mb_chunk *, int);
extern t_block_char *MBChunkFindSpan(struct mb_chunk *, int *);
extern void MBFreeBlock(t_mb_block);		/* free a data block */
extern t_mb_block MBUpgradeBlock(t_mb_block); /* get a bigger data block */
extern int MBisLargestBlock(t_mb_block);
extern int MBChunkPutChar(struct mb_chunk *, char);
extern int MBChunkGetChar(struct mb_chunk *);
extern struct mb_chunk *MBChunkReset(struct mb_chunk  *);
extern void MBIntializeParseState(struct mb_parse_state *);
extern void MBResetParseState(struct mb_parse_state *);
#else
extern struct mb_chunk *MBChunkPutBuffer();
extern int MBChunkMoveN();
extern int MBChunkDropChars();
extern t_block_char *MBChunkFindSpan();
extern void MBFreeBlock();		/* free a data block */
extern t_mb_block MBUpgradeBlock(); /* get a bigger data block */
extern int MBisLargestBlock();
extern int MBChunkPutChar();
extern int MBChunkGetChar();
extern struct mb_chunk *MBChunkReset();
extern void MBIntializeParseState();
extern void MBResetParseState();

#endif

extern t_mb_block MBGetBlock();	/* get a data block */
extern void MBPrintMemoryUsage();
extern char *MBDumpMemoryUsage();

extern struct mb_object *MBGetObject();

extern struct mb_object *MBExtractSexp();

extern char *MBparse_state_name[];
/* sizeof doesn't work on externs, so we have to do this and take
 * our chances
 */
#define MB_N_PARSE_STATE_NAMES ((int)MB_PARSE_RAW_READ + 1)
/* ------------------------------------------------------------------------- */
#endif /* MB_MBUS_H */
