/* This file is part of the 
 *
 *	Delta Project  (ConversationBuilder)  
 *	Human-Computer Interaction Laboratory
 *	University of Illinois at Urbana-Champaign
 *	Department of Computer Science
 *	1304 W. Springfield Avenue
 *	Urbana, Illinois 61801
 *	USA
 *
 *	c 1989,1990,1991,1992 Board of Trustees
 *		University of Illinois
 *		All Rights Reserved
 *
 * This code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY. No author or distributor accepts
 * responsibility to anyone for the consequences of using this code
 * or for whether it serves any particular purpose or works at all,
 * unless explicitly stated in a written agreement.
 *
 * Everyone is granted permission to copy, modify and redistribute
 * this code, except that the original author(s) must be given due credit,
 * and this copyright notice must be preserved on all copies.
 *
 *	Author:  Alan Carroll (carroll@cs.uiuc.edu)
 *
 *	Project Leader:  Simon Kaplan (kaplan@cs.uiuc.edu)
 *	Direct enquiries to the project leader please.
 */

/*	keyword.h: Definitions for using the keyword package. */
/* Keyword package definitions */
/* $Source: /import/kaplan/kaplan/carroll/cb/mbus/lib/RCS/keyword.h,v $
 * $Revision: 2.1.1.1 $
 * $Date: 91/11/15 13:35:19 $
 * $State: Exp $
 * $Author: carroll $
 */

/* ------------------------------------------------------------------------ */
/* Structures for parsing keyword arguments */

typedef enum
{
  KEYWORD_RAW,				/* Just as it looked when sent */
  KEYWORD_COOKED,			/* parsed version */
  KEYWORD_SEXP,				/* return pointer to sexp */
  KEYWORD_GET_SEXP,			/* remove&return sexp */
  KEYWORD_INT,				/* return an integer */
  KEYWORD_FLAG,				/* flag, missing, nil, or true */
} t_keyword_conversion;

typedef enum
{
  KEYWORD_NONE,				/* no keyword present */
  KEYWORD_TRUE,				/* a non-nil keyword */
  KEYWORD_FALSE,			/* a nil keyword */
} t_keyword_flag;

/* We assume that a void * can hold an int. It should hold any pointer (or
 * the compiler's broken).
 */
typedef struct keyword_entry_struct
{
  char *keyword;			/* name of the keyword */
  void *value;				/* default value */
  t_keyword_conversion type;		/* type of conversion */
  void *result;				/* result */
  int found;				/* flag for internal use */
} * t_keyword_entry;
/* ------------------------------------------------------------------------ */
#define MB_KEYWORDP(x) (MBnamep(x) && ':' == MBpeek_char(x))
/* ------------------------------------------------------------------------ */
#ifdef __STDC__
extern void MBparse_keywords(t_sexp, t_keyword_entry, int);
extern int MBkeywordp(t_sexp);
#else
extern void MBparse_keywords();
extern int MBkeywordp();
#endif
/* ------------------------------------------------------------------------ */
