/* This file is part of the 
 *
 *	Delta Project  (ConversationBuilder)  
 *	Human-Computer Interaction Laboratory
 *	University of Illinois at Urbana-Champaign
 *	Department of Computer Science
 *	1304 W. Springfield Avenue
 *	Urbana, Illinois 61801
 *	USA
 *
 *	c 1989,1990,1991 Board of Trustees
 *		University of Illinois
 *		All Rights Reserved
 *
 *	This file is distributed under license and is confidential
 *
 *	File title and purpose
 *	Author:  Mark Allender (allender@cs.uiuc.edu)
 *               Doug Bogia (bogia@cs.uiuc.edu)
 *
 *	Project Leader:  Simon Kaplan (kaplan@cs.uiuc.edu)
 *	Direct enquiries to the project leader please.
 */
#include "config.h"
#include <stdio.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <Xm/MainW.h>
#include <Xm/Xm.h>
#include <Xm/RowColumn.h>
#include <Xm/DrawingA.h>
#include <Xm/CascadeB.h>
#include <Xm/MessageB.h>
#include <Xm/SelectioB.h>
#include <Xm/FileSB.h>
#include <Xm/PushB.h>
#include <Xm/Label.h>
#include <Xm/LabelG.h>
#include <Xm/Form.h>
#include <Xm/Frame.h>
#include <mbus/api.h>
#include <mbus/keyword.h>
#include "extern.h"
#include "graph.h"

extern Graph *graph;

RemoveDialButton(widget, which_button)
Widget widget;
int which_button;
{
/*
 *  Removes (unmanages) one of the three types of buttons from
 *  a dialog widget
*/
  Widget dead_widget;

  dead_widget = XmMessageBoxGetChild(widget, which_button);
  XtUnmanageChild(dead_widget);
}

void present_help(parent, client_data, call_data)
Widget parent;
caddr_t client_data, call_data;
{
/*
 *  present_help creates a help_widget.
*/

  Widget help_widget;
  Arg args[10];
  int n;
  XmString motif_string, CtoXmString();
  char *message = "There is no help available at this time.";
  char *title = "Browser Help";

/*
 *  Set up the help message
*/

  motif_string = CtoXmString(message);
  n = 0;
  XtSetArg(args[n], XmNmessageString, motif_string); n++;

  help_widget = XmCreateInformationDialog(parent, title, args, n);
/*
 *  Normally, an Information dialog has three buttons:  OK, Cancel,
 *  and Help,  Since this is the help dialog, we get rid of the Cancel
 *  and help buttons, by making them unmanageable.
*/
  RemoveDialButton(help_widget,XmDIALOG_CANCEL_BUTTON);
  RemoveDialButton(help_widget,XmDIALOG_HELP_BUTTON);
  XtManageChild(help_widget);
/*
 *  Free up storage for XmSTring
*/
  XmStringFree(motif_string);
}

Widget CreateMainWindow(parent, width, height)
Widget parent;
int width, height;
{
/*
 *  CreatMainWindow() takes a parent widget, a name, width, and height,
 *  and then creates a main window widget, which will hold an application
 *  mau bar and main area.
*/

  Widget main_window;
  Arg args[10];
  int n;

/*
 *  Set up Main Window options
*/

  n = 0;
  XtSetArg(args[n], XmNwidth, width); n++;
  XtSetArg(args[n], XmNheight, height); n++;

/*
 *  Try with shadow..
*/

/*   XtSetArg(args[n],XmNshadowThickness, 4); n++; */
  XtSetArg(args[n],XmNshowSeparator, True); n++;

/*
 *  Create main window, on which we'll create menu bar.
*/

  main_window = XtCreateManagedWidget("form", xmFormWidgetClass, parent,
				      args, n);
  XtManageChild(main_window);
  return main_window;
}

/*
 *  We need to do some things on input callbacks.  i.e. keypresses,
 *  and button events.  This is the code that handles this.
*/
void
ViewInputCallBack(widget, client_data, draw_struct)
     Widget widget;
     caddr_t client_data;
     XmDrawingAreaCallbackStruct *draw_struct;
{
  struct CallbackInfo CallbackInfo;
  struct FunctionList *CallbackFuncList;
  struct FunctionBindings *CallbackData;
  int mask = 0;
  int(*CallbackFunc)();
  
  /* Ok, here is the deal.  We want to take this input and figure out
   * what key/button was struck.  Then we want to find the callback(s)
   * that the user has associated with that key/button.  We will initialize
   * the CallbackInfo struct with things like the X, Y location where the
   * callback happened, what key/button was used, etc.  Then as each
   * individual callback happens, it needs to request the information 
   * it feels it needs (like the node, edge, region, etc.).  The
   * routine FillCallbackInfo is used to do this.  This routine caches
   * the values so multiple callbacks need not worry about being inefficient.
   * Then when all the callbacks have been called we will update the
   * graph according to the values returned by that callbacks and
   * then free up any space.
   */
  graph = (Graph *)client_data;
  if (!InitCallbackInfo(&CallbackInfo, draw_struct->event))
  {
    return;
  }
  
  CallbackFuncList = FindCallback(&CallbackInfo);
  
  for (; CallbackFuncList; CallbackFuncList = CallbackFuncList->next)
  {
    FindCallbackFunction(CallbackFuncList->function,
			 graph->callback_functions,
			 &CallbackFunc, &CallbackData
			 );
    if (!CallbackFunc)
	FindCallbackFunction(CallbackFuncList->function,
			     CallbackFunctions,
			     &CallbackFunc, &CallbackData
			     );
    if (CallbackFunc)
	mask |= (*CallbackFunc)(&CallbackInfo, CallbackData);
  }
  FreeCallbackInfo(&CallbackInfo);
  UpdateGraph(mask);
}

void
ViewExposeCallBack(widget, client_data, draw_struct)
     Widget widget;
     caddr_t client_data;
     XmDrawingAreaCallbackStruct *draw_struct;
{
  if ((draw_struct->reason == XmCR_EXPOSE) && (XtWindow(widget)) &&
      (draw_struct->event->xexpose.count == 0)) {
    graph = (Graph *)client_data;
    DrawGraph(VIEW_NODES, FALSE);
  }
}

void
ViewResizeCallBack(widget, client_data, draw_struct)
     Widget widget;
     caddr_t client_data;
     XmDrawingAreaCallbackStruct *draw_struct;
{
/*
 *  On resize, we need to get new width and height, and redraw.
 *  Appearantly, we must check and see if the Xevent is not NULL.
 *  Will choke, obviously, if it is, and we don't want that...
*/
  Dimension wd, ht;
  Arg argl[2];

  if ((draw_struct->reason == XmCR_RESIZE) && (XtWindow(widget))) {
    graph = (Graph *)client_data;
    XtSetArg(argl[0],XmNwidth,&wd);
    XtSetArg(argl[1],XmNheight,&ht);
    XtGetValues(widget,argl,2);
    graph->viewing_area.width = wd;
    graph->viewing_area.height = ht;
    AssignNodeLabels();
    graphDetermine();		/* Redetermine to get the scaling right */
  }
}

void
VirtualInputCallBack(widget, client_data, draw_struct)
     Widget widget;
     caddr_t client_data;
     XmDrawingAreaCallbackStruct *draw_struct;
{
/*
 *  We need to do some things on input callbacks.  i.e. keypresses,
 *  and button events.  This is the code that handles this.
*/
  Vertex *node;
  Window root_return, child_return, win;
  int root_x, root_y, win_x, win_y, xmin, ymin, xmax, ymax, temp,
      xdiff, ydiff, width, height;
  unsigned int mask, foreground;
  coord_t scalex, scaley;
  Display *dpy;
  GC gc;

  graph = (Graph *)client_data;
  dpy = XtDisplay(graph->virtual_area.widget);
  win = XtWindow(graph->virtual_area.widget);
  width = graph->virtual_area.width;
  height = graph->virtual_area.height;

  gc = graph->virt_xor_gc;
  XSetFunction(dpy, gc, GXxor);
  foreground = gc->values.foreground;
  XSetForeground(dpy, gc, foreground ^ gc->values.background);
  switch (draw_struct->event->type)
    {
    case ButtonPress:
      switch (draw_struct->event->xbutton.button) {

      case  1: 

	if (draw_struct->event->xbutton.state == ShiftMask) {
	  graph->virtx_min = graph->virty_min = 0.0;
	  graph->virtx_max = graph->virty_max = 1.0;
	}
	else {
	  XSetLineAttributes(dpy, gc, 1, LineOnOffDash, CapButt, JoinMiter);
	  xmin = xmax = draw_struct->event->xbutton.x;
	  ymin = ymax = draw_struct->event->xbutton.y;
	  XClearWindow(dpy, win);
	  DrawAllNodes(VIRT_NODES);
	  DrawRubberBandBox(gc, xmin, ymin, xmax - xmin, ymax - ymin);
	  do
	    {
	      XQueryPointer (dpy, win,
			     &root_return, &child_return,
			     &root_x, &root_y, &win_x, &win_y, &mask);
	      if (xmax != win_x || ymax != win_y)
		{
		  DrawRubberBandBox(gc, xmin, ymin, xmax - xmin, ymax - ymin);
		  xmax = win_x;
		  ymax = win_y;
		  DrawRubberBandBox(gc, xmin, ymin, xmax - xmin, ymax - ymin);
		}
	    } while (mask & Button1Mask);

	  DrawRubberBandBox(gc, xmin, ymin, xmax - xmin, ymax - ymin);

	  if ((xmax < xmin) && (ymax < ymin)) {
	    temp = xmax;  xmax = xmin;  xmin = temp;
	    temp = ymax;  ymax = ymin;  ymin = temp;
	  }
	  else if ((xmax > xmin) && (ymax < ymin)) {
	    temp = ymax; ymax = ymin; ymin = temp;
	  }
	  else if ((xmax < xmin) && (ymax > ymin)) {
	    temp = xmax; xmax = xmin; xmin = temp;
	  }
	  /*
	   *  Don't let them become the same point!!!
	   */
	  if (xmin == xmax)
	    xmax += 2;
	  if (ymin == ymax)
	    ymax += 2;

	  graph->virtx_min = (coord_t)xmin / width;
	  graph->virtx_max = (coord_t)xmax / width;
	  graph->virty_min = (coord_t)ymin / height;
	  graph->virty_max = (coord_t)ymax / height;

	  /* Set the line style back to solid. */
	  XSetLineAttributes(dpy, gc, 1, LineSolid, CapButt, JoinMiter);
	}
	break;
      case 2:
	xmin  = graph->virtx_min * width;
	ymin = graph->virty_min * height;
	xmax = graph->virtx_max * width;
	ymax = graph->virty_max * height;
	XClearWindow(dpy, win);
	DrawAllNodes(VIRT_NODES);
	DrawRubberBandBox(gc, xmin, ymin, xmax - xmin, ymax - ymin);
	win_x = draw_struct->event->xbutton.x;
	win_y = draw_struct->event->xbutton.y; /* temp holding spot */
	if ((win_x >= xmin) && (win_x <= xmax) && 
	    (win_y >= ymin) && (win_y <= ymax)) {
	  do
	    {
	      XQueryPointer (dpy, win,
			     &root_return, &child_return,
			     &root_x, &root_y, &xdiff, &ydiff, &mask);
	      if ((xdiff != win_x) || (ydiff != win_y)) {
		DrawRubberBandBox(gc, xmin, ymin, xmax - xmin, ymax - ymin);
		xmin += (xdiff - win_x);
		xmax += (xdiff - win_x);
		ymin += (ydiff - win_y);
		ymax += (ydiff - win_y);
		win_x = xdiff;
		win_y = ydiff;
		DrawRubberBandBox(gc, xmin, ymin, xmax - xmin, ymax - ymin);
	      }
	    } while (mask & Button2Mask);

	  graph->virtx_min = (coord_t)xmin / width;
	  graph->virtx_max = (coord_t)xmax / width;
	  graph->virty_min = (coord_t)ymin / height;
	  graph->virty_max = (coord_t)ymax / height;
	}
	break;
      }
      break;
    }
  XSetFunction(dpy, gc, GXcopy);
  XSetForeground(dpy, gc, foreground);
  for (node = graph->v; node != NULL; node = node->next) {
    node->x = (coord_t)(1.0 / (graph->virtx_max - graph->virtx_min)) * 
      (node->pos[0] - graph->virtx_min);
    node->y = (coord_t)(1.0 / (graph->virty_max - graph->virty_min)) *
      (node->pos[1] - graph->virty_min);
  }
  if (XtWindow(widget))
      DrawGraph(VIRT_NODES | VIEW_NODES, TRUE);
}

void
VirtualExposeCallBack(widget, client_data, draw_struct)
     Widget widget;
     caddr_t client_data;
     XmDrawingAreaCallbackStruct *draw_struct;
{
  if ((draw_struct->reason == XmCR_EXPOSE) && (XtWindow(widget)) &&
      (draw_struct->event->xexpose.count == 0)) {
    graph = (Graph *)client_data;
    DrawGraph(VIRT_NODES, FALSE);
  }
}

void
VirtualResizeCallBack(widget, client_data, draw_struct)
     Widget widget;
     caddr_t client_data;
     XmDrawingAreaCallbackStruct *draw_struct;
{
/*
 *  On resize, we need to get new width and height, and redraw.
 *  Appearantly, we must check and see if the Xevent is not NULL.
 *  Will choke, obviously, if it is, and we don't want that...
*/
  Dimension wd, ht;
  Arg argl[2];

  if ((draw_struct->reason == XmCR_RESIZE) && (XtWindow(widget))) {
    graph = (Graph *)client_data;
    XtSetArg(argl[0],XmNwidth,&wd);
    XtSetArg(argl[1],XmNheight,&ht);
    XtGetValues(widget,argl,2);
    graph->virtual_area.width = wd;
    graph->virtual_area.height = ht;
    DrawGraph(VIRT_NODES, TRUE);
  }
}

/*
 *  Create the drawing area in which we will actually draw the graphs.
 *  This is not to be confused with the viewing area that is also created
 *  with each graph.  The viewing area will have its own special properties.
*/
Widget
CreateViewingArea(parent, menu_bar)
     Widget parent, menu_bar;
{
  Widget viewing_widget, frame_widget;
  Arg args[10];
  int n;

  n = 0;
  XtSetArg(args[n], XmNresizePolicy, XmRESIZE_ANY); n++;
/*  Attach the botton and left to the form widget itself */
  XtSetArg(args[n], XmNbottomAttachment, XmATTACH_FORM); n++;
  XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM); n++;
/*  The right part of the area gets only to 75% of the screen max. */
  XtSetArg(args[n], XmNrightAttachment, XmATTACH_POSITION); n++;
  XtSetArg(args[n], XmNrightPosition, 75); n++;
/*  Attach the top to the menu bar */
  XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
  XtSetArg(args[n], XmNtopWidget, menu_bar); n++;
  XtSetArg(args[n], XmNshadowThickness, 8); n++;

  frame_widget = XmCreateFrame(parent, "frame", args, n);
  XtManageChild(frame_widget);

  n = 0;
  viewing_widget = XmCreateDrawingArea(frame_widget, "viewingarea", args, n);
  XtManageChild(viewing_widget);

  XtAddCallback(viewing_widget, XmNinputCallback, ViewInputCallBack,
		(caddr_t)graph);
  XtAddCallback(viewing_widget, XmNexposeCallback, ViewExposeCallBack,
		(caddr_t)graph);
  XtAddCallback(viewing_widget, XmNresizeCallback, ViewResizeCallBack,
		(caddr_t)graph);

  return viewing_widget;
}

Widget
CreateVirtualArea(parent, draw_area, menu_bar)
     Widget parent, draw_area, menu_bar;
{
  Dimension wd, ht;
  Widget virtual_widget, frame_widget;
  Arg args[10];
  int n;

  n = 0;
  XtSetArg(args[n], XmNresizePolicy, XmRESIZE_ANY); n++;
/* bottom atttachment should not be at the bottom of the form, make it 40% */
  XtSetArg(args[n], XmNbottomAttachment, XmATTACH_POSITION); n++;
  XtSetArg(args[n], XmNbottomPosition, 45); n++;
/* attach the left part of this area to the graph drawing area */
  XtSetArg(args[n], XmNleftAttachment, XmATTACH_POSITION); n++;
  XtSetArg(args[n], XmNleftPosition, 75); n++;
/*  right attachment to the form itself. */
  XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM); n++;
/*  and top attachment to the menu bar */
  XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
  XtSetArg(args[n], XmNtopWidget, menu_bar); n++;
  XtSetArg(args[n], XmNshadowThickness, 8); n++;

  frame_widget = XmCreateFrame(parent, "frame", args, n);
  XtManageChild(frame_widget);

  n = 0;
  virtual_widget = XmCreateDrawingArea(frame_widget, "virtualarea", args, n);
  XtManageChild(virtual_widget);

  XtAddCallback(virtual_widget, XmNinputCallback, VirtualInputCallBack,
		(caddr_t)graph);
  XtAddCallback(virtual_widget, XmNexposeCallback, VirtualExposeCallBack,
		(caddr_t)graph);
  XtAddCallback(virtual_widget, XmNresizeCallback, VirtualResizeCallBack,
		(caddr_t)graph);

  XtSetArg(args[0],XmNwidth,&wd);
  XtSetArg(args[1],XmNheight,&ht);
  XtGetValues(virtual_widget,args,2);
  graph->virtual_area.width = wd;
  graph->virtual_area.height = ht;
  
  return virtual_widget;
}

/*  Routines from Alan's widget server to make life easier                  */
/* ------------------------------------------------------------------------ */
Widget
CreateTitle(title,parent)
     char *title;
     Widget parent;
{
  Widget label;
  Arg argl[1];
  XmString xm_title = XmStringCreateLtoR(title, XmSTRING_DEFAULT_CHARSET);

  XtSetArg(argl[0], XmNlabelString, xm_title);
  label = XtCreateWidget("title", xmLabelGadgetClass,
			 parent, argl, XtNumber(argl));
  XmStringFree(xm_title);

  return label;
}

/* ------------------------------------------------------------------------ */
Widget
CreatePushButton(title, parent, func, data)
     char *title;
     Widget parent;
     void (*func)();
     caddr_t data;
{
  Widget button;
  Arg argl[1];
  XmString xm_title = XmStringCreate(title, XmSTRING_DEFAULT_CHARSET);

  XtSetArg(argl[0], XmNlabelString, xm_title);
  button = XtCreateManagedWidget("label", xmPushButtonWidgetClass,
				  parent, argl, XtNumber(argl));

  if (NULL != func) XtAddCallback(button, XmNactivateCallback, func, data);

  XmStringFree(xm_title);

  return button;
}

/* ------------------------------------------------------------------------ */
XmString
CtoXmString(str) char *str;
{
  XmString xm_string = NULL;
  if (NULL != str)
    xm_string = XmStringCreateLtoR(str, XmSTRING_DEFAULT_CHARSET);
  if (NULL == xm_string)
    xm_string = XmStringCreate("", XmSTRING_DEFAULT_CHARSET);
  return xm_string;
}

