/* This file is part of the 
 *
 *	Delta Project  (ConversationBuilder)  
 *	Human-Computer Interaction Laboratory
 *	University of Illinois at Urbana-Champaign
 *	Department of Computer Science
 *	1304 W. Springfield Avenue
 *	Urbana, Illinois 61801
 *	USA
 *
 *	c 1989,1990,1991 Board of Trustees
 *		University of Illinois
 *		All Rights Reserved
 *
 *	This file is distributed under license and is confidential
 *
 *	File title and purpose
 *	Author:  Thomas Fruchterman
 *		 John Jozwiak
 *		 Mark Allender (allender@cs.uiuc.edu)
 *               Doug Bogia (bogia@cs.uiuc.edu)
 *
 *	Project Leader:  Simon Kaplan (kaplan@cs.uiuc.edu)
 *	Direct enquiries to the project leader please.
 */

/*
 * This file is to declare all of the external functions.  We will include both
 * prototyped functions, and the more generic no-prototyped
 * functions here as well.
*/

#include "config.h"
#include <X11/Intrinsic.h>
#include <mbus/mbus.h>
#include "graph.h"
#include "callback.h"

#ifndef _EXTERN_H
#define _EXTERN_H

extern Widget toplevel_widget, control_panel;
extern Graph *graph;

extern int AddTypeColors(
#ifndef _NO_PROTO
			 struct mb_object *,
			 struct DisplayTable **
#endif
);
extern void UpdateGraph(
#ifndef _NO_PROTO
			int
#endif
);
extern int NodeFixed(
#ifndef _NO_PROTO
		     Vertex *
#endif
);
extern void FixNode(
#ifndef _NO_PROTO
		    Vertex *
#endif
);
extern void UnfixNode(
#ifndef _NO_PROTO
		      Vertex *
#endif
);
extern void RandomizeNode(
#ifndef _NO_PROTO
			  Vertex *
#endif
);
extern void RandomizeNodes(
#ifndef _NO_PROTO
			  void
#endif
);
extern NodeList *SweptNodes(
#ifndef _NO_PROTO
			    struct CallbackInfo *
#endif
);
extern struct DisplayTable *FindType(
#ifndef _NO_PROTO
				     char *,
				     int
#endif
);
extern void appAFunc(
#ifndef _NO_PROTO
		     Vertex *,
		     Vertex *
#endif
);
extern void appRFunc(
#ifndef _NO_PROTO
		     Vertex *,
		     Vertex *
#endif
);
extern void ClearGraph(
#ifndef _NO_PROTO
		       Graph *
#endif
);
extern void DeleteGraph(
#ifndef _NO_PROTO
			Graph *
#endif
);
extern void AddNodetoList(
#ifndef _NO_PROTO
			  NodeList **,
			  Vertex *
#endif
);
extern void AddEdgetoList(
#ifndef _NO_PROTO
			  EdgeList **,
			  Edge *
#endif
);
extern void RemoveEdgefromList(
#ifndef _NO_PROTO
			       EdgeList **,
			       Edge *
#endif
);
extern void RemoveNodefromList(
#ifndef _NO_PROTO
			       NodeList **,
			       Vertex *
#endif
);
extern void MergeEdgeLists(
#ifndef _NO_PROTO
			   EdgeList **,
			   EdgeList *
#endif
);
extern void FindEdgeNodes(
#ifndef _NO_PROTO
			  Edge *,
			  NodeList **,
			  short *
#endif
);
extern int CompareNodes(
#ifndef _NO_PROTO
			NodeList *,
			NodeList *
#endif
);
extern void FindSameEdges(
#ifndef _NO_PROTO
			  Edge *,
			  EdgeList **,
			  int *
#endif
);
extern int EdgeGoesTo(
#ifndef _NO_PROTO
		      Edge *,
		      Vertex *
#endif
);
extern void GraphReassign(
#ifndef _NO_PROTO
			  coord_t
#endif
);
extern Vertex *NodeLookup(
#ifndef _NO_PROTO
			  char *,
			  Vertex *
#endif
);
extern Edge *EdgeLookup(
#ifndef _NO_PROTO
			char *,
			Edge *
#endif
);
extern EdgeList *SelectedEdges(
#ifndef _NO_PROTO
			void
#endif
);
extern int EdgeSelected(
#ifndef _NO_PROTO
		 Edge *
#endif
);
extern void SelectEdge(
#ifndef _NO_PROTO
		 Edge *
#endif
);
extern void UnselectEdge(
#ifndef _NO_PROTO
		 Edge *
#endif
);
extern NodeList *SelectedNodes(
#ifndef _NO_PROTO
			void
#endif
);
extern int NodeSelected(
#ifndef _NO_PROTO
		 Vertex *
#endif
);
extern void SelectNode(
#ifndef _NO_PROTO
	       Vertex *
#endif
);
extern void UnselectNode(
#ifndef _NO_PROTO
		 Vertex *
#endif
);
extern Graph *GraphLookup(
#ifndef _NO_PROTO
			  char *,
			  struct TableStruct *
#endif
);
extern char * LookupId(
#ifndef _NO_PROTO
		    Graph *
#endif
);
extern Link *AddLink(
#ifndef _NO_PROTO
		     Vertex *,
		     Vertex *,
		     Edge *
#endif
);
extern void AssignStrVal(
#ifndef _NO_PROTO
			 char **,
			 char*,
			 char *
#endif
);
extern void AssignCommons(
#ifndef _NO_PROTO
			  CommonVals *,
			  char *,
			  char *,
			  char *,
			  char *,
			  char *,
			  KeyList*,
			  int,
			  int
#endif
);
extern Vertex * MakeVertex(
#ifndef _NO_PROTO
		       char *, char *, char *, char *, char *, int, 
		       char *, char *, KeyList *
#endif
);
extern Edge *MakeEdge(
#ifndef _NO_PROTO
		      char *, char *, char *, char *, char *, KeyList *
#endif
);
extern void AssignNodeLabels(
#ifndef _NO_PROTO
			     void
#endif
);
extern void FreeCommons(
#ifndef _NO_PROTO
			CommonVals *
#endif
);
extern void DeleteEdge(
#ifndef _NO_PROTO
		       Edge *
#endif
);
extern void DeleteNode(
#ifndef _NO_PROTO
		       Vertex *
#endif
);
extern void SetupBus(
#ifndef _NO_PROTO
		     int, char *
#endif
);
extern Widget CreateMenuBar(
#ifndef _NO_PROTO
			    Widget
#endif
);
extern void present_help(
#ifndef _NO_PROTO
			 Widget, caddr_t, caddr_t
#endif
);
extern Widget CreateMainWindow(
#ifndef _NO_PROTO
			       Widget, int, int
#endif
);
extern Widget CreateDrawingArea(
#ifndef _NO_PROTO
				Widget, Widget
#endif
);
extern Widget CreateViewingArea(
#ifndef _NO_PROTO
				Widget, Widget
#endif
);
extern Widget CreateVirtualArea(
#ifndef _NO_PROTO
				Widget, Widget, Widget
#endif
);
extern Widget CreateTitle(
#ifndef _NO_PROTO
			  char *, Widget
#endif
);
extern Widget CreatePushButton(
#ifndef _NO_PROTO
			       char *, Widget, void (*)(), caddr_t
#endif
);
extern Widget CreateElisionDialog(
#ifndef _NO_PROTO
				  Widget, char *, void (*)()
#endif
);
extern void ManageDialog(
#ifndef _NO_PROTO
			 Widget, caddr_t, caddr_t
#endif
);
extern void UnmanageDialog(
#ifndef _NO_PROTO
			   Widget, caddr_t, caddr_t
#endif
);
extern int RandomizeCallback(
#ifndef _NO_PROTO
			     struct CallbackInfo *, struct FunctionBindings *
#endif
);
extern int ElideNodeCallback(
#ifndef _NO_PROTO
			     struct CallbackInfo *, struct FunctionBindings *
#endif
);
extern int UnelideNodeCallback(
#ifndef _NO_PROTO
			     struct CallbackInfo *, struct FunctionBindings *
#endif
);
extern int ElideSweptNodesCallback(
#ifndef _NO_PROTO
			     struct CallbackInfo *, struct FunctionBindings *
#endif
);
extern int UnelideSweptNodesCallback(
#ifndef _NO_PROTO
			     struct CallbackInfo *, struct FunctionBindings *
#endif
);
extern int ElideSelectedNodesCallback(
#ifndef _NO_PROTO
			     struct CallbackInfo *, struct FunctionBindings *
#endif
);
extern int UnelideSelectedNodesCallback(
#ifndef _NO_PROTO
			     struct CallbackInfo *, struct FunctionBindings *
#endif
);
extern int RedrawCallback(
#ifndef _NO_PROTO
			  struct CallbackInfo *, struct FunctionBindings *
#endif
);
extern int SelectNodeCallback(
#ifndef _NO_PROTO
			  struct CallbackInfo *, struct FunctionBindings *
#endif
);
extern int UnselectNodeCallback(
#ifndef _NO_PROTO
			  struct CallbackInfo *, struct FunctionBindings *
#endif
);
extern int SelectEdgeCallback(
#ifndef _NO_PROTO
			  struct CallbackInfo *, struct FunctionBindings *
#endif
);
extern int UnselectEdgeCallback(
#ifndef _NO_PROTO
			  struct CallbackInfo *, struct FunctionBindings *
#endif
);
extern int SelectSweptNodesCallback(
#ifndef _NO_PROTO
			  struct CallbackInfo *, struct FunctionBindings *
#endif
);
extern int UnselectSweptNodesCallback(
#ifndef _NO_PROTO
			  struct CallbackInfo *, struct FunctionBindings *
#endif
);
extern int FixSweptNodesCallback(
#ifndef _NO_PROTO
			  struct CallbackInfo *, struct FunctionBindings *
#endif
);
extern int UnfixSweptNodesCallback(
#ifndef _NO_PROTO
			  struct CallbackInfo *, struct FunctionBindings *
#endif
);
extern int FixSelectedNodesCallback(
#ifndef _NO_PROTO
			  struct CallbackInfo *, struct FunctionBindings *
#endif
);
extern int UnfixSelectedNodesCallback(
#ifndef _NO_PROTO
			  struct CallbackInfo *, struct FunctionBindings *
#endif
);
extern int UnselectAllCallback(
#ifndef _NO_PROTO
			  struct CallbackInfo *, struct FunctionBindings *
#endif
);
extern int SelectAllCallback(
#ifndef _NO_PROTO
			  struct CallbackInfo *, struct FunctionBindings *
#endif
);
extern int ToggleNamesCallback(
#ifndef _NO_PROTO
			       struct CallbackInfo *, struct FunctionBindings *
#endif
);
extern int MoveNodeCallback(
#ifndef _NO_PROTO
			    struct CallbackInfo *, struct FunctionBindings *
#endif
);
extern int MoveSelectedCallback(
#ifndef _NO_PROTO
			    struct CallbackInfo *, struct FunctionBindings *
#endif
);
extern int SendMessageCallback(
#ifndef _NO_PROTO
			       struct CallbackInfo *, struct FunctionBindings *
#endif
);
extern int FixNodeCallback(
#ifndef _NO_PROTO
			   struct CallbackInfo *, struct FunctionBindings *
#endif
);
extern int UnfixNodeCallback(
#ifndef _NO_PROTO
			     struct CallbackInfo *, struct FunctionBindings *
#endif
);
extern int FixAllCallback(
#ifndef _NO_PROTO
			  struct CallbackInfo *, struct FunctionBindings *
#endif
);
extern int UnfixAllCallback(
#ifndef _NO_PROTO
			    struct CallbackInfo *, struct FunctionBindings *
#endif
);
extern int ChooseActiveCallback(
#ifndef _NO_PROTO
			    struct CallbackInfo *, struct FunctionBindings *
#endif
);
extern int SelectActiveCallback(
#ifndef _NO_PROTO
			    struct CallbackInfo *, struct FunctionBindings *
#endif
);
extern int UnselectActiveCallback(
#ifndef _NO_PROTO
			    struct CallbackInfo *, struct FunctionBindings *
#endif
);
extern XmString CtoXmString(
#ifndef _NO_PROTO
			    char *
#endif
);
extern void graphDetermine(
#ifndef _NO_PROTO
			   void
#endif
);
extern coord_t SQRT(
#ifndef _NO_PROTO
		    coord_t
#endif
);
extern Vertex *LocateVertex (
#ifndef _NO_PROTO
			     int, int
#endif
);
extern Edge *LocateEdge (
#ifndef _NO_PROTO
			 int, int
#endif
);
extern void draw_node_box(
#ifndef _NO_PROTO
			  Vertex *, GC, XFontStruct *
#endif
);
extern void DrawRubberBandBox(
#ifndef _NO_PROTO
			      GC, int, int, int, int
#endif
);
extern void DrawGraph(
#ifndef _NO_PROTO
		      int, int
#endif
);
extern unsigned long GetColor(
#ifndef _NO_PROTO
			      Widget, char *
#endif
);
extern void FreeGCs(
#ifndef _NO_PROTO
		    Graph *
#endif
);
extern void SetXGraph(
#ifndef _NO_PROTO
		      char *
#endif
);
#ifndef NeXT
extern double drand48(
#ifndef _NO_PROTO
		      void
#endif
);
#endif
extern void DestroyGraph(
#ifndef _NO_PROTO
			 Widget, Graph *, caddr_t
#endif
);
extern struct DisplayTable *FindColor(
#ifndef _NO_PROTO
				      struct DisplayTable *, char *
#endif
);
extern int ParseSuperNode(
#ifndef _NO_PROTO
			  char *, struct mb_object *
#endif
);
extern int ParseNodes(
#ifndef _NO_PROTO
		      struct mb_object *
#endif
);
extern int ParseEdges(
#ifndef _NO_PROTO
		      struct mb_object *
#endif
);
extern void ParseGraph(
#ifndef _NO_PROTO
		       void
#endif
);
extern int ParseDisplayTable(
#ifndef _NO_PROTO
			     struct mb_object *,
			     struct DisplayTable **,
			     struct DisplayTable **,
			     struct DisplayTable **,
			     int,
			     int
#endif
);
extern void ParseCallbacks(
#ifndef _NO_PROTO
			   struct mb_object *,
			   struct KeyBindings **,
			   struct FunctionBindings **,
			   int
#endif
);
extern void ParseElision(
#ifndef _NO_PROTO
			 struct mb_object *,
			 struct mb_object *,
			 struct mb_object *,
			 struct mb_object *,
			 struct mb_object *,
			 struct mb_object *,
			 struct mb_object *
#endif
);
struct FunctionList *FindCallback(
#ifndef _NO_PROTO
				  struct CallbackInfo *
#endif
);

/*
 *  Code here written by Simon Kaplan to kludge the fact that the
 *  NeXT doesn't have srand48 and a drand48 functions.
*/
#ifdef NeXT
#include <math.h>
double bogus;
#define drand48() (modf((double)random()/ldexp(1,32),&bogus))
#define srand48(x) (modf((double)srandom(x)/ldexp(1,32),&bogus))
#endif

#endif _EXTERN_H
