;;; menuBar.el - utilities for creating a motif menu bar with drop menus
;;; B<   Brian Kahn   blk@mitre.org   Fri Jul 10 16:57:45 1992
;;; derived from menus.el by Simon Kaplan


(setq scroll:drop-menus
      '(
	(menu "buffers"
	      (
	       (button "open files"
		       (buffer-menu t))
	       (button "other buffer"
		       (switch-to-buffer (other-buffer)))
	       (button "*scratch* buffer"
		       (switch-to-buffer "*scratch*"))
	       (button "-"
		       nil)
	       (button "kill buffer"
		       (kill-buffer (current-buffer)))
	       ))
	
	(menu "windows"
	      (
	       (button "one window"
		       (delete-other-windows))
	       (button "split screen"
		       (split-window-vertically))
	       ))
	
	(menu "screens"
	      (
	       (button "new screen"
		       (create-screen))
	       (button "delete screen"
		       (delete-screen))
	       ))
	
	(menu "fonts"
	      (
	       (button "screen-14"
		       (progn (font "screen.r.14") 
			      (redraw-display)))
	       (button "screen-11"
		       (progn (font "screen.r.11") 
			      (redraw-display)))
	       (button "screen-7"
		       (progn (font "screen.r.7") 
			      (redraw-display)))
	       (button "serif-16"
		       (progn (font "serif.r.16") 
			      (redraw-display)))
	       (button "misc-15"
		       (progn (font "-misc*medium*-15-*") 
			      (redraw-display)))
	       (button "misc-15-bold"
		       (progn (font "-misc*bold*-15-*") 
			      (redraw-display)))
	       (button "misc-20-bold"
		       (progn (font "-misc*bold*-20-*") 
			      (redraw-display)))
	       (button "courier-20"
		       (progn (font "-*-courier-medium-r-*-20-*") 
			      (redraw-display)))
	       ))
	
	(menu "mail"
	      (
	       (button "read mail"
		       (mh-rmail))
	       (button "send mail"
		       (mh-smail))
	       ))
	
	(menu "info" 
	      (
	       (button "info & help"
		       (info))
	       ))
	
	(menu "news" 
	      (
	       (button "usenet news"
		       (gnus))
	       ))
	
	(menu "shell" 
	      (
	       (button "csh"
		       (progn (csh) (end-of-buffer)))
	       ))
	
	(menu "db" 
	      (
	       (button "toggle debug"
		       (message "debug-on-error -> %s"
				(setq debug-on-error 
				      (not debug-on-error))))
	       (button "debug on"
		       (message "debug-on-error -> %s"
				(setq debug-on-error t)))
	       (button "debug off"
		       (message "debug-on-error -> %s"
				(setq debug-on-error nil)))
	       (button "debug func"
		       (call-interactively 'debug-on-entry))
	       (button "cancel debug func"
		       (call-interactively 'cancel-debug-on-entry))
	       ))
	
	))





(mbus-set-dispatch 's-exp 'scroll:eval *mbus-dispatch-dispatch*)


;; use this for debugging...
(defun scroll:eval (&optional data)
  (message "%s" data))

(defun scroll:eval (&optional data)
  (eval data))



(defun scroll:file-box ()
  "Returns string for a button that opens a file box from SCR."
  (format 
   "
   (button open-file-prompt \"Open File\" 
    :action 
    (shell id  
     (array id 
      ((file id 
	:the-file 
	:title \"Open File\" 
	:type 
	:any
	)
       (prompt prompt 
	((do \"Do\" 
	  :action 
	  (:transmit 
	   :delete-top
	   )
	  )
	 (dont-do \"Cancel\" 
	  :action :delete-top
	  )
	))
      ))
     :tag open-file-prompt
     :header \"\\\"text\\\" \\\"%s\\\"\"
     ))\n"
   scroll:*text-address*)
  )




(defun scroll:quit-box ()
  "Returns string for a button that opens a file box from SCR."
  (format 
   "
   (button quit \"Quit\" 
    :action 
    (shell id  
     (array id 
      ((label id \"Are you sure you want to quit Epoch?\"
	)
       (prompt prompt 
	((do \"Yes\" 
	  :action (:transmit :delete-top)
	  )
	 (dont-do \"No\" 
	  :action :delete-top
	  )
      ))))
     :tag quit-epoch
     :header \"\\\"text\\\" \\\"%s\\\"\"
    ))\n"
   scroll:*text-address*)
  )



(setq scroll:file-menu
      (list 
       (list 'menu "File"
	     (list (scroll:file-box) (scroll:quit-box))
	      )))




;; (button test "test" 
;;  :action :reply :tag s-exp
;;  :values (message 2 3)
;;  :header "\"text\" \"text.blk.ui.cb\""
;;  )


(setq sym:quote  "\"")
(setq sym:slash  "\\")
(setq sym:line   "\n")



(defun scroll:button (title action &optional key)
  "Makes button with TITLE, executes ACTION, optional KEY."
  (concat
   (format "(button %s \"%s\"\n" (or key "button") title)
   " :action :reply :tag s-exp\n"
   (format " :values %s\n" action)
   (format " :header \"\\\"text\\\" \\\"%s\\\"\"\n" scroll:*text-address*)
   " )\n"
   ))



(defun scroll:item-list (buttons-and-menus)
  "Makes string of items from a list of BUTTONS-AND-MENUS for any screen.
 ( (menu \"name\" ((button \"name\" (action)))) (button \"name\" action) )
 Strings are passed through unchanged, so other widgets can be included."
  (mapconcat
    (function (lambda 
     (item)
     (cond 
      ((stringp item)
       ;; preformatted, poke it in
       item)
      ((eq 'menu (car item))
       ;; sub-menu
       (concat
	(format "(menu \"screen.%s\"\n(" 
		(nth 1 item))
	(scroll:item-list (nth 2 item))
	(format ")\n :label \"%s\"\n" (nth 1 item))
	")\n"
	)
       )
      ((eq 'button (car item))
       ;; regular button
       (scroll:button (nth 1 item) (nth 2 item) (nth 3 item))
       )
      (t ;; uhoh
       (error "scroll:item-list - unknown item type %s" (car item))
       )
      )))
    buttons-and-menus
    ""
    )
   )




(defun scroll:screen-spec  (scr &optional menu-item-string)
  "Makes string for creating screen SCR using MENU-ITEM-STRING."
  ;; string created with scroll:item-list, or other...
  (let ((xid (string-xid-of-screen scr)))
    (format
     "
     (\"display\" \"%s\"
      (shell \"screen-%s\"
       (box \"screen-%s.box\"
        ((menu-bar \"screen-%s.menu-bar\"
          (%s
          ))
         (area \"screen-%s.text\" 
          :message \"\\\"tag\\\" \\\"%s\\\"\"
          :scrollbars t
          )
         )
        )
       :editable t
      ))\n"
     scroll:*ws-address*
     xid xid xid
     menu-item-string
     xid
     scroll:*text-address*
     )
    ))




(setq scroll:decorations
      (concat
       (scroll:item-list scroll:file-menu)
       (scroll:item-list scroll:drop-menus)
       ))




(defun scroll:screen-def (&optional scr)
  "Define current-screen or SCR using scroll:decorations."
  (or scr (setq scr (current-screen)))
  (scroll:screen-spec scr scroll:decorations))


