/*
 This file is part of TALER
 (C) 2019 GNUnet e.V.

 TALER is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 TALER is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */

/**
 * Module entry point for the wallet when used as a node module.
 */

export * from "./crypto/cryptoImplementation.js";
export * from "./crypto/cryptoTypes.js";
export * from "./crypto/index.js";
export {
  CryptoDispatcher,
  CryptoWorkerFactory,
} from "./crypto/workers/crypto-dispatcher.js";
export type { CryptoWorker } from "./crypto/workers/cryptoWorkerInterface.js";
export { SynchronousCryptoWorkerFactoryPlain } from "./crypto/workers/synchronousWorkerFactoryPlain.js";
export * from "./host-common.js";
export * from "./host.js";
export * from "./versions.js";
export * from "./wallet-api-types.js";
export * from "./wallet.js";

export { parseTransactionIdentifier } from "./transactions.js";

export { createPairTimeline } from "./denominations.js";

// FIXME: Should these really be exported?!
export {
  WalletStoresV1,
  deleteTalerDatabase,
  exportDb,
  importDb,
} from "./db.js";
export { DbAccess } from "./query.js";
