/*
 This file is part of GNU Taler
 (C) 2025 Taler Systems S.A.

 GNU Taler is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 GNU Taler is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 GNU Taler; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */

/**
 * Imports.
 */
import { WalletApiOperation } from "@gnu-taler/taler-wallet-core";
import { GlobalTestState } from "../harness/harness.js";
import {
  createSimpleTestkudosEnvironmentV3,
} from "../harness/environments.js";
import { MailboxMessageRecord, TalerPreciseTimestamp, TalerProtocolTimestamp } from "@gnu-taler/taler-util";

/**
 * Run test for basic mailbox operations.
 */
export async function runWalletMailboxBasicTest(t: GlobalTestState) {
  // Set up test environment

  const { commonDb, merchant, walletClient, bankClient, exchange } =
    await createSimpleTestkudosEnvironmentV3(t);
  const mailboxBaseUrl = "https://example.com";
  const mbConf = await walletClient.call(WalletApiOperation.GetMailbox, mailboxBaseUrl);

  const mbConfAgain = await walletClient.call(WalletApiOperation.GetMailbox, mailboxBaseUrl);
  t.assertDeepEqual(mbConf, mbConfAgain);
  const messageBob: MailboxMessageRecord = {
    originMailboxBaseUrl: mailboxBaseUrl,
    talerUri: "taler://pay-push/XQXB",
    downloadedAt: TalerProtocolTimestamp.now(),
  };
  const messageAlice: MailboxMessageRecord = {
    originMailboxBaseUrl: mailboxBaseUrl,
    talerUri: "taler://pay-pull/XQXA",
    downloadedAt: TalerProtocolTimestamp.now(),
  };
  await walletClient.call(WalletApiOperation.AddMailboxMessage, {
    message: messageBob,
  });
  await walletClient.call(WalletApiOperation.AddMailboxMessage, {
    message: messageAlice,
  });


  {
    const bi = await walletClient.call(WalletApiOperation.GetMailboxMessages, {});
    t.assertDeepEqual(bi.messages.length, 2);
  }

  await walletClient.call(WalletApiOperation.DeleteMailboxMessage, {
    message: messageBob,
  });

  {
    const bi = await walletClient.call(WalletApiOperation.GetMailboxMessages, {});
    t.assertDeepEqual(bi.messages.length, 1);
    t.assertDeepEqual(bi.messages[0], messageAlice);
  }

}

runWalletMailboxBasicTest.suites = ["wallet", "wallet-mailbox"];
runWalletMailboxBasicTest.experimental = true;
