.\" -*- nroff -*-
.ie t .ds tx T\h'-.1667m'\v'.224m'E\v'-.224m'\h'-.125m'X
.el .ds tx TeX
.ie \n(.g .ds ic \/
.el .ds ic \^
.TH GPIC @MAN1EXT@ "@MDATE@" "Groff Version @VERSION@"
.SH NAME
gpic \- compile pictures for troff or TeX
.SH SYNOPSIS
.B gpic
[
.B \-pvxzC
]
[
.I filename
\&.\|.\|.
]
.br
.B gpic
.B \-t
[
.B \-cvzC
]
[
.I filename
\&.\|.\|.
]
.SH DESCRIPTION
.LP
.B gpic
compiles descriptions of pictures embedded within
.B troff
or \*(tx input files into commands that are understood by \*(tx
or
.BR troff .
Each picture starts with a line beginning with
.B .PS
and ends with a line beginning with
.BR .PE .
Anything outside of
.B .PS
and
.B .PE
is passed through without change.
.LP
It is the user's responsibility to provide appropriate definitions of the
.B PS
and
.B PE
macros.
When the macro package being used does not supply such definitions
(for example, old versions of \-ms),
appropriate definitions can be obtained with
.BR \-mpic :
these will center each picture.
.SH OPTIONS
.LP
Options that do not take arguments may be grouped behind a single
.BR \- .
The special option
.B \-\^\-
can be used to mark the end of the options.
A filename of
.B \-
refers to the standard input.
.TP
.B \-C
Recognize
.B .PS
and
.B .PE
even when followed by a character other than space or newline.
.TP
.B \-p
Grops mode.
Use this if the output of gpic will be processed by
.B gtroff
and
.BR grops .
In this mode gpic can make use the
.BI \eX'ps:\  anything '
command.
Currently it does this only for the
.B aligned
attribute.
.TP
.B \-t
\*(tx mode.
.TP
.B \-c
Be more compatible with
.BR tpic .
Implies
.BR \-t .
Lines beginning with
.B \e
are not passed through transparently.
Lines beginning with
.B .
are passed through with the initial
.B .
changed to
.BR \e .
A line beginning with
.B .ps
is given special treatment:
it takes an optional integer argument specifying
the line thickness (pen size) in milliinches;
a missing argument restores the previous line thickness;
the default line thickness is 8 milliinches.
The line thickness thus specified takes effect only
when a non-negative line thickness has not been
specified by use of the
.B thickness
attribute or by setting the
.B linethick
variable.
.TP
.B \-v
Print the version number.
.TP
.B \-x
Assume a troff driver that supports the gpic extensions
to the standard troff drawing commands.
These are described in
.BR groff_out (@MAN5EXT@).
These extensions can be used with device-independent troff,
provided that the version being used passes through unrecognised
drawing commands in the standard way.
This implies
.BR \-z .
.TP
.B \-z
Draw dots using zero-length lines. This applies to both \*(tx mode and
.B troff
mode.
.LP
The following options supported by other versions of
.B pic
are ignored:
.TP
.B \-D
Draw all lines using the \eD escape sequence.
.B pic
always does this.
.TP
.BI \-T \ dev
Generate output for the
.B troff
device
.IR dev .
This is unnecessary because the
.B troff
output generated by
.B pic
is device-independent.
.SH USAGE
This section describes only the differences between gpic and the original pic.
Many of these differences also apply to newer versions of pic.
.SS \*(tx mode
.LP
\*(tx mode is enabled by the
.B \-t
option.
In \*(tx mode, gpic will define a vbox called
.B \egraph
for each picture.
You must yourself print that vbox using, for example, the command
.RS
.LP
.B
\ecenterline{\ebox\egraph}
.RE
.LP
Actually, since the vbox has a height of zero this will produce
slightly more vertical space above the picture than below it;
.RS
.LP
.B
\ecenterline{\eraise 1em\ebox\egraph}
.RE
.LP
would avoid this.
.LP
You must use a \*(tx driver that supports the
.B tpic
specials, version 2.
.LP
Lines beginning with
.B \e
are passed through transparently; a
.B %
is added to the end of the line to avoid unwanted spaces.
You can safely use this feature to change fonts or to
change the value of
.BR \ebaselineskip .
Anything else may well produce undesirable results; use at your own risk.
Lines beginning with a period are not given any special treatment.
.SS Commands
.TP
\fBfor\fR \fIvariable\fR \fB=\fR \fIexpr1\fR \fBto\fR \fIexpr2\fR \
[\fBby\fR [\fB*\fR]\fIexpr3\fR] \fBdo\fR \fIX\fR \fIbody\fR \fIX\fR
Set
.I variable
to
.IR expr1 .
While the value of
.I variable
is less than or equal to
.IR expr2 ,
do
.I body
and increment
.I variable
by
.IR expr3 ;
if
.B by
is not given, increment
.I variable
by 1.
If
.I expr3
is prefixed by
.B *
then
.I variable
will instead be multiplied by
.IR expr3 .
.I X
can be any character not occurring in
.IR body .
.TP
\fBif\fR \fIexpr\fR \fBthen\fR \fIX\fR \fIif-true\fR \fIX\fR \
[\fBelse\fR \fIY\fR \fIif-false\fR \fIY\fR]
Evaluate
.IR expr ;
if it is non-zero then do
.IR if-true ,
otherwise do
.IR if-false .
.I X
can be any character not occurring in
.IR if-true .
.I Y
can be any character not occurring in
.IR if-false .
.TP
\fBprint\fR \fIexpr\fR
.ns
.TP
\fBprint\fR \fIposition\fR
.ns
.TP
\fBprint\fR \fB"\fItext\*(ic\fB"\fR
Print the value of
.IR expr ,
.I position
or
.I text
on stderr.
.TP
\fBsh\fR \fIX\fR \fIcommand\fR \fIX\fR
Pass
.I command
to a shell.
.I X
can be any character not occurring in
.IR command .
.TP
\fBcopy\fR \fB"\fIfilename\fB"\fR
Include
.I filename
at this point in the file.
.TP
\fBcopy\fR [\fB"\fIfilename\fB"\fR] \fBthru\fR \fIX\fR \fIbody\fR \fIX\fR \
[\fBuntil\fR \fB"\fIword\*(ic\fB"\fR]
.ns
.TP
\fBcopy\fR [\fB"\fIfilename\fB"\fR] \fBthru\fR \fImacro\fR \
[\fBuntil\fR \fB"\fIword\*(ic\fB"\fR]
This construct does
.I body
once for each line of
.IR filename ;
the line is split into blank-delimited words,
and occurrences of
.BI $ i
in
.IR body ,
for
.I i
between 1 and 9,
are replaced by the
.IR i -th
word of the line.
If
.I filename
is not given, lines are taken from the current input up to
.BR .PE .
If an
.B until
clause is specified,
lines will be read only until a line the first word of which is
.IR word ;
that line will then be discarded.
.I X
can be any character not occurring in
.IR body .
For example,
.RS
.IP
.ft B
.nf
\&.PS
copy thru % circle at ($1,$2) % until "END"
1 2
3 4
5 6
END
box
\&.PE
.ft
.fi
.RE
.IP
is equivalent to
.RS
.IP
.ft B
.nf
\&.PS
circle at (1,2)
circle at (3,4)
circle at (5,6)
box
\&.PE
.ft
.fi
.RE
.IP
The commands to be performed for each line can also be taken
from a macro defined earlier by giving the name of the macro
as the argument to
.BR thru .
.LP
.B reset
.br
.ns
.TP
\fBreset\fI variable1\fB,\fI variable2 .\^.\^.
Reset pre-defined variables
.IR variable1 ,
.I variable2
\&.\^.\^. to their default values.
If no arguments are given, reset all pre-defined variables
to their default values.
Note that assigning a value to
.B scale
also causes all pre-defined variables that control dimensions
to be reset to their default values times the new value of scale.
.TP
\fBplot\fR \fIexpr\fR [\fB"\fItext\*(ic\fB"\fR]
This is a text object which is constructed by using
.I text
as a format string for sprintf
with an argument of
.IR expr .
If
.I text
is omitted a format string of
.B """%g"""
is used.
Attributes can be specified in the same way as for a normal text
object.
Be very careful that you specify an appropriate format string;
gpic does only very limited checking of the string.
This is deprecated in favour of
.BR sprintf .
.LP
Arguments of the form
.IP
.IR X\  anything\  X
.LP
are also allowed to be of the form
.IP
.BI {\  anything\  }
.LP
In this case
.I anything
can contain balanced occurrences of
.B {
and
.BR } .
Strings may contain
.I X
or imbalanced occurrences of
.B {
and
.BR } .
.SS Expressions
The syntax for expressions has been significantly extended:
.LP
.IB  x\  ^\  y
(exponentiation)
.br
.BI sin( x )
.br
.BI cos( x )
.br
.BI atan2( y , \ x )
.br
.BI log( x )
(base 10)
.br
.BI exp( x )
(base 10, ie 10\v'-.4m'\fIx\*(ic\fR\v'.4m')
.br
.BI sqrt( x )
.br
.BI int( x )
.br
.B rand()
(return a random number between 0 and 1)
.br
.BI rand( x )
(return a random number between 1 and
.IR x ;
deprecated)
.br
.BI max( e1 , \ e2 )
.br
.BI min( e1 , \ e2 )
.br
.BI ! e
.br
\fIe1\fB && \fIe2\fR
.br
\fIe1\fB || \fIe2\fR
.br
\fIe1\fB == \fIe2\fR
.br
\fIe1\fB != \fIe2\fR
.br
\fIe1\fB >= \fIe2\fR
.br
\fIe1\fB > \fIe2\fR
.br
\fIe1\fB <= \fIe2\fR
.br
\fIe1\fB < \fIe2\fR
.br
.SS Other Changes
.LP
A bare expression,
.IR expr ,
is acceptable as an attribute;
it is equivalent to
.IR dir\ expr ,
where
.I dir
is the current direction.
For example
.IP
.B line 2i
.LP
means draw a line 2 inches long in the current direction.
.LP
The maximum width and height of the picture are taken from the variables
.B maxpswid
and
.BR maxpsht .
Initially these have values 8.5 and 11.
.LP
Scientific notation is allowed for numbers.
For example
.RS
.B
x = 5e\-2
.RE
.LP
Text attributes can be compounded.
For example,
.RS
.B
"foo" above ljust
.RE
is legal.
.LP
There is no limit to the depth to which blocks can be examined.
For example,
.RS
.B
[A: [B: [C: box ]]] with .A.B.C.sw at 1,2
.br
.B
circle at last [\^].A.B.C
.RE
is acceptable.
.LP
Arcs now have compass points
determined by the circle of which the arc is a part.
.LP
Circles and arcs can be dotted or dashed.
In \*(tx mode splines can be dotted or dashed.
.LP
Boxes can have rounded corners.
The
.B rad
attribute specifies the radius of the quarter-circles at each corner.
If no
.B rad
or
.B diam
attribute is given, a radius of
.B boxrad
is used.
Initially,
.B boxrad
has a value of 0.
A box with rounded corners can be dotted or dashed.
.LP
The
.B .PS
line can have a second argument specifying a maximum height for
the picture.
If the width of zero is specified the width will be ignored in computing
the scaling factor for the picture.
Note that gpic will always scale a picture by the same amount
vertically as horizontally.
This is different from the
.SM DWB
2.0 pic which may scale a picture by a
different amount vertically than horizontally if a height is
specified.
.LP
Each text object has an invisible box associated with it.
The compass points of a text object are determined by this box.
The implicit motion associated with the object is also determined
by this box.
The dimensions of this box are taken from the width and height attributes;
if the width attribute is not supplied then the width will be taken to be
.BR textwid ;
if the height attribute is not supplied then the height will be taken to be
the number of text strings associated with the object
times
.BR textht .
Initially
.B textwid
and
.B textht
have a value of 0.
.LP
In places where a quoted text string can be used,
an expression of the form
.IP
.BI sprintf(" format ""","\  arg , .\|.\|. )
.LP
can also be used;
this will produce the arguments formatted according to
.IR format ,
which should be a string as described in
.BR printf (3)
appropriate for the number of arguments supplied,
using only the
.BR e ,
.BR f ,
.B g
or
.B %
format characters.
.LP
The thickness of the lines used to draw objects is controlled by the
.B linethick
variable.
This gives the thickness of lines in points.
A negative value means use the default thickness:
in \*(tx output mode, this means use a thickness of 8 milliinches;
in \*(tx output mode with the
.B -c
option, this means use the line thickness specified by
.B .ps
lines;
in troff output mode, this means use a thickness proportional
to the pointsize.
A zero value means draw the thinnest possible line supported by
the output device.
Initially it has a value of -1.
There is also a
.BR thick [ ness ]
attribute.
For example,
.RS
.LP
.B circle thickness 1.5
.RE
.LP
would draw a circle using a line with a thickness of 1.5 points.
The thickness of lines is not affected by the
value of the
.B scale
variable, nor by the width or height given in the
.B .PS
line.
.LP
Boxes (including boxes with rounded corners),
circles and ellipses can be filled by giving then an attribute of
.BR fill [ ed ].
This takes an optional argument of an expression with a value between
0 and 1; 0 will fill it with white, 1 with black, values in between
with a proportionally gray shade.
A value greater than 1 can also be used:
this means fill with the
shade of gray that is currently being used for text and lines.
Normally this will be black, but output devices may provide
a mechanism for changing this.
Without an argument, then the value of the variable
.B fillval
will be used.
Initially this has a value of 0.5.
The invisible attribute does not affect the filling of objects.
Any text associated with a filled object will be added after the
object has been filled, so that the text will not be obscured
by the filling.
.LP
Arrow heads will be drawn as solid triangles if the variable
.B arrowhead
is non-zero and either \*(tx mode is enabled or
the
.B \-x
option has been given.
Initially
.B arrowhead
has a value of 1.
.LP
The troff output of gpic is device-independent.
The
.B \-T
option is therefore redundant.
All numbers are taken to be in inches; numbers are never interpreted
to be in troff machine units.
.LP
Objects can have an
.B aligned
attribute.
This is only available with the
.B \-p
option.
Any text associated with an object having the
.B aligned
attribute will be rotated about the center of the object
so that it is aligned in the direction from the start point
to the end point of the object.
Note that this attribute will have no effect for objects whose start and
end points are coincident.
.SH FILES
.TP \w'\fB@MACRODIR@/tmac.pic'u+3n
.B
@MACRODIR@/tmac.pic
Example definitions of the
.B PS
and
.B PE
macros.
.SH "SEE ALSO"
.BR gtroff (@MAN1EXT@),
.BR groff_out (@MAN5EXT@),
.BR tex (1)
.br
Tpic: Pic for \*(tx
.br
AT&T Bell Laboratories, Computing Science Technical Report No.\ 116,
PIC \(em A Graphics Language for Typesetting.
(This can be obtained by sending a mail message to netlib@research.att.com
with a body of `send\ 116\ from\ research/cstr'.)
.SH BUGS
.LP
Input characters that are illegal for
.B groff
(ie those with
.SM ASCII
code 0 or between 013 and 037 octal or between 0200 and 0237 octal)
are rejected even in \*(tx mode.
.LP
The interpretation of
.B fillval
is incompatible with the pic in 10th edition Unix,
which interprets 0 as black and 1 as white.
