/* 
 *    Programmed By: Mohammed Isam Mohammed [mohammed_isam1984@yahoo.com]
 *    Copyright 2018, 2024 (c)
 * 
 *    file: module_html.c
 *    This file is part of mino.
 *
 *    mino is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    mino is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with mino.  If not, see <http://www.gnu.org/licenses/>.
 */    
#include "modules.h"

char *ext_html[] = { "html", "htm", "HTML", "HTM" };
wchar_t *keyword_html[] = {
      //HTML language keywords
      L"!--",
      L"--",
      L"!doctype",
      L"abbr",
      L"acronym",
      L"address",
      L"applet",
      L"area",
      L"article",
      L"aside",
      L"audio",
      L"a",
      L"basefont",
      L"base",
      L"bdi",
      L"bdo",
      L"big",
      L"blockquote",
      L"body",
      L"br",
      L"button",
      L"b",
      L"canvas",
      L"caption",
      L"center",
      L"cite",
      L"code",
      L"colgroup",
      L"col",
      L"datalist",
      L"dd",
      L"del",
      L"details",
      L"dfn",
      L"dialog",
      L"dir",
      L"div",
      L"di",
      L"dt",
      L"embed",
      L"em",
      L"fieldset",
      L"figcaption",
      L"figure",
      L"font",
      L"footer",
      L"form",
      L"frameset",
      L"frame",
      L"h1",
      L"h2",
      L"h3",
      L"h4",
      L"h5",
      L"h6",
      L"header",
      L"head",
      L"hr",
      L"html",
      L"iframe",
      L"img",
      L"input",
      L"ins",
      L"i",
      L"kbd",
      L"keygen",
      L"label",
      L"legend",
      L"link",
      L"li",
      L"main",
      L"map",
      L"mark",
      L"menuitem",
      L"menu",
      L"meta",
      L"meter",
      L"nav",
      L"noframes",
      L"noscript",
      L"object",
      L"ol",
      L"optgroup",
      L"option",
      L"output",
      L"param",
      L"pre",
      L"progress",
      L"p",
      L"q",
      L"rp",
      L"rt",
      L"ruby",
      L"samp",
      L"script",
      L"section",
      L"select",
      L"small",
      L"source",
      L"span",
      L"strike",
      L"strong",
      L"style",
      L"sub",
      L"summary",
      L"sup",
      L"s",
      L"table",
      L"tbody",
      L"td",
      L"textarea",
      L"tfoot",
      L"thead",
      L"th",
      L"time",
      L"title",
      L"track",
      L"tr",
      L"tt",
      L"ul",
      L"u",
      L"var",
      L"video",
      L"wbr",
};

struct modulestruct module_html =
{
    .extsCount      = 4,
    .exts           = ext_html,
    .keywordCount   = 124,
    .keywords       = keyword_html,
    .mlCommentStart = L"<!--",
    .mlCommentEnd   = L"-->",
    .slCommentStart = NULL,
    .caseSensitive  = 0,
};

