/***********************license start***********************************
* Copyright (c) 2003-2017  Cavium Inc. (support@cavium.com). All rights
* reserved.
*
*
* Redistribution and use in source and binary forms, with or without
* modification, are permitted provided that the following conditions are
* met:
*
*   * Redistributions of source code must retain the above copyright
*     notice, this list of conditions and the following disclaimer.
*
*   * Redistributions in binary form must reproduce the above
*     copyright notice, this list of conditions and the following
*     disclaimer in the documentation and/or other materials provided
*     with the distribution.
*
*   * Neither the name of Cavium Inc. nor the names of
*     its contributors may be used to endorse or promote products
*     derived from this software without specific prior written
*     permission.
*
* This Software, including technical data, may be subject to U.S. export
* control laws, including the U.S. Export Administration Act and its
* associated regulations, and may be subject to export or import
* regulations in other countries.
*
* TO THE MAXIMUM EXTENT PERMITTED BY LAW, THE SOFTWARE IS PROVIDED "AS IS"
* AND WITH ALL FAULTS AND CAVIUM INC. MAKES NO PROMISES, REPRESENTATIONS OR
* WARRANTIES, EITHER EXPRESS, IMPLIED, STATUTORY, OR OTHERWISE, WITH RESPECT
* TO THE SOFTWARE, INCLUDING ITS CONDITION, ITS CONFORMITY TO ANY
* REPRESENTATION OR DESCRIPTION, OR THE EXISTENCE OF ANY LATENT OR PATENT
* DEFECTS, AND CAVIUM SPECIFICALLY DISCLAIMS ALL IMPLIED (IF ANY) WARRANTIES
* OF TITLE, MERCHANTABILITY, NONINFRINGEMENT, FITNESS FOR A PARTICULAR
* PURPOSE, LACK OF VIRUSES, ACCURACY OR COMPLETENESS, QUIET ENJOYMENT,
* QUIET POSSESSION OR CORRESPONDENCE TO DESCRIPTION. THE ENTIRE  RISK
* ARISING OUT OF USE OR PERFORMANCE OF THE SOFTWARE LIES WITH YOU.
***********************license end**************************************/

/**
 * Small utility functions for use by libdram internally. These
 * are not meant for users's of the libdram API.
 */

#if 0
/* FIXME(dhendrix): min/max are defined in stdlib.h */
/**
 * Standard min(a,b) macro
 */
#define min(X, Y)				\
	({ typeof (X) __x = (X);		\
		typeof (Y) __y = (Y);		\
		(__x < __y) ? __x : __y; })

/**
 * Standard max(a,b) macro
 */
#define max(X, Y)				\
	({ typeof (X) __x = (X); typeof(Y) __y = (Y);	\
		(__x > __y) ? __x : __y; })
#endif

/**
 * Absolute value of an integer
 *
 * @param v
 *
 * @return
 */
static inline int64_t _abs(int64_t v)
{
    return (v < 0) ? -v : v;
}

/**
 * Sign of an integer
 *
 * @param v
 *
 * @return
 */
static inline int64_t _sign(int64_t v)
{
    return v < 0;
}

/**
 * Divide and round results up to the next higher integer.
 *
 * @param dividend
 * @param divisor
 *
 * @return
 */
static inline uint64_t divide_roundup(uint64_t dividend, uint64_t divisor)
{
    return (dividend + divisor - 1) / divisor;
}

