/*
 * File automatically generated by
 * gengen 0.6 by Lorenzo Bettini 
 * http://www.lorenzobettini.it/software/gengen
 */

#include "c_source.h"

void
c_source_gen_class::generate_c_source(ostream &stream, unsigned int indent)
{
  string indent_str (indent, ' ');
  indent = 0;

  stream << "/*";
  stream << "\n";
  stream << indent_str;
  stream << "  File autogenerated by gengetopt ";
  generate_string (generator_version, stream, indent + indent_str.length ());
  stream << "\n";
  stream << indent_str;
  stream << "  generated with the following command:";
  stream << "\n";
  stream << indent_str;
  indent = 2;
  stream << "  ";
  generate_string (command_line, stream, indent + indent_str.length ());
  indent = 0;
  stream << "\n";
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  stream << "  The developers of gengetopt consider the fixed text that goes in all";
  stream << "\n";
  stream << indent_str;
  stream << "  gengetopt output files to be in the public domain:";
  stream << "\n";
  stream << indent_str;
  stream << "  we make no copyright claims on it.";
  stream << "\n";
  stream << indent_str;
  stream << "*/";
  stream << "\n";
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  stream << "/* If we use autoconf.  */";
  stream << "\n";
  stream << indent_str;
  stream << "#ifdef HAVE_CONFIG_H";
  stream << "\n";
  stream << indent_str;
  stream << "#include \"config.h\"";
  stream << "\n";
  stream << indent_str;
  stream << "#endif";
  stream << "\n";
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  stream << "#include <stdio.h>";
  stream << "\n";
  stream << indent_str;
  stream << "#include <stdlib.h>";
  stream << "\n";
  stream << indent_str;
  stream << "#include <string.h>";
  stream << "\n";
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  stream << "#include \"getopt.h\"";
  stream << "\n";
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  stream << "#include \"";
  generate_string (source_name, stream, indent + indent_str.length ());
  stream << ".h\"";
  stream << "\n";
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  stream << "static";
  stream << "\n";
  stream << indent_str;
  stream << "void clear_given (struct ";
  generate_string (args_info, stream, indent + indent_str.length ());
  stream << " *args_info);";
  stream << "\n";
  stream << indent_str;
  stream << "static";
  stream << "\n";
  stream << indent_str;
  stream << "void clear_args (struct ";
  generate_string (args_info, stream, indent + indent_str.length ());
  stream << " *args_info);";
  stream << "\n";
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  stream << "static int";
  stream << "\n";
  stream << indent_str;
  generate_string (parser_name, stream, indent + indent_str.length ());
  stream << "_internal (int argc, char * const *argv, struct ";
  generate_string (args_info, stream, indent + indent_str.length ());
  stream << " *args_info, int override, int initialize, int check_required, const char *additional_error);";
  stream << "\n";
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  if (check_required_options)
    {
      stream << "static int";
      stream << "\n";
      stream << indent_str;
      generate_string (parser_name, stream, indent + indent_str.length ());
      stream << "_required2 (struct ";
      generate_string (args_info, stream, indent + indent_str.length ());
      stream << " *args_info, const char *prog_name, const char *additional_error);";
      stream << "\n";
      stream << indent_str;
    }
  if (conf_parser)
    {
      stream << "struct line_list";
      stream << "\n";
      stream << indent_str;
      stream << "{";
      stream << "\n";
      stream << indent_str;
      stream << "  char * string_arg;";
      stream << "\n";
      stream << indent_str;
      stream << "  struct line_list * next;";
      stream << "\n";
      stream << indent_str;
      stream << "};";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
      stream << "static struct line_list *cmd_line_list = 0;";
      stream << "\n";
      stream << indent_str;
      stream << "static struct line_list *cmd_line_list_tmp = 0;";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
    }
  stream << "\n";
  stream << indent_str;
  if (struct_def.size () > 0)
    generate_string (struct_def, stream, indent + indent_str.length ());
  else
    generate_struct_def (stream, indent + indent_str.length ());
  stream << indent_str;
  if (option_values.size () > 0)
    generate_string (option_values, stream, indent + indent_str.length ());
  else
    generate_option_values (stream, indent + indent_str.length ());
  stream << indent_str;
  if (do_generate_strdup)
    {
      stream << "static char *";
      stream << "\n";
      stream << indent_str;
      stream << "gengetopt_strdup (const char *s);";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
    }
  stream << "static";
  stream << "\n";
  stream << indent_str;
  stream << "void clear_given (struct ";
  generate_string (args_info, stream, indent + indent_str.length ());
  stream << " *args_info)";
  stream << "\n";
  stream << indent_str;
  stream << "{";
  stream << "\n";
  stream << indent_str;
  indent = 2;
  if (given_init.size () > 0)
    generate_string (given_init, stream, indent + indent_str.length ());
  else
    generate_given_init (stream, indent + indent_str.length ());
  indent = 0;
  stream << indent_str;
  stream << "}";
  stream << "\n";
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  stream << "static";
  stream << "\n";
  stream << indent_str;
  stream << "void clear_args (struct ";
  generate_string (args_info, stream, indent + indent_str.length ());
  stream << " *args_info)";
  stream << "\n";
  stream << indent_str;
  stream << "{";
  stream << "\n";
  stream << indent_str;
  indent = 2;
  stream << "  ";
  if (clear_arg.size () > 0)
    generate_string (clear_arg, stream, indent + indent_str.length ());
  else
    generate_clear_arg (stream, indent + indent_str.length ());
  indent = 0;
  stream << "\n";
  stream << indent_str;
  stream << "}";
  stream << "\n";
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  stream << "void";
  stream << "\n";
  stream << indent_str;
  generate_string (parser_name, stream, indent + indent_str.length ());
  stream << "_print_version (void)";
  stream << "\n";
  stream << indent_str;
  stream << "{";
  stream << "\n";
  stream << indent_str;
  stream << "  printf (\"%s %s\\n\", ";
  generate_string (package_var_name, stream, indent + indent_str.length ());
  stream << ", ";
  generate_string (version_var_name, stream, indent + indent_str.length ());
  stream << ");";
  stream << "\n";
  stream << indent_str;
  stream << "}";
  stream << "\n";
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  stream << "void";
  stream << "\n";
  stream << indent_str;
  generate_string (parser_name, stream, indent + indent_str.length ());
  stream << "_print_help (void)";
  stream << "\n";
  stream << indent_str;
  stream << "{";
  stream << "\n";
  stream << indent_str;
  indent = 2;
  stream << "  ";
  generate_string (parser_name, stream, indent + indent_str.length ());
  stream << "_print_version ();";
  indent = 0;
  stream << "\n";
  stream << indent_str;
  if (has_purpose)
    {
      stream << "  printf(\"\\n%s\\n\", \"";
      generate_string (purpose, stream, indent + indent_str.length ());
      stream << "\");";
      stream << "\n";
      stream << indent_str;
    }
  stream << "  printf(\"\\n";
  generate_string (usage_string, stream, indent + indent_str.length ());
  stream << "\\n\"";
  if (no_package)
    {
      stream << ", ";
      generate_string (package_var_name, stream, indent + indent_str.length ());
    }
  stream << ");";
  stream << "\n";
  stream << indent_str;
  indent = 2;
  stream << "  ";
  if (help_option_print.size () > 0)
    generate_string (help_option_print, stream, indent + indent_str.length ());
  else
    generate_help_option_print (stream, indent + indent_str.length ());
  indent = 0;
  stream << "\n";
  stream << indent_str;
  stream << "}";
  stream << "\n";
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  if (has_hidden)
    {
      stream << "void";
      stream << "\n";
      stream << indent_str;
      generate_string (parser_name, stream, indent + indent_str.length ());
      stream << "_print_full_help (void)";
      stream << "\n";
      stream << indent_str;
      stream << "{";
      stream << "\n";
      stream << indent_str;
      indent = 2;
      stream << "  ";
      generate_string (parser_name, stream, indent + indent_str.length ());
      stream << "_print_version ();";
      indent = 0;
      stream << "\n";
      stream << indent_str;
      if (has_purpose)
        {
          stream << "  printf(\"\\n%s\\n\", \"";
          generate_string (purpose, stream, indent + indent_str.length ());
          stream << "\");";
          stream << "\n";
          stream << indent_str;
        }
      stream << "  printf(\"\\n";
      generate_string (usage_string, stream, indent + indent_str.length ());
      stream << "\\n\"";
      if (no_package)
        {
          stream << ", ";
          generate_string (package_var_name, stream, indent + indent_str.length ());
        }
      stream << ");";
      stream << "\n";
      stream << indent_str;
      indent = 2;
      stream << "  ";
      if (full_help_option_print.size () > 0)
        generate_string (full_help_option_print, stream, indent + indent_str.length ());
      else
        generate_full_help_option_print (stream, indent + indent_str.length ());
      indent = 0;
      stream << "\n";
      stream << indent_str;
      stream << "}";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
    }
  stream << "void";
  stream << "\n";
  stream << indent_str;
  generate_string (parser_name, stream, indent + indent_str.length ());
  stream << "_init (struct ";
  generate_string (args_info, stream, indent + indent_str.length ());
  stream << " *args_info)";
  stream << "\n";
  stream << indent_str;
  stream << "{";
  stream << "\n";
  stream << indent_str;
  stream << "  clear_given (args_info);";
  stream << "\n";
  stream << indent_str;
  stream << "  clear_args (args_info);";
  stream << "\n";
  stream << indent_str;
  if (handle_unamed)
    {
      stream << "\n";
      stream << indent_str;
      stream << "  args_info->inputs = NULL;";
      stream << "\n";
      stream << indent_str;
      stream << "  args_info->inputs_num = 0;";
      stream << "\n";
      stream << indent_str;
    }
  stream << "}";
  stream << "\n";
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  stream << "static void";
  stream << "\n";
  stream << indent_str;
  generate_string (parser_name, stream, indent + indent_str.length ());
  stream << "_release (struct ";
  generate_string (args_info, stream, indent + indent_str.length ());
  stream << " *args_info)";
  stream << "\n";
  stream << indent_str;
  stream << "{";
  stream << "\n";
  stream << indent_str;
  indent = 2;
  stream << "  ";
  if (free.size () > 0)
    generate_string (free, stream, indent + indent_str.length ());
  else
    generate_free (stream, indent + indent_str.length ());
  indent = 0;
  stream << "\n";
  stream << indent_str;
  stream << "  clear_given (args_info);";
  stream << "\n";
  stream << indent_str;
  stream << "}";
  stream << "\n";
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  stream << "int";
  stream << "\n";
  stream << indent_str;
  generate_string (parser_name, stream, indent + indent_str.length ());
  stream << "_file_save(const char *filename, struct ";
  generate_string (args_info, stream, indent + indent_str.length ());
  stream << " *args_info)";
  stream << "\n";
  stream << indent_str;
  stream << "{";
  stream << "\n";
  stream << indent_str;
  stream << "  FILE *outfile;";
  stream << "\n";
  stream << indent_str;
  stream << "  int i = 0;";
  stream << "\n";
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  stream << "  outfile = fopen(filename, \"w\");";
  stream << "\n";
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  stream << "  if (!outfile)";
  stream << "\n";
  stream << indent_str;
  stream << "    {";
  stream << "\n";
  stream << indent_str;
  stream << "      fprintf (stderr, \"%s: cannot open file for writing: %s\\n\", ";
  generate_string (package_var_name, stream, indent + indent_str.length ());
  stream << ", filename);";
  stream << "\n";
  stream << indent_str;
  stream << "      return EXIT_FAILURE;";
  stream << "\n";
  stream << indent_str;
  stream << "    }";
  stream << "\n";
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  indent = 2;
  stream << "  ";
  if (file_save_loop.size () > 0)
    generate_string (file_save_loop, stream, indent + indent_str.length ());
  else
    generate_file_save_loop (stream, indent + indent_str.length ());
  indent = 0;
  stream << "\n";
  stream << indent_str;
  stream << "  fclose (outfile);";
  stream << "\n";
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  stream << "  i = EXIT_SUCCESS;";
  stream << "\n";
  stream << indent_str;
  stream << "  return i;";
  stream << "\n";
  stream << indent_str;
  stream << "}";
  stream << "\n";
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  stream << "void";
  stream << "\n";
  stream << indent_str;
  generate_string (parser_name, stream, indent + indent_str.length ());
  stream << "_free (struct ";
  generate_string (args_info, stream, indent + indent_str.length ());
  stream << " *args_info)";
  stream << "\n";
  stream << indent_str;
  stream << "{";
  stream << "\n";
  stream << indent_str;
  indent = 2;
  stream << "  ";
  generate_string (parser_name, stream, indent + indent_str.length ());
  stream << "_release (args_info);";
  indent = 0;
  stream << "\n";
  stream << indent_str;
  if (conf_parser)
    {
      stream << "  if (cmd_line_list)";
      stream << "\n";
      stream << indent_str;
      stream << "    {";
      stream << "\n";
      stream << indent_str;
      stream << "      /* free the list of a previous call */";
      stream << "\n";
      stream << indent_str;
      stream << "      while (cmd_line_list) {";
      stream << "\n";
      stream << indent_str;
      stream << "        cmd_line_list_tmp = cmd_line_list;";
      stream << "\n";
      stream << indent_str;
      stream << "        cmd_line_list = cmd_line_list->next;";
      stream << "\n";
      stream << indent_str;
      stream << "        free (cmd_line_list_tmp->string_arg);";
      stream << "\n";
      stream << indent_str;
      stream << "        free (cmd_line_list_tmp);";
      stream << "\n";
      stream << indent_str;
      stream << "      }";
      stream << "\n";
      stream << indent_str;
      stream << "    }";
      stream << "\n";
      stream << indent_str;
    }
  stream << "}";
  stream << "\n";
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  if (check_possible_values)
    {
      stream << "/*";
      stream << "\n";
      stream << indent_str;
      stream << " * Returns:";
      stream << "\n";
      stream << indent_str;
      stream << " * - the index of the matched value";
      stream << "\n";
      stream << indent_str;
      stream << " * - -1 if no argument has been specified";
      stream << "\n";
      stream << indent_str;
      stream << " * - -2 if more than one value has matched";
      stream << "\n";
      stream << indent_str;
      stream << " */";
      stream << "\n";
      stream << indent_str;
      stream << "static int";
      stream << "\n";
      stream << indent_str;
      stream << "check_possible_values(const char *val, char *values[])";
      stream << "\n";
      stream << indent_str;
      stream << "{";
      stream << "\n";
      stream << indent_str;
      stream << "  int i, found, last;";
      stream << "\n";
      stream << indent_str;
      stream << "  size_t len;";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
      stream << "  if (!val)   /* otherwise strlen() crashes below */";
      stream << "\n";
      stream << indent_str;
      stream << "    return -1; /* -1 means no argument for the option */";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
      stream << "  found = last = 0;";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
      stream << "  for (i = 0, len = strlen(val); values[i]; ++i)";
      stream << "\n";
      stream << indent_str;
      stream << "    {";
      stream << "\n";
      stream << indent_str;
      stream << "      if (strncmp(val, values[i], len) == 0)";
      stream << "\n";
      stream << indent_str;
      stream << "        {";
      stream << "\n";
      stream << indent_str;
      stream << "          ++found;";
      stream << "\n";
      stream << indent_str;
      stream << "          last = i;";
      stream << "\n";
      stream << indent_str;
      stream << "          if (strlen(values[i]) == len)";
      stream << "\n";
      stream << indent_str;
      stream << "            return i; /* exact macth no need to check more */";
      stream << "\n";
      stream << indent_str;
      stream << "        }";
      stream << "\n";
      stream << indent_str;
      stream << "    }";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
      stream << "  if (found == 1) /* one match: OK */";
      stream << "\n";
      stream << indent_str;
      stream << "    return last;";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
      stream << "  return (found ? -2 : -1); /* return many values are matched */";
      stream << "\n";
      stream << indent_str;
      stream << "}";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
    }
  stream << "\n";
  stream << indent_str;
  if (do_generate_strdup)
    {
      stream << "/* gengetopt_strdup() */";
      stream << "\n";
      stream << indent_str;
      stream << "/* strdup.c replacement of strdup, which is not standard */";
      stream << "\n";
      stream << indent_str;
      stream << "char *";
      stream << "\n";
      stream << indent_str;
      stream << "gengetopt_strdup (const char *s)";
      stream << "\n";
      stream << indent_str;
      stream << "{";
      stream << "\n";
      stream << indent_str;
      stream << "  char *result = NULL;";
      stream << "\n";
      stream << indent_str;
      stream << "  if (!s)";
      stream << "\n";
      stream << indent_str;
      stream << "    return result;";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
      stream << "  result = (char*)malloc(strlen(s) + 1);";
      stream << "\n";
      stream << indent_str;
      stream << "  if (result == (char*)0)";
      stream << "\n";
      stream << indent_str;
      stream << "    return (char*)0;";
      stream << "\n";
      stream << indent_str;
      stream << "  strcpy(result, s);";
      stream << "\n";
      stream << indent_str;
      stream << "  return result;";
      stream << "\n";
      stream << indent_str;
      stream << "}";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
    }
  if (multiple_token_functions)
    {
      stream << "static char *";
      stream << "\n";
      stream << indent_str;
      stream << "get_multiple_arg_token(const char *arg)";
      stream << "\n";
      stream << indent_str;
      stream << "{";
      stream << "\n";
      stream << indent_str;
      stream << "  char *tok, *ret;";
      stream << "\n";
      stream << indent_str;
      stream << "  size_t len;";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
      stream << "  if (!arg)";
      stream << "\n";
      stream << indent_str;
      stream << "    return NULL;";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
      stream << "  tok = strchr (arg, ',');";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
      stream << "  if (tok)";
      stream << "\n";
      stream << indent_str;
      stream << "    len = (size_t)(tok - arg + 1);";
      stream << "\n";
      stream << indent_str;
      stream << "  else";
      stream << "\n";
      stream << indent_str;
      stream << "    len = strlen (arg) + 1;";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
      stream << "  ret = (char *) malloc (len);";
      stream << "\n";
      stream << indent_str;
      stream << "  strncpy (ret, arg, len-1);";
      stream << "\n";
      stream << indent_str;
      stream << "  ret[len-1] = '\\0';";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
      stream << "  return ret;";
      stream << "\n";
      stream << indent_str;
      stream << "}";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
      stream << "static char *";
      stream << "\n";
      stream << indent_str;
      stream << "get_multiple_arg_token_next(const char *arg)";
      stream << "\n";
      stream << indent_str;
      stream << "{";
      stream << "\n";
      stream << indent_str;
      stream << "  char *tok;";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
      stream << "  if (!arg)";
      stream << "\n";
      stream << indent_str;
      stream << "    return NULL;";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
      stream << "  tok = strchr (arg, ',');";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
      stream << "  if (! tok || strlen(tok) == 1)";
      stream << "\n";
      stream << indent_str;
      stream << "    return 0;";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
      stream << "  return tok+1;";
      stream << "\n";
      stream << indent_str;
      stream << "}";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
    }
  if (reset_groups.size () > 0)
    generate_string (reset_groups, stream, indent + indent_str.length ());
  else
    generate_reset_groups (stream, indent + indent_str.length ());
  stream << indent_str;
  stream << "int";
  stream << "\n";
  stream << indent_str;
  generate_string (parser_name, stream, indent + indent_str.length ());
  stream << " (int argc, char * const *argv, struct ";
  generate_string (args_info, stream, indent + indent_str.length ());
  stream << " *args_info)";
  stream << "\n";
  stream << indent_str;
  stream << "{";
  stream << "\n";
  stream << indent_str;
  stream << "  return ";
  generate_string (parser_name, stream, indent + indent_str.length ());
  stream << "2 (argc, argv, args_info, 0, 1, 1);";
  stream << "\n";
  stream << indent_str;
  stream << "}";
  stream << "\n";
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  stream << "int";
  stream << "\n";
  stream << indent_str;
  generate_string (parser_name, stream, indent + indent_str.length ());
  stream << "2 (int argc, char * const *argv, struct ";
  generate_string (args_info, stream, indent + indent_str.length ());
  stream << " *args_info, int override, int initialize, int check_required)";
  stream << "\n";
  stream << indent_str;
  stream << "{";
  stream << "\n";
  stream << indent_str;
  stream << "  int result;";
  stream << "\n";
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  stream << "  result = ";
  generate_string (parser_name, stream, indent + indent_str.length ());
  stream << "_internal (argc, argv, args_info, override, initialize, check_required, NULL);";
  stream << "\n";
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  indent = 2;
  stream << "  ";
  generate_string (final_exit, stream, indent + indent_str.length ());
  indent = 0;
  stream << "\n";
  stream << indent_str;
  stream << "}";
  stream << "\n";
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  stream << "int";
  stream << "\n";
  stream << indent_str;
  generate_string (parser_name, stream, indent + indent_str.length ());
  stream << "_required (struct ";
  generate_string (args_info, stream, indent + indent_str.length ());
  stream << " *args_info, const char *prog_name)";
  stream << "\n";
  stream << indent_str;
  stream << "{";
  stream << "\n";
  stream << indent_str;
  if (check_required_options)
    {
      stream << "  int result = EXIT_SUCCESS;";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
      stream << "  if (";
      generate_string (parser_name, stream, indent + indent_str.length ());
      stream << "_required2(args_info, prog_name, NULL) > 0)";
      stream << "\n";
      stream << indent_str;
      stream << "    result = EXIT_FAILURE;";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
      indent = 2;
      stream << "  ";
      generate_string (final_exit, stream, indent + indent_str.length ());
      indent = 0;
      stream << "\n";
      stream << indent_str;
    }
  else
    {
      stream << "  return EXIT_SUCCESS;";
      stream << "\n";
      stream << indent_str;
    }
  stream << "}";
  stream << "\n";
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  if (check_required_options)
    {
      stream << "int";
      stream << "\n";
      stream << indent_str;
      generate_string (parser_name, stream, indent + indent_str.length ());
      stream << "_required2 (struct ";
      generate_string (args_info, stream, indent + indent_str.length ());
      stream << " *args_info, const char *prog_name, const char *additional_error)";
      stream << "\n";
      stream << indent_str;
      stream << "{";
      stream << "\n";
      stream << indent_str;
      stream << "  int error = 0;";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
      indent = 2;
      if (handle_required.size () > 0)
        generate_string (handle_required, stream, indent + indent_str.length ());
      else
        generate_handle_required (stream, indent + indent_str.length ());
      indent = 0;
      stream << indent_str;
      indent = 2;
      if (handle_dependencies.size () > 0)
        generate_string (handle_dependencies, stream, indent + indent_str.length ());
      else
        generate_handle_dependencies (stream, indent + indent_str.length ());
      indent = 0;
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
      stream << "  return error;";
      stream << "\n";
      stream << indent_str;
      stream << "}";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
    }
  stream << "int";
  stream << "\n";
  stream << indent_str;
  generate_string (parser_name, stream, indent + indent_str.length ());
  stream << "_internal (int argc, char * const *argv, struct ";
  generate_string (args_info, stream, indent + indent_str.length ());
  stream << " *args_info, int override, int initialize, int check_required, const char *additional_error)";
  stream << "\n";
  stream << indent_str;
  stream << "{";
  stream << "\n";
  stream << indent_str;
  stream << "  int c;	/* Character of the parsed option.  */";
  stream << "\n";
  stream << indent_str;
  if (multiple_token_vars)
    {
      stream << "  char *multi_token, *multi_next; /* for multiple options */";
      stream << "\n";
      stream << indent_str;
    }
  stream << "\n";
  stream << indent_str;
  indent = 2;
  if (list_def.size () > 0)
    generate_string (list_def, stream, indent + indent_str.length ());
  else
    generate_list_def (stream, indent + indent_str.length ());
  indent = 0;
  stream << indent_str;
  stream << "  int error = 0;";
  stream << "\n";
  stream << indent_str;
  stream << "  struct ";
  generate_string (args_info, stream, indent + indent_str.length ());
  stream << " local_args_info;";
  stream << "\n";
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  stream << "  if (initialize)";
  stream << "\n";
  stream << indent_str;
  indent = 4;
  stream << "    ";
  generate_string (parser_name, stream, indent + indent_str.length ());
  stream << "_init (args_info);";
  indent = 0;
  stream << "\n";
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  indent = 2;
  stream << "  ";
  generate_string (parser_name, stream, indent + indent_str.length ());
  stream << "_init (&local_args_info);";
  indent = 0;
  stream << "\n";
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  stream << "  optarg = 0;";
  stream << "\n";
  stream << indent_str;
  stream << "  optind = 0;";
  stream << "\n";
  stream << indent_str;
  stream << "  opterr = 1;";
  stream << "\n";
  stream << indent_str;
  stream << "  optopt = '?';";
  stream << "\n";
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  stream << "  while (1)";
  stream << "\n";
  stream << indent_str;
  stream << "    {";
  stream << "\n";
  stream << indent_str;
  if (check_possible_values)
    {
      stream << "      int found = 0;";
      stream << "\n";
      stream << indent_str;
    }
  stream << "      int option_index = 0;";
  stream << "\n";
  stream << indent_str;
  stream << "      char *stop_char;";
  stream << "\n";
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  stream << "      static struct option long_options[] = {";
  stream << "\n";
  stream << indent_str;
  indent = 8;
  if (long_option_struct.size () > 0)
    generate_string (long_option_struct, stream, indent + indent_str.length ());
  else
    generate_long_option_struct (stream, indent + indent_str.length ());
  indent = 0;
  stream << indent_str;
  stream << "        { NULL,	0, NULL, 0 }";
  stream << "\n";
  stream << indent_str;
  stream << "      };";
  stream << "\n";
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  stream << "      stop_char = 0;";
  stream << "\n";
  stream << indent_str;
  stream << "      c = getopt_long (argc, argv, \"";
  generate_string (getopt_string, stream, indent + indent_str.length ());
  stream << "\", long_options, &option_index);";
  stream << "\n";
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  stream << "      if (c == -1) break;	/* Exit from `while (1)' loop.  */";
  stream << "\n";
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  stream << "      switch (c)";
  stream << "\n";
  stream << indent_str;
  stream << "        {";
  stream << "\n";
  stream << indent_str;
  indent = 8;
  if (handle_option.size () > 0)
    generate_string (handle_option, stream, indent + indent_str.length ());
  else
    generate_handle_option (stream, indent + indent_str.length ());
  indent = 0;
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  stream << "        case 0:	/* Long option with no short option */";
  stream << "\n";
  stream << indent_str;
  indent = 10;
  if (handle_no_short_option.size () > 0)
    generate_string (handle_no_short_option, stream, indent + indent_str.length ());
  else
    generate_handle_no_short_option (stream, indent + indent_str.length ());
  indent = 0;
  stream << indent_str;
  stream << "        case '?':	/* Invalid option.  */";
  stream << "\n";
  stream << indent_str;
  stream << "          /* `getopt_long' already printed an error message.  */";
  stream << "\n";
  stream << indent_str;
  stream << "          goto failure;";
  stream << "\n";
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  stream << "        default:	/* bug: option not considered.  */";
  stream << "\n";
  stream << indent_str;
  stream << "          fprintf (stderr, \"%s: option unknown: %c%s\\n\", ";
  generate_string (package_var_name, stream, indent + indent_str.length ());
  stream << ", c, (additional_error ? additional_error : \"\"));";
  stream << "\n";
  stream << indent_str;
  stream << "          abort ();";
  stream << "\n";
  stream << indent_str;
  stream << "        } /* switch */";
  stream << "\n";
  stream << indent_str;
  stream << "    } /* while */";
  stream << "\n";
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  indent = 2;
  if (handle_group.size () > 0)
    generate_string (handle_group, stream, indent + indent_str.length ());
  else
    generate_handle_group (stream, indent + indent_str.length ());
  indent = 0;
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  indent = 2;
  if (multiple_fill_array.size () > 0)
    generate_string (multiple_fill_array, stream, indent + indent_str.length ());
  else
    generate_multiple_fill_array (stream, indent + indent_str.length ());
  indent = 0;
  stream << indent_str;
  indent = 2;
  if (update_multiple_given.size () > 0)
    generate_string (update_multiple_given, stream, indent + indent_str.length ());
  else
    generate_update_multiple_given (stream, indent + indent_str.length ());
  indent = 0;
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  if (check_required_options)
    {
      stream << "  if (check_required)";
      stream << "\n";
      stream << indent_str;
      stream << "    {";
      stream << "\n";
      stream << indent_str;
      stream << "      error += ";
      generate_string (parser_name, stream, indent + indent_str.length ());
      stream << "_required2 (args_info, argv[0], additional_error);";
      stream << "\n";
      stream << indent_str;
      stream << "    }";
      stream << "\n";
      stream << indent_str;
    }
  stream << "\n";
  stream << indent_str;
  indent = 2;
  stream << "  ";
  generate_string (parser_name, stream, indent + indent_str.length ());
  stream << "_release (&local_args_info);";
  indent = 0;
  stream << "\n";
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  stream << "  if ( error )";
  stream << "\n";
  stream << indent_str;
  stream << "    return (EXIT_FAILURE);";
  stream << "\n";
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  if (handle_unamed)
    {
      stream << "  if (optind < argc)";
      stream << "\n";
      stream << indent_str;
      stream << "    {";
      stream << "\n";
      stream << indent_str;
      stream << "      int i = 0 ;";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
      stream << "      args_info->inputs_num = argc - optind ;";
      stream << "\n";
      stream << indent_str;
      stream << "      args_info->inputs =";
      stream << "\n";
      stream << indent_str;
      stream << "        (char **)(malloc ((args_info->inputs_num)*sizeof(char *))) ;";
      stream << "\n";
      stream << indent_str;
      stream << "      while (optind < argc)";
      stream << "\n";
      stream << indent_str;
      stream << "        args_info->inputs[ i++ ] = gengetopt_strdup (argv[optind++]) ;";
      stream << "\n";
      stream << indent_str;
      stream << "    }";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
    }
  stream << "  return 0;";
  stream << "\n";
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  stream << "failure:";
  stream << "\n";
  stream << indent_str;
  indent = 2;
  stream << "  ";
  if (list_free.size () > 0)
    generate_string (list_free, stream, indent + indent_str.length ());
  else
    generate_list_free (stream, indent + indent_str.length ());
  indent = 0;
  stream << "\n";
  stream << indent_str;
  indent = 2;
  stream << "  ";
  generate_string (parser_name, stream, indent + indent_str.length ());
  stream << "_release (&local_args_info);";
  indent = 0;
  stream << "\n";
  stream << indent_str;
  stream << "  return (EXIT_FAILURE);";
  stream << "\n";
  stream << indent_str;
  stream << "}";
  stream << "\n";
  stream << indent_str;
  if (conf_parser)
    {
      stream << "\n";
      stream << indent_str;
      stream << "#ifndef CONFIG_FILE_LINE_SIZE";
      stream << "\n";
      stream << indent_str;
      stream << "#define CONFIG_FILE_LINE_SIZE 2048";
      stream << "\n";
      stream << indent_str;
      stream << "#endif";
      stream << "\n";
      stream << indent_str;
      stream << "#define ADDITIONAL_ERROR \" in configuration file \"";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
      stream << "#define CONFIG_FILE_LINE_BUFFER_SIZE (CONFIG_FILE_LINE_SIZE+3)";
      stream << "\n";
      stream << indent_str;
      stream << "/* 3 is for \"--\" and \"=\" */";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
      stream << "char my_argv[CONFIG_FILE_LINE_BUFFER_SIZE+1];";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
      stream << "int";
      stream << "\n";
      stream << indent_str;
      generate_string (parser_name, stream, indent + indent_str.length ());
      stream << "_configfile (char * const filename, struct ";
      generate_string (args_info, stream, indent + indent_str.length ());
      stream << " *args_info, int override, int initialize, int check_required)";
      stream << "\n";
      stream << indent_str;
      stream << "{";
      stream << "\n";
      stream << indent_str;
      stream << "  FILE* file;";
      stream << "\n";
      stream << indent_str;
      stream << "  char linebuf[CONFIG_FILE_LINE_SIZE];";
      stream << "\n";
      stream << indent_str;
      stream << "  int line_num = 0;";
      stream << "\n";
      stream << indent_str;
      stream << "  int i, result, equal;";
      stream << "\n";
      stream << indent_str;
      stream << "  char *fopt, *farg;";
      stream << "\n";
      stream << indent_str;
      stream << "  char *str_index;";
      stream << "\n";
      stream << indent_str;
      stream << "  size_t len, next_token;";
      stream << "\n";
      stream << indent_str;
      stream << "  char delimiter;";
      stream << "\n";
      stream << indent_str;
      stream << "  int my_argc = 0;";
      stream << "\n";
      stream << indent_str;
      stream << "  char **my_argv_arg;";
      stream << "\n";
      stream << indent_str;
      stream << "  char *additional_error;";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
      stream << "  /* store the program name */";
      stream << "\n";
      stream << indent_str;
      stream << "  cmd_line_list_tmp = (struct line_list *) malloc (sizeof (struct line_list));";
      stream << "\n";
      stream << indent_str;
      stream << "  cmd_line_list_tmp->next = cmd_line_list;";
      stream << "\n";
      stream << indent_str;
      stream << "  cmd_line_list = cmd_line_list_tmp;";
      stream << "\n";
      stream << indent_str;
      stream << "  cmd_line_list->string_arg = gengetopt_strdup (";
      generate_string (package_var_name, stream, indent + indent_str.length ());
      stream << ");";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
      stream << "  if ((file = fopen(filename, \"r\")) == NULL)";
      stream << "\n";
      stream << indent_str;
      stream << "    {";
      stream << "\n";
      stream << indent_str;
      stream << "      fprintf (stderr, \"%s: Error opening configuration file '%s'\\n\",";
      stream << "\n";
      stream << indent_str;
      indent = 15;
      stream << "               ";
      generate_string (package_var_name, stream, indent + indent_str.length ());
      stream << ", filename);";
      indent = 0;
      stream << "\n";
      stream << indent_str;
      stream << "      result = EXIT_FAILURE;";
      stream << "\n";
      stream << indent_str;
      stream << "      goto conf_failure;";
      stream << "\n";
      stream << indent_str;
      stream << "    }";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
      stream << "  while ((fgets(linebuf, CONFIG_FILE_LINE_SIZE, file)) != NULL)";
      stream << "\n";
      stream << indent_str;
      stream << "    {";
      stream << "\n";
      stream << indent_str;
      stream << "      ++line_num;";
      stream << "\n";
      stream << indent_str;
      stream << "      my_argv[0] = '\\0';";
      stream << "\n";
      stream << indent_str;
      stream << "      len = strlen(linebuf);";
      stream << "\n";
      stream << indent_str;
      stream << "      if (len > (CONFIG_FILE_LINE_BUFFER_SIZE-1))";
      stream << "\n";
      stream << indent_str;
      stream << "        {";
      stream << "\n";
      stream << indent_str;
      stream << "          fprintf (stderr, \"%s:%s:%d: Line too long in configuration file\\n\",";
      stream << "\n";
      stream << indent_str;
      indent = 19;
      stream << "                   ";
      generate_string (package_var_name, stream, indent + indent_str.length ());
      stream << ", filename, line_num);";
      indent = 0;
      stream << "\n";
      stream << indent_str;
      stream << "          result = EXIT_FAILURE;";
      stream << "\n";
      stream << indent_str;
      stream << "          goto conf_failure;";
      stream << "\n";
      stream << indent_str;
      stream << "        }";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
      stream << "      /* find first non-whitespace character in the line */";
      stream << "\n";
      stream << indent_str;
      stream << "      next_token = strspn ( linebuf, \" \\t\\r\\n\");";
      stream << "\n";
      stream << indent_str;
      stream << "      str_index  = linebuf + next_token;";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
      stream << "      if ( str_index[0] == '\\0' || str_index[0] == '#')";
      stream << "\n";
      stream << indent_str;
      stream << "        continue; /* empty line or comment line is skipped */";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
      stream << "      fopt = str_index;";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
      stream << "      /* truncate fopt at the end of the first non-valid character */";
      stream << "\n";
      stream << indent_str;
      stream << "      next_token = strcspn (fopt, \" \\t\\r\\n=\");";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
      stream << "      if (fopt[next_token] == '\\0') /* the line is over */";
      stream << "\n";
      stream << indent_str;
      stream << "        {";
      stream << "\n";
      stream << indent_str;
      stream << "          farg  = NULL;";
      stream << "\n";
      stream << indent_str;
      stream << "          equal = 0;";
      stream << "\n";
      stream << indent_str;
      stream << "          goto noarg;";
      stream << "\n";
      stream << indent_str;
      stream << "        }";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
      stream << "      /* remember if equal sign is present */";
      stream << "\n";
      stream << indent_str;
      stream << "      equal = (fopt[next_token] == '=');";
      stream << "\n";
      stream << indent_str;
      stream << "      fopt[next_token++] = '\\0';";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
      stream << "      /* advance pointers to the next token after the end of fopt */";
      stream << "\n";
      stream << indent_str;
      stream << "      next_token += strspn (fopt + next_token, \" \\t\\r\\n\");";
      stream << "\n";
      stream << indent_str;
      stream << "      /* check for the presence of equal sign, and if so, skip it */";
      stream << "\n";
      stream << indent_str;
      stream << "      if ( !equal )";
      stream << "\n";
      stream << indent_str;
      stream << "        if ((equal = (fopt[next_token] == '=')))";
      stream << "\n";
      stream << indent_str;
      stream << "          {";
      stream << "\n";
      stream << indent_str;
      stream << "            next_token++;";
      stream << "\n";
      stream << indent_str;
      stream << "            next_token += strspn (fopt + next_token, \" \\t\\r\\n\");";
      stream << "\n";
      stream << indent_str;
      stream << "          }";
      stream << "\n";
      stream << indent_str;
      stream << "      str_index  += next_token;";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
      stream << "      /* find argument */";
      stream << "\n";
      stream << indent_str;
      stream << "      farg = str_index;";
      stream << "\n";
      stream << indent_str;
      stream << "      if ( farg[0] == '\\\"' || farg[0] == '\\'' )";
      stream << "\n";
      stream << indent_str;
      stream << "        { /* quoted argument */";
      stream << "\n";
      stream << indent_str;
      stream << "          str_index = strchr (++farg, str_index[0] ); /* skip opening quote */";
      stream << "\n";
      stream << indent_str;
      stream << "          if (! str_index)";
      stream << "\n";
      stream << indent_str;
      stream << "            {";
      stream << "\n";
      stream << indent_str;
      stream << "              fprintf";
      stream << "\n";
      stream << indent_str;
      stream << "                (stderr,";
      stream << "\n";
      stream << indent_str;
      stream << "                 \"%s:%s:%d: unterminated string in configuration file\\n\",";
      stream << "\n";
      stream << indent_str;
      indent = 17;
      stream << "                 ";
      generate_string (package_var_name, stream, indent + indent_str.length ());
      stream << ", filename, line_num);";
      indent = 0;
      stream << "\n";
      stream << indent_str;
      stream << "              result = EXIT_FAILURE;";
      stream << "\n";
      stream << indent_str;
      stream << "              goto conf_failure;";
      stream << "\n";
      stream << indent_str;
      stream << "            }";
      stream << "\n";
      stream << indent_str;
      stream << "        }";
      stream << "\n";
      stream << indent_str;
      stream << "      else";
      stream << "\n";
      stream << indent_str;
      stream << "        { /* read up the remaining part up to a delimiter */";
      stream << "\n";
      stream << indent_str;
      stream << "          next_token = strcspn (farg, \" \\t\\r\\n#\\'\\\"\");";
      stream << "\n";
      stream << indent_str;
      stream << "          str_index += next_token;";
      stream << "\n";
      stream << indent_str;
      stream << "        }";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
      stream << "      /* truncate farg at the delimiter and store it for further check */";
      stream << "\n";
      stream << indent_str;
      stream << "      delimiter = *str_index, *str_index++ = '\\0';";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
      stream << "      /* everything but comment is illegal at the end of line */";
      stream << "\n";
      stream << indent_str;
      stream << "      if (delimiter != '\\0' && delimiter != '#')";
      stream << "\n";
      stream << indent_str;
      stream << "        {";
      stream << "\n";
      stream << indent_str;
      stream << "          str_index += strspn(str_index, \" \\t\\r\\n\");";
      stream << "\n";
      stream << indent_str;
      stream << "          if (*str_index != '\\0' && *str_index != '#')";
      stream << "\n";
      stream << indent_str;
      stream << "            {";
      stream << "\n";
      stream << indent_str;
      stream << "              fprintf";
      stream << "\n";
      stream << indent_str;
      stream << "                (stderr,";
      stream << "\n";
      stream << indent_str;
      stream << "                 \"%s:%s:%d: malformed string in configuration file\\n\",";
      stream << "\n";
      stream << indent_str;
      indent = 17;
      stream << "                 ";
      generate_string (package_var_name, stream, indent + indent_str.length ());
      stream << ", filename, line_num);";
      indent = 0;
      stream << "\n";
      stream << indent_str;
      stream << "              result = EXIT_FAILURE;";
      stream << "\n";
      stream << indent_str;
      stream << "              goto conf_failure;";
      stream << "\n";
      stream << indent_str;
      stream << "            }";
      stream << "\n";
      stream << indent_str;
      stream << "        }";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
      stream << "    noarg:";
      stream << "\n";
      stream << indent_str;
      stream << "      ++my_argc;";
      stream << "\n";
      stream << indent_str;
      stream << "      len = strlen(fopt);";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
      stream << "      strcat (my_argv, len > 1 ? \"--\" : \"-\");";
      stream << "\n";
      stream << indent_str;
      stream << "      strcat (my_argv, fopt);";
      stream << "\n";
      stream << indent_str;
      stream << "      if (len > 1 && ((farg &&*farg) || equal))";
      stream << "\n";
      stream << indent_str;
      stream << "          strcat (my_argv, \"=\");";
      stream << "\n";
      stream << indent_str;
      stream << "      if (farg && *farg)";
      stream << "\n";
      stream << indent_str;
      stream << "          strcat (my_argv, farg);";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
      stream << "      cmd_line_list_tmp = (struct line_list *) malloc (sizeof (struct line_list));";
      stream << "\n";
      stream << indent_str;
      stream << "      cmd_line_list_tmp->next = cmd_line_list;";
      stream << "\n";
      stream << indent_str;
      stream << "      cmd_line_list = cmd_line_list_tmp;";
      stream << "\n";
      stream << indent_str;
      stream << "      cmd_line_list->string_arg = gengetopt_strdup(my_argv);";
      stream << "\n";
      stream << indent_str;
      stream << "    } /* while */";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
      stream << "  ++my_argc; /* for program name */";
      stream << "\n";
      stream << indent_str;
      stream << "  my_argv_arg = (char **) malloc((my_argc+1) * sizeof(char *));";
      stream << "\n";
      stream << indent_str;
      stream << "  cmd_line_list_tmp = cmd_line_list;";
      stream << "\n";
      stream << indent_str;
      stream << "  for (i = my_argc - 1; i >= 0; --i) {";
      stream << "\n";
      stream << indent_str;
      stream << "    my_argv_arg[i] = cmd_line_list_tmp->string_arg;";
      stream << "\n";
      stream << indent_str;
      stream << "    cmd_line_list_tmp = cmd_line_list_tmp->next;";
      stream << "\n";
      stream << indent_str;
      stream << "  }";
      stream << "\n";
      stream << indent_str;
      stream << "  my_argv_arg[my_argc] = 0;";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
      stream << "  additional_error = (char *)malloc(strlen(filename) + strlen(ADDITIONAL_ERROR) + 1);";
      stream << "\n";
      stream << indent_str;
      stream << "  strcpy (additional_error, ADDITIONAL_ERROR);";
      stream << "\n";
      stream << indent_str;
      stream << "  strcat (additional_error, filename);";
      stream << "\n";
      stream << indent_str;
      stream << "  result =";
      stream << "\n";
      stream << indent_str;
      indent = 4;
      stream << "    ";
      generate_string (parser_name, stream, indent + indent_str.length ());
      stream << "_internal (my_argc, my_argv_arg, args_info, override, initialize, check_required, additional_error);";
      indent = 0;
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
      stream << "  free (additional_error);";
      stream << "\n";
      stream << indent_str;
      stream << "  free (my_argv_arg);";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
      stream << "conf_failure:";
      stream << "\n";
      stream << indent_str;
      stream << "  if (file)";
      stream << "\n";
      stream << indent_str;
      stream << "    fclose(file);";
      stream << "\n";
      stream << indent_str;
      indent = 2;
      stream << "  ";
      generate_string (final_exit, stream, indent + indent_str.length ());
      indent = 0;
      stream << "\n";
      stream << indent_str;
      stream << "}";
      stream << "\n";
      stream << indent_str;
    }
}
