/*   -*- buffer-read-only: t -*- vi: set ro:
 *  
 *  DO NOT EDIT THIS FILE   (xmlopts.h)
 *  
 *  It has been AutoGen-ed  Sunday October 24, 2004 at 12:40:51 PM PDT
 *  From the definitions    ./xmlopts.def
 *  and the template file   options
 */
/*
 *  This file contains the programmatic interface to the Automated
 *  Options generated for the xml2ag program.
 *  These macros are documented in the AutoGen info file in the
 *  "AutoOpts" chapter.  Please refer to that doc for usage help.
 */
#ifndef AUTOOPTS_XMLOPTS_H_GUARD
#define AUTOOPTS_XMLOPTS_H_GUARD

/*
 * xml2ag copyright 1992-2004 Bruce Korb - all rights reserved
 *
 * xml2ag is free software.
 * 
 * You may redistribute it and/or modify it under the terms of the
 * GNU General Public License, as published by the Free Software
 * Foundation; either version 2, or (at your option) any later version.
 * 
 * xml2ag is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with xml2ag.  See the file "COPYING".  If not,
 * write to:  The Free Software Foundation, Inc.,
 *            59 Temple Place - Suite 330,
 *            Boston,  MA  02111-1307, USA.
 */
#include <options.h>

/*
 *  Enumeration of each option:
 */
typedef enum {
        INDEX_OPT_OUTPUT           =  0,
        INDEX_OPT_TEMPL_DIRS       =  1,
        INDEX_OPT_OVERRIDE_TPL     =  2,
        INDEX_OPT_LIB_TEMPLATE     =  3,
        INDEX_OPT_BASE_NAME        =  4,
        INDEX_OPT_DEFINITIONS      =  5,
        INDEX_OPT_LOAD_SCHEME      =  6,
        INDEX_OPT_LOAD_FUNCTIONS   =  7,
        INDEX_OPT_SKIP_SUFFIX      =  8,
        INDEX_OPT_SELECT_SUFFIX    =  9,
        INDEX_OPT_SOURCE_TIME      = 10,
        INDEX_OPT_NO_FMEMOPEN      = 11,
        INDEX_OPT_EQUATE           = 12,
        INDEX_OPT_WRITABLE         = 13,
        INDEX_OPT_LOOP_LIMIT       = 14,
        INDEX_OPT_TIMEOUT          = 15,
        INDEX_OPT_TRACE            = 16,
        INDEX_OPT_TRACE_OUT        = 17,
        INDEX_OPT_SHOW_DEFS        = 18,
        INDEX_OPT_SHOW_SHELL       = 19,
        INDEX_OPT_DEFINE           = 20,
        INDEX_OPT_UNDEFINE         = 21,
        INDEX_OPT_VERSION          = 22,
        INDEX_OPT_HELP             = 23,
        INDEX_OPT_MORE_HELP        = 24
} teOptIndex;

#define OPTION_CT    25
#define XML2AG_VERSION       "5.6.4"
#define XML2AG_FULL_VERSION  "xml2ag - XML to AutoGen Definiton Converter - Ver. 5.6.4"

/*
 *  Interface defines for all options.  Replace "n" with
 *  the UPPER_CASED option name (as in the teOptIndex
 *  enumeration above).  e.g. HAVE_OPT( OUTPUT )
 */
#define         DESC(n) xml2agOptions.pOptDesc[INDEX_OPT_ ## n]
#define     HAVE_OPT(n) (! UNUSED_OPT(& DESC(n)))
#define      OPT_ARG(n) (DESC(n).pzLastArg)
#define    STATE_OPT(n) (DESC(n).fOptState & OPTST_SET_MASK)
#define    COUNT_OPT(n) (DESC(n).optOccCt)
#define    ISSEL_OPT(n) (SELECTED_OPT(&DESC(n)))
#define ISUNUSED_OPT(n) (UNUSED_OPT(& DESC(n)))
#define  ENABLED_OPT(n) (! DISABLED_OPT(& DESC(n)))
#define  STACKCT_OPT(n) (((tArgList*)(DESC(n).optCookie))->useCt)
#define STACKLST_OPT(n) (((tArgList*)(DESC(n).optCookie))->apzArgs)
#define    CLEAR_OPT(n) STMTS( \
                DESC(n).fOptState &= OPTST_PERSISTENT;   \
                if ( (DESC(n).fOptState & OPTST_INITENABLED) == 0) \
                    DESC(n).fOptState |= OPTST_DISABLED; \
                DESC(n).optCookie = NULL )

/*
 *  Interface defines for specific options.
 */
#define VALUE_OPT_OUTPUT         'O'
#define VALUE_OPT_TEMPL_DIRS     'L'
#define VALUE_OPT_OVERRIDE_TPL   'T'
#define VALUE_OPT_LIB_TEMPLATE   'l'
#define VALUE_OPT_BASE_NAME      'b'
#define SET_OPT_BASE_NAME(a)   STMTS( \
        DESC(BASE_NAME).optActualIndex = 4; \
        DESC(BASE_NAME).optActualValue = VALUE_OPT_BASE_NAME; \
        DESC(BASE_NAME).fOptState &= OPTST_PERSISTENT; \
        DESC(BASE_NAME).fOptState |= OPTST_SET; \
        DESC(BASE_NAME).pzLastArg  = (tCC*)(a) )
#define VALUE_OPT_DEFINITIONS    5
#define VALUE_OPT_LOAD_SCHEME    'S'
#ifdef HAVE_DLOPEN
#define VALUE_OPT_LOAD_FUNCTIONS 'F'
#endif /* HAVE_DLOPEN */
#define VALUE_OPT_SKIP_SUFFIX    's'
#define VALUE_OPT_SELECT_SUFFIX  'o'
#define VALUE_OPT_SOURCE_TIME    10
#ifdef ENABLE_FMEMOPEN
#define VALUE_OPT_NO_FMEMOPEN    'm'
#endif /* ENABLE_FMEMOPEN */
#define VALUE_OPT_EQUATE         12
#define VALUE_OPT_WRITABLE       13
#define VALUE_OPT_LOOP_LIMIT     14
#define OPT_VALUE_LOOP_LIMIT     (*(unsigned long*)(&DESC(LOOP_LIMIT).pzLastArg))
#define VALUE_OPT_TIMEOUT        't'
#define OPT_VALUE_TIMEOUT        (*(unsigned long*)(&DESC(TIMEOUT).pzLastArg))
typedef enum {
    TRACE_NOTHING,        TRACE_TEMPLATES,      TRACE_BLOCK_MACROS,
    TRACE_EXPRESSIONS,    TRACE_EVERYTHING
} te_Trace;
#define VALUE_OPT_TRACE          16
#define OPT_VALUE_TRACE          (*(te_Trace*)(&DESC(TRACE).pzLastArg))
#define VALUE_OPT_TRACE_OUT      17
#define VALUE_OPT_SHOW_DEFS      18
#define VALUE_OPT_SHOW_SHELL     19
#define VALUE_OPT_DEFINE         'D'
#define WHICH_OPT_DEFINE         (DESC(DEFINE).optActualValue)
#define WHICH_IDX_DEFINE         (DESC(DEFINE).optActualIndex)
#define VALUE_OPT_UNDEFINE       'U'

#define VALUE_OPT_VERSION       'v'
#define VALUE_OPT_HELP          '?'
#define VALUE_OPT_MORE_HELP     '!'

/*
 *  Interface defines not associated with particular options
 */
#define ERRSKIP_OPTERR  STMTS( xml2agOptions.fOptSet &= ~OPTPROC_ERRSTOP )
#define ERRSTOP_OPTERR  STMTS( xml2agOptions.fOptSet |= OPTPROC_ERRSTOP )
#define RESTART_OPT(n)  STMTS( \
                xml2agOptions.curOptIdx = (n); \
                xml2agOptions.pzCurOpt  = NULL )
#define START_OPT       RESTART_OPT(1)
#define USAGE(c)        (*xml2agOptions.pUsageProc)( &xml2agOptions, c )

/* * * * * *
 *
 *  Declare the xml2ag option descriptor.
 */
#ifdef  __cplusplus
extern "C" {
#endif

extern tOptions   xml2agOptions;

/* * * * * *
 *
 *  Globals exported from the XML to AutoGen Definiton Converter option definitions
 */
#include <sys/types.h>
#include <sys/stat.h>

#define __USE_POSIX /* for glib's pedantic needs */
#define __USE_XOPEN_EXTENDED  /* ditto */
#include <stdio.h>
#include <ctype.h>
#include <errno.h>
#include <fcntl.h>
#include <limits.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include <libxml/parser.h>
#include <libxml/tree.h>

extern FILE* outFp;
#ifndef NUL
#  define NUL '\0'
#endif
extern void forkAutogen( tCC* pzInput );

#ifndef _
#  if ENABLE_NLS
#    include <stdio.h>
     static inline char* aoGetsText( const char* pz ) {
         if (pz == NULL) return NULL;
         return (char*)gettext( pz );
     }
#    define _(s)  aoGetsText(s)
#  else  /* ENABLE_NLS */
#    define _(s)  s
#  endif /* ENABLE_NLS */
#endif

#ifdef  __cplusplus
}
#endif
#endif /* AUTOOPTS_XMLOPTS_H_GUARD */
