/*
 *  Tables of Text Functions for AutoGen
 *
 *  DO NOT EDIT THIS FILE   (agfunc.h)
 *  
 *  It has been autogen-ed  Friday November  5, 1999 at 01:42:06 PM PST
 *  From the definitions    stdin
 *  and the template file   agfunc.tpl
 *
 *  copyright 1992-1999 Bruce Korb
 *
 *  AutoGen is free software.
 *  
 *  You may redistribute it and/or modify it under the terms of the
 *  GNU General Public License, as published by the Free Software
 *  Foundation; either version 2, or (at your option) any later version.
 *  
 *  AutoGen is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *  See the GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with AutoGen.  See the file "COPYING".  If not,
 *  write to:  The Free Software Foundation, Inc.,
 *             59 Temple Place - Suite 330,
 *             Boston,  MA  02111-1307, USA.
 */
#ifndef AUTOGEN_FUNC_H
#define AUTOGEN_FUNC_H

#define FUNC_CT    18

extern tpLoadProc   apLoadProc[   FUNC_CT ];
extern tpHdlrProc   apHdlrProc[   FUNC_CT ];
extern char*        apzFuncNames[ FUNC_CT ];
extern tpLoadProc*  papLoadProc;

/*
 *  Enumerate all the function types, whether they have
 *  implementation functions or not.
 */
typedef enum {
    FTYP_BOGUS        /* Out-of-context or unknown function */,
    FTYP_CASE         /* Select one of several template blocks */,
    FTYP_COMMENT      /* A block of comment to be ignored */,
    FTYP_COND_EVAL    /* Eval Expression Conditionally */,
    FTYP_ELIF         /* Alternate Conditional Template Block */,
    FTYP_ELSE         /* Alternate Template Block */,
    FTYP_ENDFOR       /* Terminates the _FOR function template block */,
    FTYP_ENDIF        /* Terminate the @code{IF} Template Block */,
    FTYP_ERROR        /* Cease processing */,
    FTYP_ESAC         /* Terminate the @code{CASE} Template Block */,
    FTYP_EVAL         /* Evaluate and Emit an Expression */,
    FTYP_FOR          /* Emit a template block multiple times */,
    FTYP_IF           /* Conditionally Emit a Template Block */,
    FTYP_INCLUDE      /* Read in and emit a template block */,
    FTYP_OUTPUT       /* Alter the output file */,
    FTYP_SELECT       /* Selection block for _CASE function */,
    FTYP_SETENV       /* Compute and Save an Expression */,
    FTYP_TEXT         /* A block of text to be emitted */
} teFuncType;

/*
 *  All of the function procedures.
 */
tHdlrProc mFunc_Case;
tLoadProc mLoad_CASE;
tLoadProc mLoad_Comment;
tHdlrProc mFunc_Cond_Eval;
tLoadProc mLoad_Cond_Eval;
tHdlrProc mFunc_Error;
tLoadProc mLoad_ERROR;
tHdlrProc mFunc_Eval;
tHdlrProc mFunc_For;
tLoadProc mLoad_FOR;
tHdlrProc mFunc_If;
tLoadProc mLoad_IF;
tHdlrProc mFunc_Include;
tLoadProc mLoad_INCLUDE;
tHdlrProc mFunc_Output;
tHdlrProc mFunc_Setenv;
tHdlrProc mFunc_Text;
tLoadProc mLoad_Macro;
tLoadProc mLoad_Context;
tHdlrProc mFunc_Bogus;

#ifdef AGFUNC_PRIVATE  /* agFunc.c use only */

/*
 *  Pointers to the procedure to call when the function type
 *  is encountered.  Member functions of the block functions
 *  (IF, CASE and FOR) are redirected to Bogus.
 */
tpHdlrProc  apHdlrProc[ 18 ] = {
    /* Bogus       */ &mFunc_Bogus,
    /* CASE        */ &mFunc_Case,
    /* Comment     */ &mFunc_Bogus,
    /* Cond_Eval   */ &mFunc_Cond_Eval,
    /* ELIF        */ &mFunc_Bogus,
    /* ELSE        */ &mFunc_Bogus,
    /* ENDFOR      */ &mFunc_Bogus,
    /* ENDIF       */ &mFunc_Bogus,
    /* ERROR       */ &mFunc_Error,
    /* ESAC        */ &mFunc_Bogus,
    /* EVAL        */ &mFunc_Eval,
    /* FOR         */ &mFunc_For,
    /* IF          */ &mFunc_If,
    /* INCLUDE     */ &mFunc_Include,
    /* OUTPUT      */ &mFunc_Output,
    /* SELECT      */ &mFunc_Bogus,
    /* SETENV      */ &mFunc_Setenv,
    /* Text        */ &mFunc_Text
};

/*
 *  Pointers for the load processing (template scanning phase)
 */
tpLoadProc  apLoadProc[ 18 ] = {
    /* Bogus       */ &mLoad_Context,
    /* CASE        */ &mLoad_CASE,
    /* Comment     */ &mLoad_Comment,
    /* Cond_Eval   */ &mLoad_Cond_Eval,
    /* ELIF        */ &mLoad_Context,
    /* ELSE        */ &mLoad_Context,
    /* ENDFOR      */ &mLoad_Context,
    /* ENDIF       */ &mLoad_Context,
    /* ERROR       */ &mLoad_ERROR,
    /* ESAC        */ &mLoad_Context,
    /* EVAL        */ &mLoad_Macro,
    /* FOR         */ &mLoad_FOR,
    /* IF          */ &mLoad_IF,
    /* INCLUDE     */ &mLoad_INCLUDE,
    /* OUTPUT      */ &mLoad_Macro,
    /* SELECT      */ &mLoad_Context,
    /* SETENV      */ &mLoad_Macro,
    /* Text        */ &mLoad_Macro
};
tpLoadProc* papLoadProc = apLoadProc;


/*
 *  Define all the strings that are used to determine
 *  the function enumeration number.
 *  These strings are *NOT* NUL terminated.
 */
tSCC zFuncStr_Case[    4 ] = "CASE";
tSCC zFuncStr_Elif[    4 ] = "ELIF";
tSCC zFuncStr_Else[    4 ] = "ELSE";
tSCC zFuncStr_Endif[   5 ] = "ENDIF";
tSCC zFuncStr_Error[   5 ] = "ERROR";
tSCC zFuncStr_Esac[    4 ] = "ESAC";
tSCC zFuncStr_Eval[    4 ] = "EVAL";
tSCC zFuncStr_For[     3 ] = "FOR";
tSCC zFuncStr_If[      2 ] = "IF";
tSCC zFuncStr_Include[ 7 ] = "INCLUDE";
tSCC zFuncStr_Output[  6 ] = "OUTPUT";
tSCC zFuncStr_Setenv[  6 ] = "SETENV";


#define   NAMED_FUNC_CT  12

typedef struct name_type tNameType;
struct name_type {
    size_t      cmpLen;  /* compare length (sans NUL) */
    tCC*        pName;   /* ptr to name */
    teFuncType  fType;   /* function type enum */
    int         unused;
};


tNameType nameTypeTable[ NAMED_FUNC_CT ] = {
  { 4, zFuncStr_Case,     FTYP_CASE,     0 },
  { 4, zFuncStr_Elif,     FTYP_ELIF,     0 },
  { 4, zFuncStr_Else,     FTYP_ELSE,     0 },
  { 5, zFuncStr_Endif,    FTYP_ENDIF,    0 },
  { 5, zFuncStr_Error,    FTYP_ERROR,    0 },
  { 4, zFuncStr_Esac,     FTYP_ESAC,     0 },
  { 4, zFuncStr_Eval,     FTYP_EVAL,     0 },
  { 3, zFuncStr_For,      FTYP_FOR,      0 },
  { 2, zFuncStr_If,       FTYP_IF,       0 },
  { 7, zFuncStr_Include,  FTYP_INCLUDE,  0 },
  { 6, zFuncStr_Output,   FTYP_OUTPUT,   0 },
  { 6, zFuncStr_Setenv,   FTYP_SETENV,   0 },
};

char*  apzFuncNames[ FUNC_CT ] = {
    "Bogus",       "CASE",        "Comment",     "Cond_Eval",   "ELIF",
    "ELSE",        "ENDFOR",      "ENDIF",       "ERROR",       "ESAC",
    "EVAL",        "FOR",         "IF",          "INCLUDE",     "OUTPUT",
    "SELECT",      "SETENV",      "Text" };

#endif /* AGFUNC_PRIVATE */
#endif /* AUTOGEN_FUNC_H */
