/* Macro defintions for dbx in coff for systems using
   the GNU assembler version which generates COFF objects
   containing DBX symbols.
   Copyright (C) 1989 Free Software Foundation, Inc.

This file is part of GDB.

GDB is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 1, or (at your option)
any later version.

GDB is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GDB; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

/* TO BE INCLUDED BY ANY m- file used for coff with dbx stabs */

/* Set namestring based on bufp. - coff version  */

#define SET_NAMESTRING()\
  if ( (bufp->n_un.n_strx < 0 || bufp->n_un.n_strx >= stringtab_size)	\
      && ! _obstack_allocated_p(current_extra_strings_obstack,		\
				bufp->n_un.n_strx + stringtab) )	\
    error ("Invalid symbol data: bad string table offset: %d", 		\
	   bufp->n_un.n_strx); 						\
  namestring = bufp->n_un.n_strx + stringtab


#define IS_DOT_FILE(name) ( name [0] == '.' && name [1] == 'f' 	\
			      && name [2] == 'i' && name [3] == 'l'	\
			      && name [4] == 'e' && name [5] == 0 )

#define IS_DOT_TEXT(name) ( name [0] == '.' && name [1] == 't'	\
			      && name [2] == 'e' && name [3] == 'x'	\
			      && name [4] == 't' && name [5] == 0 )

#ifdef sun386
/* On the sun386i, the .file symbol oddly (and fortunately) has the same value
   as the .text should have symbol DESPITE (!) it having scnum -2, and the
   all .text symbols are combined into one by sun ld. */

#define IS_O_FILE_START(name,len) IS_DOT_FILE(name)

#else /* not sun386 */

#define IS_O_FILE_START(name,len) IS_DOT_TEXT(name)
#endif /* not sun386 */ 

/* Macro to declare variables to hold the file's header data.  */
#define DECLARE_FILE_HEADERS  struct aouthdr hdr; 		\
	 FILHDR coffhdr; SCNHDR scn[10];			\
	extern int text_scn, data_scn, bss_scn

/* macro to declare the entry point of this file */
#define ENTRY_POINT hdr.entry

/* Macro for number of symbol table entries */
#define NUMBER_OF_SYMBOLS (coffhdr.f_nsyms)

/* Macro for file-offset of string table (in usual a.out format).  */
#define STRING_TABLE_OFFSET (coffhdr.f_symptr+coffhdr.f_nsyms*SYMESZ)

/* Macro for file-offset of symbol table (in usual a.out format).  */
#define SYMBOL_TABLE_OFFSET (coffhdr.f_symptr)

/* macro to distinguish relocatable object from non relocatable object */
#define IS_OBJECT_FILE ((hdr.f_flags & F_EXEC) == 0)

/* Get the address in debugged memory of the start
   of the text segment.  */
#define ADDR_OF_TEXT_SEGMENT (scn[text_scn].s_vaddr)

/* Macro for size of text segment */
#define SIZE_OF_TEXT_SEGMENT (scn[text_scn].s_size)

/* Macro to read the header data from descriptor DESC and validate it.
   NAME is the file name, for error messages.  */

#define READ_FILE_HEADERS(DESC, NAME)				\
{ int optsz,i;							\
  int val = myread (DESC, &coffhdr, sizeof coffhdr);		\
  if (val < 0)							\
    perror_with_name (NAME);					\
  if (!ISCOFF(coffhdr.f_magic))					\
    error ("File \"%s\" not in coff executable format.", NAME);	\
  number_of_symbols = coffhdr.f_nsyms;				\
  optsz = (coffhdr.f_opthdr> sizeof hdr)?sizeof hdr:coffhdr.f_opthdr; \
  val = myread (DESC, &hdr, optsz);				\
  if (val < 0)							\
    perror_with_name (NAME);					\
/*  if (N_BADMAG (hdr))						\
    error ("File \"%s\" not in executable format.", NAME); */   \
  bzero(&scn[0],sizeof(scn[0]));				\
  val = myread (DESC, &scn[1], sizeof scn[0]*coffhdr.f_nscns);	\
  if (val < 0)							\
    perror_with_name (NAME);					\
  clear_coff_sections();					\
  for (i = 1; i <=coffhdr.f_nscns;i++) 				\
    map_coff_section(i,&scn[i]);				\
}

/* This is the type to set unwanted symbols to in convert_symbuf() */
#define IGNORED_SYMBOL_TYPE ( 0xff)

/* Auxents containing line table indexes are converted to symbols
   having this type: */
#define N_MULTI_LINE_TYPE ( 0xf0)

/* Enstabbed coff private type that indicates number of line table entries
   to be processed at this point during symbol readin. */
#define N_LINE_COUNT_TYPE ( 0xf1)

/* This is how dbxread recognizes symbols to be ignored */
#define IGNORE_SYMBOL(type) (IGNORED_SYMBOL_TYPE==type)

/* This is how to increment a pointer to a symbol. usually: p++ */
#define SYMENT_INCR(p)  p = (struct syment *) ((int)p + SYMESZ )

/* This is how to index into an arrayof symbols. Usually: ptr[index]  */
#define SYMENT_INDEX(ptr,index) (* (struct syment *) ((int)ptr + index*SYMESZ))

/* define this if a private object format specific routine should be
   used to fill a buffer of symbols */
#define FILL_SYMBUF \
	symbuf_end = convert_symbuf(symtab_input_desc, symbuf, stringtab);

/* define this if absolute values are used for block symbols */
#define BLOCK_ADDRESS_ABSOLUTE

#define NO_NATIVE_STAB_INCLUDE

#define STABS_BEFORE_GCC_COMPILED

#define ONDISK_SYMBOL_SIZE SYMESZ 

#define EXTRA_STRINGS_INIT(type) {  \
  reinitialize_extra_strings(type); }
