#ifndef __COFF_DBX_H__
#define __COFF_DBX_H__

/* declare these in case the local headers are not for machine we are
   are building for */
#ifdef m68k
#define COFF_MAGIC MC68MAGIC 
#define SYMESZ  18
#endif
#ifdef i386
#define COFF_MAGIC I386MAGIC
#define SYMESZ  18
#endif
#ifdef ns32k
#define COFF_MAGIC NS32GMAGIC
#define SYMESZ  20
#endif
#ifdef sparc   /* yes, system V really has been ported to sparc! */
#define COFF_MAGIC SPARCMAGIC
#define SYMESZ  20
#endif
#define  SYMNMLEN       8
#define  FILNMLEN       14

/* For 4.0, should probably change this, if cross debugging wanted for 386i */
#ifdef sun386
#include <sys/exec.h>
#else
struct exec
{
  short a_magic;
  short vstamp;
  unsigned a_text;		/* length of text, in bytes */
  unsigned a_data;		/* length of data, in bytes */
  unsigned a_bss;		/* length of uninitialized data area for file,
				   in bytes */
  unsigned a_entry;		/* start address */
  long text_start,
  data_start;
};
#endif

#define __GNU_EXEC_MACROS__
#define __STRUCT_EXEC_OVERRIDE__  /* force our defn of exec using this macro */

#include "a.out.gnu.h"

#ifdef SYMENT_HAS_EXPLICIT_DESC

#undef N_ABS
#include "syms.h"
#undef N_ABS
#define N_ABS 2

#undef n_zeroes

#else /* not SYMENT_HAS_EXPLICIT_DESC */

union n_name
{
  struct {
    long _n_offset;
  } _n_n;
};

struct syment {
  unsigned char n_name[2];
  unsigned short n_dbx_desc;
  union n_name _n;
  unsigned long n_value;
  short n_scnum;
  unsigned short n_type;
  char n_sclass;
  char n_numaux;
};

#define N_DEBUG (-2)

#endif /* not SYMENT_HAS_EXPLICIT_DESC */

#define n_zeroes _n._n_name[0]

#include "filehdr.h"
#include "aouthdr.h"
#include "scnhdr.h"
#include "storclass.h"

#undef N_MAGIC
#undef N_SET_MAGIC

#define N_MAGIC(exec) ((exec).a_magic)
#define N_SET_MAGIC(exec, val) ((exec).a_magic = (val))

struct obstack * current_extra_strings_obstack;

#endif /* __COFF_DBX_H__ */
