/* Convert BSD format object file to COFF-format.

   Useful for converting libraries that wre previously created with binutils
   ( before gas could generate COFF) to COFF, so you don't need to recompile
   them, in order to use them wirth the native loader.

   Copyright (C) 1990 Free Software Foundation, Inc.

This file is part of GAS, the GNU Assembler.

GAS is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 1, or (at your option)
any later version.

GAS is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GAS; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */


#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>

extern int fstat();
extern int convert_to_coff();
extern char *xmalloc();

int 
file_size(fd)
     int fd;
{
  struct stat buf;
  
  if (fstat(fd,&buf) <0)
    return -1;
  else 
    return buf.st_size;
}

main(argc,argv)
     int argc;
     char ** argv;
{
  char *aout_file_buf;
  long int aout_file_size;
  int fd;
  char * infilename;
  char * outfilename;

  if (argc != 3 )
    {
      printf ("usage: %s bsdfile cofffile", argv[0]);
      exit(1);
    }

  infilename = argv[1];
  outfilename = argv[2];

  if ((fd = open(infilename,O_RDONLY)) <0)
    as_fatal ("cannot open %s for reading", infilename);

  if ((aout_file_size = file_size(fd)) <0)
    as_fatal ("cannot get size of %s", infilename);

  aout_file_buf = xmalloc (aout_file_size);

  if ( aout_file_buf == 0)
    as_fatal ("can't allocate buffer to read %s", infilename);

  if ( read(fd, aout_file_buf, aout_file_size ) != aout_file_size )
    as_fatal ("error reading input file %s", infilename);

  convert_to_coff( &aout_file_buf, &aout_file_size );
  {
    int fd = open(outfilename,O_WRONLY|O_CREAT,0666);
    if (fd <0)
      as_fatal("cannot open output file %s", outfilename);
    else
      {
	write(fd,aout_file_buf,aout_file_size);
	close(fd);
      }
  }
  exit(0);
}
