/* Output a loader directive file to be used for merging constructor
   and destructor coff sections. 

This file is part of GNU CC.

GNU CC is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY.  No author or distributor
accepts responsibility to anyone for the consequences of using it
or for whether it serves any particular purpose or works at all,
unless he says so in writing.  Refer to the GNU CC General Public
License for full details.

Everyone is granted permission to copy, modify and redistribute
GNU CC, but only under the conditions described in the
GNU CC General Public License.   A copy of this license is
supposed to have been given to you along with GNU CC so you
can know your rights and responsibilities.  It should be in a
file named COPYING.  Among other things, the copyright notice
and this notice must be preserved on all copies.  */

/* This file attempts to generate a loader directive file for use
   with ld when called from g++ on your system.  On System V Systems, 
   the data segment must be bound to an address in a region whose 
   starting address is in a different hardware segment than the last
   hardware segment containing text.  On many (most?) System V systems,
   the value to use for this is defined as NBPS in <sys/param.h>. Some
   System V systems apparently do not have this definition, however.
   For these systems, we guess at a 0x400000 size boundary.  This happens
   to be correct for at least one Sysem V/386 system.  I am curious
   to hear of any changes needed that might be needed for other systems. 

   Michael Bloom
   - mb@ttidca.tti.com		
*/


#include <sys/param.h>

#define TEXT_OFFSET 0x200
#define TEXT_START 0x400000
#define TEXT_ADDRESS (TEXT_START+TEXT_OFFSET)

#ifdef NBPS
#define SEGSIZE NBPS
#else
#define SEGSIZE 0x400000	/* overkill, but should work. */
#endif
main()
{
  printf("\n\
/*\n\
 *\tBLOCK to an offset that leaves room for many headers ( the value\n\
 *\there allows for a file header, an outheader, and up to 11 section \n\
 *\theaders on most systems.\n\
 *\tBIND to an address that excludes page 0 from being mapped. The value\n\
 *\tused for BLOCK should be or'd into this value. Here I'm setting BLOCK\n\
 *\tto 0x200 and BIND to ( 0x400000 | value_used_for(BLOCK) )\n\
 *\tIf you are using shared libraries, watch that you don't overlap the\n\
 *\taddress ranges assigned for shared libs.\n\
 *\n\
 *\tGROUP BIND to a location in the next segment.  Here, the only value\n\
 *\tthat you should change (I think) is that within NEXT, which I've set\n\
 *\tto my hardware segment size. You can always use a larger size, but not\n\
 *\ta smaller one.\n\
 *\t\n\
 *\tNote the items marked \"placeholder for count\". These will be filled in\n\
 *\twithin gnulib3.\n\
 */");

  printf("\n\
SECTIONS\n\
{\n\
	.text BIND(0x%x) BLOCK (0x%x) :\n\
	{\n\
		 /* plenty for room for headers */\n\
		*(.init)\n\
		*(.text)\n\
		vfork = fork; /* I got tired of editing peoples sloppy code */\n\
		*(.fini)\n\
	}\n\
	GROUP BIND( NEXT(0x%x) + ADDR(.text) + SIZEOF(.text)):",
	  TEXT_ADDRESS, TEXT_OFFSET, SEGSIZE);
  printf("\n\
	{\n\
			.data : {\n\
				__CTOR_LIST__ = . ; \n\
				. += 4; 	/* placeholder for count*/\n\
				*(.ctor) \n\
				__CTOR_LEN__ = (. - (__CTOR_LIST__ + 4 )) / 4 ;\n\
				. += 4 ;	/* trailing NULL */\n\
				__DTOR_LIST__ = . ;\n\
				. += 4; 	/* placeholder for count*/\n\
				*(.dtor) \n\
				__DTOR_LEN__ = ( . - (__DTOR_LIST__ + 4 ) )/4 ;\n\
				. += 4 ; 	/* trailing NULL */\n\
			 }\n\
			.bss : { }\n\
	}\n\
}\n");

  exit(0);
}
