/*
 * strchr, strrch : string searching routines.
 * (and non-ANSI variants strpos, strrpos)
 *
 * Notes:  A naive implementation.  Should use the 960
 *         "scanbyte" instruction and be inlined for benchmarking.
 *
 * Andy Wilson, 3-Oct-89.
 */

char *
  strchr(s, c)
const char *s;
int c;
{
  do
    {
      if (*s==c)	/* note that 0 is a valid char to search for */
	return s;
    }
  while (*s++ != '\0');

  return (char *)0;
}

char *
  strrchr(s, c)
const char *s;
int c;
{
  char *lastc=(char *)0;

  /*
   * are we searching for a null?  if so,
   * this routine is the same as strchr.
   */
  if (c=='\0')
    return strchr(s, c);

  /*
   * If not, walk the string until we find a null,
   * returning a pointer to the last char to match 'c'.
   */
  while (*s != '\0')
    {
      if (*s == c)
	lastc = s;
      s++;
    }
  return lastc;
}

int
  strpos(s, c)
const char *s;
char c;
{
  char *p;

  p = strchr(s, c);
  if (p)
    return (p-s);
  else
    return -1;
}

int
  strrpos(s, c)
const char *s;
char c;
{
  char *p;

  p = strrchr(s, c);
  if (p)
    return (p-s);
  else
    return -1;
}

      
