/*				s t d i o
 *
 * This provides a stream IO buffering scheme which is provides
 * higher level IO functions over the lower level functions.
 * A file associated with buffering is called a stream and is
 * declared to be a pointer to the type FILE.
 *
 * Normally there are three open streams with pointers declared
 * in <stdio.h>:
 *
 *	stdin	standard input file
 *	stdout	standard output file
 *	stderr	standard error file
 *
 * The constant NULL designates the non-existent pointer. The constant
 * EOF is returned on eof and by many functions to designate an
 * error condition.
 *
 * Any module which uses this package must include the header file
 * at the beginning of the module:
 *
 *	#include <stdio.h>
 *
 * The following functions are implemented as macros:
 *
 *	getc
 *	getchar
 *	putc
 *	putchar
 *	feof
 *	ferror
 *	fileno
 *	clearerr
 *
 * This file contains basic data structure declarations for the stdio
 * package. Runtime cleanup is done by _ioflush.
 *
 * Patchlevel 1.1
 *
 * Edit History:
 * 03-Nov-1989  Add _stdio_init which dynamically resets
 *              the data structures (called at startup time). [atw]
 * 17-Oct-1989  Instantiate routines (such as getc) now
 *              defined as inline routines in <stdio.h>  [atw]
 * 27-Sep-1989  Make std(in,out,err) non-buffered. [atw]
 * 05-Sep-1989	Add _wrapstdio for cleaner system interface via
 *		atexit().
 */


#define _INSTANTIATE_STDIO_
#include "stdiolib.h"

static struct _iobuf _stdin  = {NULL, NULL, NULL, 0, _IOREAD|_IOLBF,  0, 0};
static struct _iobuf _stdout = {NULL, NULL, NULL, 0, _IOWRITE|_IONBF, 1, 0};
static struct _iobuf _stderr = {NULL, NULL, NULL, 0, _IOWRITE|_IONBF, 2, 0};

struct _iobuf *_iop[_NFILE] = {&_stdin, &_stdout, &_stderr};

void
  _stdio_init()
{
  int i;

  /*
   * Initialize the usual 3 channels
   * (ain't GNU C wonderful??)
   */
  _stdin  = ((struct _iobuf){NULL, NULL, NULL, 0, _IOREAD|_IOLBF,  0, 0});
  _stdout = ((struct _iobuf){NULL, NULL, NULL, 0, _IOWRITE|_IONBF, 1, 0});
  _stderr = ((struct _iobuf){NULL, NULL, NULL, 0, _IOWRITE|_IONBF, 2, 0});

  _iop[0] = &_stdin;
  _iop[1] = &_stdout;
  _iop[2] = &_stderr;

  /*
   * set the rest to null
   */
  for (i=3; i<_NFILE; i++)
    _iop[i] = (struct _iobuf *)0;

}

