#include "lib.h"
#include <string.h>

/*
 * memset() and bzero()
 *
 * [atw] written in a (moderately) efficient fashion using word
 * moves where possible.
 * If sufficiently motivated, could be rewritten for the 960 to
 * use long or quad-word instructions.
 */
VOIDSTAR
memset(b, val, n)
VOIDSTAR b;
int val;
SIZET n;
{
    long l, head;
    unsigned long aword;
    VOIDSTAR p;
    
    p = b;
    if(head = ((long)b) & 0x3) /* [atw] check for unaligned pointer */
    {
      n -= head;
      while(head--)
	*(char *)b++ = (char)val;
    }

    l = (n >> 2); /* # of longs */
    n &= 0x3;     /* n == # of residual bytes */

    /*
     * construct a word of the desired value.
     */
    
    aword = (unsigned char)val;
    aword |= (aword<<8);
    aword |= (aword<<16);
    while(l--)
	*((long *)b)++ = aword;
    while(n--)
	*(char *)b++ = (char)val;

    return p;
}

void
bzero(ptr, len)
char *ptr;
int len;
{
  (void) memset(ptr, 0, len);
}
