/*
 * memcpy(), memmove(), bcopy() : memory copying routines.
 *                                memmove() is guaranteed to work correctly
 *                                even if source and dest overlap.
 *
 * [atw] 18-Sep-89.
 */

#include "lib.h"
#include <string.h>

typedef struct {
  long x[4]; } QWORD;
typedef struct {
  long x[2]; } DWORD;

void *
  memmove(dest, src, len)
void *dest;
const void *src;
size_t len;
{
  const void *lasts;
  void *lastd;
  void *retval;
  
  /*
   * check for overlap; if not, use the
   * (presumably faster) memcpy routine.
   */
  lasts = src + (len-1);
  lastd = dest + (len-1);
  if (((dest < src) || (dest > lasts)) &&
      ((lastd < src) || (lastd > lasts)))
    return memcpy(dest, src, len);
  
  /*
   * no joy; copy the strings byte-by-byte
   * in the appropriate order (increasing byte
   * addresses if dest<src, decreasing if dest>src).
   */
  
  retval = dest;
  if (dest < src)
    while (len--)
      *(char *)dest++ = *(char *)src++;
  else
    while (len--)
      *(char *)lastd-- = *(char *)lasts--;
  
  return retval;
}

void *
  memcpy(dest, src, len)
void *dest;
const void *src;
size_t len;
{
  void *retval=dest;

  /*
   * try quad word moves if possible
   */
  if ((((long)dest | (long)src) & 0xF)==0)
    {
      while ( len >= sizeof(QWORD))
	{
	  *(QWORD *)dest = *(QWORD *)src;
	  dest += sizeof(QWORD);
	  src += sizeof(QWORD);
	  len -= sizeof(QWORD);
	}
    }
  /*
   * ... now long word moves ...
   */
  if ((((long)dest | (long)src) & 0x7)==0)
    {
      while ( len >= sizeof(DWORD))
	{
	  *(DWORD *)dest = *(DWORD *)src;
	  dest += sizeof(DWORD);
	  src += sizeof(DWORD);
	  len -= sizeof(DWORD);
	}
    }
  /*
   * ... single word moves ...
   */
  if ((((long)dest | (long)src) & 0x3)==0)
    {
      while ( len >= sizeof(long))
	{
	  *(long *)dest = *(long *)src;
	  dest += sizeof(long);
	  src += sizeof(long);
	  len -= sizeof(long);
	}
    }
  /*
   * ... short word moves ...
   */
  if ((((long)dest | (long)src) & 0x1)==0)
    {
      while ( len >= sizeof(short))
	{
	  *(short *)dest = *(short *)src;
	  dest += sizeof(short);
	  src += sizeof(short);
	  len -= sizeof(short);
	}
    }
  /*
   * finish up with byte moves.
   */
  while (len--)
    *(char *)dest++ = *(char *)src++;
  return retval;
}

/*
 * bcopy : Berkleyism.
 * like memcpy with operands reversed.
 */
char *
bcopy(src, dest, len)
char *src, *dest;
int len;
{
  return (char *)memcpy(dest, src, len);
}
