/*				f t e l l
 *
 * Report the position within a stream. The function returns
 * the offset of the current byte relative to the beginning
 * of the file associated with the named stream.
 *
 * Patchlevel 1.0
 *
 * Edit History:
 */

#include "stdiolib.h"

/*LINTLIBRARY*/

long ftell(fp)

FILE *fp;				/* stream */

{
  long pos;				/* current location */
  long tell();				/* location within file */

  if ((pos = tell(fp->_file)) == -1L || TESTFLAG(fp, _IONBF))
    {
      errno = EIO;
      return pos;
    }

  if (TESTFLAG(fp, _IOWRITE))
    return pos + (fp->_ptr - fp->_base);
  else
    return pos - (fp->_end - fp->_ptr);
}

/*
 * fgetpos : ANSI equivalent of ftell
 */

int
  fgetpos(FILE *stream, fpos_t *pos)
{
  long p;

  p = ftell(stream);
  if (p == -1)
    {
      return p;
    }
  else
    {
      *pos = p;
      return 0;
    }
}
