/*				f f l u s h
 *
 * Flush a stream. The contents of the buffer are written to the
 * file if the stream was opened for writing. The buffer pointers
 * are reset to indicate an empty buffer.
 *
 * The function returns zero on success and EOF on failure.
 *
 * Patchlevel 1.0
 *
 * Edit History:
 * 03-Sep-1989	Flush input buffer only if it exists.
 */

#include "stdiolib.h"

/*LINTLIBRARY*/

int fflush(fp)

FILE *fp;				/* stream */

{
  int length;				/* amount to flush */
  int write();				/* write to channel */

  if (TESTFLAG(fp, _IOERR))
    return EOF;

  if (! TESTFLAG(fp, _IOWRITE)) {
    if (HASBUFFER(fp))
      INITREADBUFFER(fp, 0);
  }
  else {
    if (! TESTFLAG(fp, _IONBF) &&
        (length = fp->_ptr - fp->_base) != 0 &&
        write(fp->_file, (char *) fp->_base, length) != length)
      return EOF;
    if (HASBUFFER(fp))
      INITWRITEBUFFER(fp);
  }

  return 0;
}
