/*				a t e x i t
 *
 * Lodge an exit handler. The handler is lodged within a list of exit
 * handlers to be called by exit prior to calling _exit. The list
 * is of finite length. exit will call the exits handlers in fifo
 * order. The routine returns zero on failure (list overflow) and
 * non-zero on success.
 *
 * Patchlevel 1.1
 *
 * Edit History:
 * 07-Nov-1989  [atw] Convert to based storage of exit handler
 *              a la DTO.
 * 01-Nov-1989  [atw] Original coding returns the reverse of
 *              ANSI standard (0 for success, 1 for failure).
 * 06-Sep-1989	Added lint control.
 * 05-Sep-1989	Created.
 */

#include "stdiolib.h"

/*LINTLIBRARY*/

int atexit(fp)

#ifdef __STDC__
void (*fp)(void);				/* exit handler */
#else
void (*fp)();					/* exit handler */
#endif
{
  struct _exit *ep;

  ep = _exit_ptr();
  if (ep->exit_handler_count > _EXIT_HANDLER_MAX)
    return 1;
  ep->exit_handler_list[ep->exit_handler_count++] = fp;
  return 0;
}
