/*			_ f o p e n m o d e
 *
 * This function scans the mode with which a channel should be
 * opened. It then opens the channel using that mode and returns
 * the channel number to the caller. On error, the value -1 will
 * be returned.
 *
 * If the function succeeds, the flags argument will be set to the
 * mode with which the channel was opened. If the fd argument is
 * -1, the channel will be allocated, otherwise the specified channel
 * will be used.
 *
 * Patchlevel 1.1
 *
 * Edit History:
 * 05-Sep-1989	Change SETCLEANUP to SETIOFLUSH.
 */


#include "fcntl.h"
#include "stdiolib.h"

/*LINTLIBRARY*/

#define CREATMODE 0666			/* mode to creat file */

int _fopen(name, mode, fd, flags)

CONST char *name;				/* name of file */
CONST char *mode;				/* mode to open */
int        fd;					/* allocated channel */
short      *flags;				/* stdio flags */

{
  int rw;				/* basic mode */
  int update;				/* read and write required */
#ifndef __STDC__ /* use protos (from std.h) instead */
  int close();				/* close a file */
  int creat();				/* create a file */
  int open();				/* open a file */
  long lseek();				/* seek to position */
#endif

  rw     = *mode++;
  update = *mode == '+';

  switch (rw) {

  case 'w':
    *flags = update ? _IORW : _IOWRITE;
    if (fd == -1) {
      fd = creat(name, CREATMODE);
      if (update && fd != -1 && (fd = close(fd)) != -1)
        fd = open(name, O_RDWR);
    }
    break;

  case 'r':
    *flags = update ? _IORW : _IOREAD;
    if (fd == -1)
      fd = open(name, update ? O_RDWR : O_RDONLY);
    break;

  case 'a':
    *flags = update ? _IORW : _IOWRITE;
    if (fd == -1) {
      fd = open(name, update ? O_RDWR : O_WRONLY);
      if (fd == -1 && errno == ENOENT) {
        fd = creat(name, CREATMODE);
	if (update && fd != -1 && (fd = close(fd)) != -1)
	  fd = open(name, O_RDWR);
      }
    }
    if (fd != -1 && lseek(fd, 0L, SEEK_END) != -1)
      break;

  default:
    fd = -1;
  }

  return fd;
}
