/******************************************************************/
/* 		Copyright (c) 1989, Intel Corporation

   Intel hereby grants you permission to copy, modify, and 
   distribute this software and its documentation.  Intel grants
   this permission provided that the above copyright notice 
   appears in all copies and that both the copyright notice and
   this permission notice appear in supporting documentation.  In
   addition, Intel grants this permission provided that you
   prominently mark as not part of the original any modifications
   made to this software or documentation, and that the name of 
   Intel Corporation not be used in advertising or publicity 
   pertaining to distribution of the software or the documentation 
   without specific, written prior permission.  

   Intel Corporation does not warrant, guarantee or make any 
   representations regarding the use of, or the results of the use
   of, the software and documentation in terms of correctness, 
   accuracy, reliability, currentness, or otherwise; and you rely
   on the software, documentation and results solely at your own 
   risk.							  */
/******************************************************************/
	.text
	.globl start
	.globl __exit

start:
	mov	1, r12
	modpc	r12, r12, r12	/* enable tracing */
	mov	g5, g5

/* set up stack pointer:
 *	The heap will begin at '_end';  its length is 'heap_size'
 *	bytes.  The stack will begin at the first 64-byte-aligned
 *	block after the heap.
 *
 *	A default value of 'heap_size' is set by linking with libnindy.a
 *	The default can be overridden in one of 2 ways:
 *
 *	    o Including a line of the form 'heap_size=XXXX;' in your
 *		linker specification (if using lnk960).   You'll get
 *		a linker warning that you're redefining the symbol.
 *
 *	    o Linking an assembler file containing the lines:
 *			.globl	heap_size
 *			.set	heap_size,XXXX
 */

	ldconst	_end, sp	 /* set sp = address of end of heap */
	ldconst	heap_size, r12
	addi	r12, sp, sp
	ldconst	64, r12		 /* Now round up to 64-byte boundary */
	addi	r12, sp, sp	
	ldconst	0xffffffc0, r12	
	and	r12, sp, sp	
	st	sp, _stack_start /* Save for brk() routine */

	call	init_frames
	ret			 /* return to monitor */

init_frames:
	mov	0, g14		 /* initialize constant for C */
	ldconst	0x3b001000, g0
	ldconst	0x00009107, g1
	modac	g1, g0, g0	 /* set AC controls */

/*
 * zero out uninitialized data area
 */
zerobss:
	lda 	_end, r4	/* find end of .bss */
#ifdef GNU
	lda 	_edata, r5	/* find beginning of .bss */
#else
	lda 	_bss_start, r5	/* find beginning of .bss */
#endif
	ldconst 0, r6		

loop:	st	r6, (r5)	/* to zero out uninitialized */
	addo	4, r5, r5	/* data area                 */
	cmpible r5, r4, loop	/* loop until _end reached   */

/*
 * insert "C" startup code if necessary.
 */
	callx _init_c

/*
 * remember the frame, so that we can set it up if necessary
 */
	st	fp, _start_frame
	
	callx 	_main

/* 
 * if we return from main, we have "fallen" off the end
 * of the program, therefore status is 0
 * so move 0 to g0 (exit parameter)
 */
	mov	0, g0
	callx	_exit

return_to_nindy:
	ret			/* _exit() will return to this point */

__exit:
	fmark
	syncf		 /* added for the CA faulting but nop for Kx */
	.word 0xfeedface /* magic word for break, defined in NINDY   */

/*
 * at this point, the fault handler will set the address
 * to this statement and return execution here.  We now
 * need to return to before main was called.  Since we
 * could potentially be here as a resulted of being called 
 * from main(), we must manually fix up the stack
 */
	flushreg
	ld	_start_frame, pfp
	
/*
 * now we need to magically fix up the stack return
 * addresses so that on return from exit, we always go to the
 * "return_to_nindy" label above, regardless of where we were 
 * called from.
 */
	lda	return_to_nindy, r4	
	st	r4, 8(pfp)	/* store return address to frame */
	ret		
	
	.data
	.globl	_start_frame
	.globl	_stack_start
_start_frame:	.word	0	/* addr of first user frame: for gdb960 */
_stack_start:	.word	0	/* addr of first (lowest) byte of stack */
