/******************************************************************/
/* 		Copyright (c) 1989, Intel Corporation

   Intel hereby grants you permission to copy, modify, and 
   distribute this software and its documentation.  Intel grants
   this permission provided that the above copyright notice 
   appears in all copies and that both the copyright notice and
   this permission notice appear in supporting documentation.  In
   addition, Intel grants this permission provided that you
   prominently mark as not part of the original any modifications
   made to this software or documentation, and that the name of 
   Intel Corporation not be used in advertising or publicity 
   pertaining to distribution of the software or the documentation 
   without specific, written prior permission.  

   Intel Corporation does not warrant, guarantee or make any 
   representations regarding the use of, or the results of the use
   of, the software and documentation in terms of correctness, 
   accuracy, reliability, currentness, or otherwise; and you rely
   on the software, documentation and results solely at your own 
   risk.							  */
/******************************************************************/

/*****************************************************************************
 * Structures and defines for shared memory I/O on NINDY.
 * Used by NINDY monitor and NINDY library (80960) code.
 *****************************************************************************/

/* the following four are hardware dependent */
#define	BIT_16		short
#define	BIT_32		int
#define	UBIT_16		unsigned short
#define	UBIT_32		unsigned int

/* the following four are addresses for locations of buffers */
#define	BUFF_1		0x1100
#define	BUFF_2		0x1400
#define	CMD_BUFF	0x1300
#define BLOCK_SEMI	0x1600

#define EXIST		00
#define WRITE		02
#define READ		04
#define R/W		06

#define S_IWRITE	0x200
#define S_IREAD		0x400
#define S_IFDIR		0x4000
#define S_IFREG		0x10000
#define O_RDONLY	0x0
#define O_WRONLY	0x1
#define O_RDWR		0x2
#define O_APPEND	0x8
#define O_CREAT		0x100
#define O_TRUNC		0x200
#define O_EXCL		0x400
#define O_TEXT		0x4000
#define O_BINARY	0x8000

#define BS_ACCESS	0x10
#define BS_CLOSE	0x20
#define BS_CREAT	0x30
#define BS_LSEEK	0x40
#define BS_OPEN		0x50
#define BS_READ		0x60
#define BS_STAT		0x70
#define BS_SYSTEMD	0x80
#define BS_TIME		0x90
#define BS_UNMASK	0xa0
#define BS_UNLINK	0xb0
#define BS_WRITE	0xc0

struct st {
	BIT_16	st_dev;
	UBIT_16	st_ino;
	UBIT_16 st_mode;
	BIT_16  st_nlink;
	UBIT_16 st_uid;
	UBIT_16 st_gid;
	BIT_16	st_rdev;
	BIT_32	st_size;
	BIT_32	st_atime;
	BIT_32	st_mtime;
	BIT_32	st_ctime;
};

struct access {
	unsigned char path[80];
};

struct close {
	BIT_16 fd;
};

struct creat {
	unsigned char path[80];
	BIT_16 mode;
};

struct lseek {
	BIT_16 fd;
	BIT_32 offset;
	BIT_16 whence;
};

struct open {
	unsigned char path[80];
	UBIT_16	flag;
	BIT_16 mode;
};

struct read {
	BIT_16 fd;
	BIT_16 buffnum;
	UBIT_16 bytes;
};

struct stat {
	unsigned char path[80];
};

struct systemd {
	unsigned char string[128];
};

struct unmask {
	UBIT_16 mode;
};

struct unlink {
	unsigned char path[80];
};

struct write {
	BIT_16 fd;
	BIT_16 buffnum;
	UBIT_16 bytes;
};

