;;; trysmg2.scm

;;; This code is ugly and poorly written, but should give you some
;;; idea how to use these routines.

(define reverse_bits 2)		;SMG$M_REVERSE
(define SMG$K_BOTTOM 1)
(define SMG$M_BORDER 1)


(define input-device #f)
(define pbd (vector-ref (smg$create_pasteboard input-device) 1))
(define kbd (vector-ref (smg$create_virtual_keyboard input-device) 1))
(define display-id (vector-ref
		    (smg$create_virtual_display 22 78 SMG$M_BORDER) 1))


(define (beginning-screen)
  (smg$label_border display-id " Stuff " SMG$K_BOTTOM #f reverse_bits)
  (smg$put_chars display-id "Hello!" 1 1 #f reverse_bits)
  (smg$put_chars display-id "Hello!" 22 1)
  (smg$put_chars display-id "Hello!" 1 73 #f #f reverse_bits)
  (smg$put_chars display-id "Hello!" 22 73)
  (smg$put_chars display-id ">" 10 37))

;; Define the SMG termcodes for the keys we'll use.
(define CTRL_Z 26)
(define UP 274)
(define DOWN 275)
(define LEFT 276)
(define RIGHT 277)
(define TAB 9)
(define BS 8)
(define DO_KEY 296)
(define INSERT 312)
(define REPAINT 18)
(define F19 299)
(define F20 300)

(define row 1)
(define col 1)

(define (set-pos r c)
  (set! row (if (> r 22)
		(- r 22)
		(if (< r 1)
		    (+ r 22)
		    r)))
  (set! col (if (> c 78)
		(- c 78)
		(if (< c 1)
		    (+ c 78)
		    c)))
  (smg$set_cursor_abs display-id row col))

(define (reset-pos)
  (smg$set_cursor_abs display-id row col))

(define (main)
  (smg$paste_virtual_display display-id pbd 2 2)
  (beginning-screen)
  (smg$begin_display_update display-id)
  (smg$put_chars display-id "[Down]" 22 37)
  (smg$put_chars display-id "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx" 21 1)
  (smg$put_chars display-id "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx" 2 1)
  (smg$put_chars display-id "[Up]" 1 37)
  (smg$end_display_update display-id)
  (cond (#f
	 (set-pos 10 35)
	 (display (smg$change_pbd_characteristics pbd))
	 (set-pos 15 1)
	 (smg$change_virtual_display display-id 16 20)))
  (cond (#t
	 (display " (should be no) ")
	 (display (smg$check_for_occlusion display-id pbd))
	 (smg$read_keystroke kbd)
	 (let ((nd (vector-ref
		    (smg$create_virtual_display 10 20 SMG$M_BORDER) 1)))
	   (smg$paste_virtual_display nd pbd 8 20)
	   (smg$put_chars nd "Hello!" 3 3)
	   (smg$label_border nd " Over " #f #f reverse_bits)
	   (display " (should be yes) ")
	   (display (smg$check_for_occlusion display-id pbd))
	   (display " (should be no) ")
	   (display (smg$check_for_occlusion nd pbd))
	   (smg$read_keystroke kbd))))
  ;;
  (do ((key (vector-ref (smg$read_keystroke kbd) 1)
	    (vector-ref (smg$read_keystroke kbd) 1)))
      ((or (not (number? key))
	   (= key CTRL_Z)))
    (action key))
  (smg$set_physical_cursor pbd 22 1)
  (smg$delete_pasteboard pbd #f)
  (smg$delete_virtual_display display-id)
  (smg$delete_virtual_keyboard kbd))

(define (action key)
  (cond
   ((= key UP)
    (set-pos (- row 1) col))
   ((= key DOWN)
    (set-pos (+ row 1) col))
   ((= key LEFT)
    (set-pos row (- col 1)))
   ((= key RIGHT)
    (set-pos row (+ col 1)))
   ((= key TAB)
    (set-pos row (+ col 8)))
   ((= key BS) 
    (set-pos row (- col 8)))
   ((= key DO_KEY)
    (let ((pos (smg$return_cursor_pos display-id)))
;    (put-chars display-id (pair-string row col 3) 12 41)
      (smg$put_chars display-id (pair-string (vector-ref pos 1)
					 (vector-ref pos 2) 3) 12 41))
    (reset-pos))
   ((= key INSERT)
    (smg$put_chars display-id "*" row col)
    (reset-pos))
   ((= key REPAINT)
    (smg$repaint_screen pbd))
   ((= key F20)
    (box)
    (reset-pos))
   ((= key F19)
    (cond (rend-toggle
	   (smg$change_rendition display-id
				 12 41 1 10 on-bits-set on-bits-comp)
	   (set! rend-toggle #f))
	  (else
	   (smg$change_rendition display-id
				 12 41 1 10 off-bits-set off-bits-comp)
	   (set! rend-toggle #t))))
   (else
    (smg$ring_bell display-id 1))))

(define rend-toggle #t)
(define on-bits-set 2)		;bit 1 is SMG$M_REVERSE
(define on-bits-comp 0)
(define off-bits-set 2)
(define off-bits-comp 2)

(define (pair-string x y width)
  (let ((xs (pad (number->string x) width "0"))
	(ys (pad (number->string y) width "0")))
    (string-append "(" xs "," ys ")")))

(define (pad s w padding)
  (do ((s s (string-append padding s)))
      ((>= (string-length s) w)
       s)))

(define (the-end)
  (smg$delete_virtual_display display-id)
  (smg$delete_virtual_keyboard kbd)
  (smg$delete_pasteboard pbd 1))

(define (box)
  (define display-id (vector-ref (smg$create_virtual_display 5 10 1) 1))
  (smg$paste_virtual_display display-id pbd row col)
  (smg$put_chars display-id "Golly!" 1 1)
  (smg$put_chars display-id "A Box!" 3 1)
  (smg$read_keystroke kbd)
  (write (smg$get_display_attr display-id))
  (smg$read_keystroke kbd)
  (smg$delete_virtual_display display-id))


(main)
