/* scmint.c -- SCM Interface; support routines. */

#include "scmint.h"

char scmint_version[] = "0.1";


/* Determine whether an SCM object is of the appropriate type.
   Most of these don't have the proper range checks. */
int
si_booleanp (SCM obj)
{
  return (BOOL_F == obj) || (BOOL_T == obj);
}


int
si_stringp (SCM obj)
{
  return NIMP (obj) && STRINGP (obj);
}


int
si_longwordp (SCM obj)
{
  return INUMP (obj) || BIGP (obj); /* ???check to see if in range? */
}

int
si_unsigned_charp (SCM obj)
{
  return INUMP (obj);
}

int
si_doublep (SCM obj)
{
  return NUMP (obj);
}

int 
si_floatp (SCM obj)
{
  return NUMP (obj);
}

int
si_unsigned_shortp (SCM obj)
{
  return INUMP (obj);
}


int
si_quadwordp (SCM obj)
{
  return TYP7 (obj) && VECTORP (obj) && (LENGTH (obj) == 2) &&
    si_longwordp (VELTS (obj)[0]) && si_longwordp (VELTS (obj)[1])
    ;
}



/* Convert from an SCM object to the proper VMS type. */

long
si_to_longword (SCM obj)
{
  if (INUMP (obj))
    return INUM (obj);
  else if (BIGP (obj))
    {
      unsigned long num = 0;
      BIGDIG *tmp = BDIGITS(obj);
      sizet nlen = NUMDIGS (obj);
      while (nlen--) num = BIGUP (num) + tmp[nlen];
      if (TYP16 (obj) == tc16_bigpos)
	  return num;
      else
	return -num;
    }
  else
    wta (obj, "not a FIXNUM or a BIGNUM", "internal: si_to_longword");
}


unsigned char
si_to_unsigned_char (SCM obj)
{
  return (unsigned char) INUM (obj);
}


extern long lib$scopy_r_dx
  (unsigned short *, char *, struct dsc$descriptor_s *);

struct dsc$descriptor_s
si_to_string (SCM obj)
{
  long stat;
  unsigned short len;
  char *s;
  struct dsc$descriptor_s str = {0, DSC$K_DTYPE_T, DSC$K_CLASS_D, 0};
#if 0
  str.dsc$w_length = LENGTH (obj);
  str.dsc$a_pointer = CHARS (obj);
#else
  len = LENGTH (obj);
  s = CHARS (obj);
  stat = lib$scopy_r_dx (&len, s, &str);
#endif
  return str;
}


unsigned short
si_to_unsigned_short (SCM obj)
{
  return INUM (obj);
}


struct sit_quadword
si_to_quadword (SCM obj)
{
  struct sit_quadword qw = {0, 0};
  qw.lo = si_to_longword (VELTS (obj)[0]);
  qw.hi = si_to_longword (VELTS (obj)[1]);
  return qw;
}



/* Convert from a VMS type to an SCM object. */


SCM 
si_from_longword (long n)
{
  if (POSFIXABLE (n))
    return MAKINUM (n);
  else if (UNEGFIXABLE (n))
    return MAKINUM (-n);
  else
    return long2big (n);
}


SCM 
si_from_unsigned_char (unsigned char uch)
{
  return MAKINUM (uch);
}


SCM 
si_from_string (struct dsc$descriptor_s str)
{
  SCM s;
  s = makfromstr (str.dsc$a_pointer, str.dsc$w_length);
  return s;
}


SCM
si_from_unsigned_short (unsigned short n)
{
  return MAKINUM (n);
}


SCM si_from_quadword (struct sit_quadword qw)
{
  SCM result;
  SCM *data;
  result = make_vector (MAKINUM (2), UNSPECIFIED);
  data = VELTS (result);
  *data++ = si_from_longword (qw.lo);
  *data++ = si_from_longword (qw.hi);
  return result;
}
