/*	Copyright (C) 1993 Free Software Foundation, Inc.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this software; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */


#include "sysdef.h"
#include "forminfo.h"

char * formula_info[] =
{
   /* Syntax advice */
"*number-syntax*",
"Numbers must be entered in 'general' format:",
"	[-]digits[.digits][e[-]digits]",
0,
"*string-syntax*",
"Strings are entered surrounded by double-quotes.  To include unusual",
"characters, you can either quote them with backslash ",
"(e.g. \"a \\\"quoted\\\" quote\") use \\nnn where nnn is the octal code for",
"the character you want to include. ",
0,
"*expression-syntax*",
"			Infix expressions:",
"",
"- num			0-num",
"! bool			#TRUE if bool is #FALSE",
"			#FALSE if bool is #TRUE, error otherwise.",
"",
"num1 ^ num2		Exponentiation  This is *right* associative!",
"num1 * num2		Multiplication  Note that these functions are not as",
"num1 / num2		Division	good as they should be at detecting",
"int1 % int2		Modulus		overflow.  There *is* code that should",
"",
"num1 + num2		Addition	force integer expressions to become",
"num1 - num2		subtraction	floating-point if the result wouldn't",
"					fit in an integer.",
"num1 >= num2		Arithmatic greater-or-equal",
"num1 > num2		greater-than",
"num1 < num2		less-than",
"num1 <= num2		less-than-or-equal",
"",
"val1 = val2		#TRUE if val1 and val2 can be considered equal.",
"			#FALSE otherwise",
"val1 != val2		Equivelent to !(val1=val2)",
"",
"str1 & str2		Text concatination.",
"",
"bool ? val1 : val2	if(bool==#TRUE)",
"				evaluate val1",
"			else if(bool!=#FALSE)",
"				error...",
"			else",
"				evaluate val2.",
"",
"(val)			(To override default precedence) Note that since oleo",
"			stores expressions in a byte-compiled form, excess",
"			parens will mysteriously vanish.",
0,


	/* Error values. */

"#TRUE",
"The logical TRUE value",
0,
"#FALSE",
"The logical FALSE value",
0,
"#ERROR",
"An unclassified error.",
0,
"#BAD_INPUT",
"Indicates an inappropriate parameter to a formula function.",
0,
"#NON_NUMBER",
"An error value.",
0,
"#NON_STRING",
"An error value.",
0,
"#NON_BOOL",
"An error value.",
0,
"#NON_RANGE",
"An error value.",
0,
"#OUT_OF_RANGE",
"An error value.",
0,
"#NO_VALUES",
"An error value.",
0,
"#DIV_BY_ZERO",
"An error value.",
0,
"#BAD_NAME",
"An error value that indicates an invalid variable name.  ",
"It may be the symptom of an incorrectly written address.",
0,
"#NOT_AVAIL",
"An error value.",
0,
"#PARSE_ERROR",
"An error value.",
0,
"#NEED_OPEN",
"An error value that indicates a missing open parenthesis.",
0,
"#NEED_CLOSE",
"An error value that indicates a missing close parenthesis.",
0,
"#NEED_QUOTE",
"An error value.",
0,
"#UNK_CHAR",
"An error value.",
0,
"#UNK_FUNC",
"An error value.",
0,
"#INF",
"An error value.",
"On some machines this may be indistinguishable from other values.",
0,
"#INFINITY",
"An error value.",
"On some machines this may be indistinguishable from other values.",
0,
"#NAN",
"An error value.",
"On some machines this may be indistinguishable from other values.",
0,
"#NOT_A_NUMBER",
"An error value.",
"On some machines this may be indistinguishable from other values.",
0,
"#NINF",
"An error value.",
"On some machines this may be indistinguishable from other values.",
0,
"#MINUS_INFINITY",
"An error value.",
"On some machines this may be indistinguishable from other values.",
0,



		/* Functions releated to boolean values. */

"if",
"Conditional operator			if(bool,val1,val2)",
"",
"If BOOL is #TRUE, the value is VAL1;",
"if BOOL is #FALSE, the value is VAL2;",
"if BOOL is neither #TRUE or #FALSE, then the value is #NON_BOOL",
0,
"and",
"Boolean operator			and(bool1,bool2)",
"",
"If both BOOL1 and BOOL2 are #TRUE, the value is #TRUE;",
"otherwise, if both are boolean values, the value is #FALSE;",
"otherwise, the value is #NON_BOOL.",
0,
"or",
"Boolean operator			or(bool1,bool2)",
"",
"If both BOOL1 and BOOL2 are booleans, then the value is #TRUE if either",
"argument is #TRUE, and #FALSE if both are #FALSE.",
"If either argument is not a boolean, the value is #NON_BOOL.",
0,
"not",
"Boolean operator			not(bool)",
"",
"#TRUE if BOOL is #FALSE,",
"#FALSE if BOOL is #TRUE, ",
"and otherwise, #NON_BOOL.",
0,
"iserr",
"Error predicate				iserr(val)",
"",
"#TRUE if the VAL is an error, otherwise #FALSE",
0,
"isnum",
"Number predicate			isnum(val)",
"",
"#TRUE if the VAL is a number, or can be automatically converted to a number.",
"Thus `isnum(\"12\")' is #TRUE, while `isnum(\"dsfjbk\") is #FALSE.",
0,


	/* Functions that reflect the structure of the spreadsheet. */
"row",
"A cell's row address			row()",
"",
"The row number of the cell the expression is in.",
0,
"col",
"A cell's column address		col()",
"",
"The column number of the cell the expression is in.",
0,
"rows",
"Rows in a range			rows(rng)",
"",
"The number of rows in RNG.",
0,
"cols",
"Columns in a range			cols(rng)",
"",
"The number of columns in RNG.",
0,
"my",
"Cell reflection				my(str)",
"",
"The function `my' returns information about the cell containing the formula.",
"The argument STR is a key to say what should be returned.  Valid arguments are:",
"",
" KEY		RETURNS",
"",
"row		row address (as an integer)",
"column		column address (as an integer)",
"width		width, (as an integer)",
"lock		\"locked\" or \"unlocked\"",
"protection	(this is a synonym for \"lock\")",
"justify		\"left\", \"right\", \"center\" or \"default\"",
"alignment	(this is a synonym for \"justify\")",
"format		\"default\", \"user-1\", etc.",
"fmt		(this is a synonym for \"format\")",
"type		\"error\", \"boolean\", \"float\",\"integer\", \"null\", \"Unknown\", etc.",
"formula		A string of the cell's current formula.",
"value		The cells current value.",
"anything-else	error--> #BAD_INPUT",
0,
"curcell",
"Reflection on the current cell		curcell(str)",
"",
"Curcell takes the same arguments as `my', but returns information about the ",
"current location of the cell-cursor, instead of the cell containing this",
"formula.",
"",
"Curcell is updated on a timer interrupt.",
0,
"cell",
"General cell reflection			cell(row,col,str)",
"",
"`Cell' takes a ROW and COL address, and a STR that is like an argument to `my'.",
"It returns information about the cell at ROW,COL.",
0,
"member",
"Search for values			member(rng,val)",
"",
"Returns the index of the first cell in RNG that contains VAL, or zero",
"if no cells contain it.  It is permissable for VAL to be an error",
"value.",
0,
"smember",
"Search for a substring			smember(rng,str)",
"",
"Returns the index of the first cell in RNG that contains STR as a substr.",
"Returns 0 if no cells match.  If STR is empty, then it matches an",
"empty cell (see also `members').",
0,
"members",
"Search for a substring			members(rng,str)",
"",
"Returns the index of the first  cell in RNG that contains STR as a substr.",
"Returns 0 if no cells match.  This function will never return the",
"address of an empty cell, but see `smember'.",
0,
"pmember",
"Search for an initial substring		pmember(rng,str)",
"",
"Returns the index of the first cell in RNG whose value equals the",
"first few characters of STR.  If STR is empty, an empty cell may be",
"matched (but see `memberp').",
0,
"memberp",
"Search for an initial substring		memberp(rng,str)",
"",
"Returns the index of the first cell in RNG whose value equals the",
"first few characters of STR.  This function will never return the",
"address of an empty cell, but see `pmember'.",
0,
"hlookup",
"Number-keyed table lookup		hlookup(rng,num,int)",
"",
"Scan through the top row of RANGE looking for a number which is",
"greater than NUM.  Then return the value in the cell that is INT rows",
"down from the top of the range.",
0,
"vlookup",
"Number-Keyed table lookup		vlookup(rng,num,int)",
"",
"Scan through the left col of RANGE looking for a number which is",
"greater than NUM.  Then return the value in the cell that is INT cols",
"over from the left edge of the range.",
0,
"vlookup_str",
"String-keyed table lookup		vlookup_str(rng,str,num)",
"",
"Scan through the left col of RANGE looking for a cell that contains",
"STR.  Then return the value in the cell that is INT columns over from",
"the left edge of the range.",
0,
"now",
"Time of day				now()",
"",
"The current time in seconds since Jan 1 1970.",
0,

"ctime",
"The current time of day			ctime(num)",
"",
"Convert NUM into a readable date/time string.",
"NUM should be seconds since the epoch; as returned by `now()' for example.",
0,
"index",
"Table lookup				index(rng,x), index(rng,relrow,relcol)",
"",
"In the first form, the contents of a cell in RNG, at offset X.  The lookup is",
"in the first column (though it may wrap to other columns).",
"",
"In the second form, the contents of a cell in RNG, RELROW rows and RELCOL",
"columns from the upper left corner of the range.",
0,



	/* General arithmetic*/

"abs",
"Absolute value				abs(num)",
"",
"The absolute value of NUM.",
0,
"int",
"Convesion to integer			int(num)",
"",
"Convert NUM to integer (toward zero).  ",
"See also `floor', and `ceil'.",
0,
"ceil",
"Conversion to integer			ceil(num)",
"",
"Convert NUM to integer (round up).",
"See also `floor', and `int'.",
0,
"floor",
"Conversion to integer			floor(num)",
"",
"Convert NUM to integer (round down)",
"See also `ceil', and `int'.",
0,
"fixed",
"Fixed decimal rounding			fixed(num1,num2)",
"",
"NUM1 rounded to NUM2 decimal places.",
0,
"rnd",
"Random integer				rnd(num)",
"",
"A random integer from 0 to NUM-1.",
0,
"negate",
"Negation				negate(num)",
"",
"Equivelent to `0 - NUM'.",
0,




"exp",
"Exponential				exp(num)",
"",
"The exponential function of NUM.",
0,
"log",
"Log					log(num)",
"",
"The natural log of NUM.",
0,
"log10",
"Log base 10				log10(num)",
"",
"The log of NUM to base 10.",
0,
"sqrt",
"Square root				sqrt(num)",
"",
"The square-root of NUM.",
0,



/* Trig functions */

"pi",
"Constant				pi()",
"",
"3.14159265358979326848",
0,
"acos",
"Arc cosine				acos(num)",
"",
"The arc cosine (in radians) of NUM.",
0,
"asin",
"Arc sine				asin(num)",
"",
"The arc sine (in radians) of NUM.",
0,
"atan",
"Arc tangant				atan(num)",
"",
"The arc tangent (in radians) of NUM.",
0,
"cos",
"Cosine					cos(num)",
"",
"The cosine of NUM (NUM in radians)",
0,
"dtr",
"Degrees to radians			dtr(num)",
"",
"NUM degrees converted to radians.",
0,
"rtd",
"Radians to degrees			rtd(num)",
"",
"NUM radians converted to degrees.",
0,
"sin",
"Sine					sin(num)",
"",
"The sine of NUM (NUM in radians).",
0,
"tan",
"Tangent					tan(num)",
"",
"The tangent of NUM (NUM in radians).",
0,
"atan2",
"Expanded arc tangent			atan2(num1,num2)",
"",
"Returns the arc tangent (in radians) of NUM1 / NUM2.",
"The range of atan2 is (-pi..pi).  The quadrant of the angle returned",
"is determined by the signs of NUM1 and NUM2:",
"",
"	            (pi/2)",
"		       |",
"              NUM2 < 0 |  both > 0",
"		       |",
"   (pi,-pi) -------------------------- (0)",
"              both < 0 |  NUM1 < 0",
"		       |",
"		       |",
"	           -(pi/2)",
0,
"hypot",
"Length of t he hypoteneus		hypot(num1,num2)",
"",
"Returns `sqrt (NUM1 * NUM1 + NUM2 * NUM2)'.  ",
"",
"Calling `hypot' may succeed in cases when the equivelent expression",
"might underflow or overflow.",
0,

"oneof",
"Case expression				oneof(choice,val1,val2,val3...)",
"",
"If CHOICE is 1, return VAL1, if 2, VAL2, and so forth.",
"If CHOICE is not a valid integer in the appropriate range, the value is",
"#OUT_OF_RANGE.  If no value arguments are supplied, the value is #NO_VALUES.",
0,

"sum",
"Sum of values				sum(vr1, vr2, ...)",
"",
"The sum of VR1, VR2, etc.  ",
"",
"Each value can be either a numeric type or a range.  If the value is a range, ",
"the values of all numeric cells in that range are used.",
"",
"If none of the arguments include valid numbers (e.g. `sum(r1:10c1:10)'",
"where that range is empty), then the value is #NO_VALUES.  To ensure",
"that the expression doesn't return an error in cases like that,",
"provide a default value as an extra argument to sum",
"(e.g. `sum(0,r1:10c1:10)').",
0,
"prod",
"Product of values			prod(vr1, vr2, ...)",
"",
"The product of VR1, VR2, etc.  ",
"",
"Each value can be either a numeric type or a range.  If the value is a range, ",
"the values of all numeric cells in that range are used.",
"",
"If none of the arguments include valid numbers (e.g. `prod(r1:10c1)'",
"where that range is empty), then the value is #NO_VALUES.  To ensure",
"that the expression doesn't return an error in cases like that,",
"provide a default value as an extra argument to product (e.g. `prod(1,",
"r1:10c1)').",
0,

"avg",
"Average					avg(vr1...)",
"",
"The average of VR1, VR2, etc.  ",
"",
"Each value can be either a numeric type or a range.  If the value is a range, ",
"the values of all numeric cells in that range are used.",
"",
"If none of the arguments include valid numbers (e.g. `avg(r1:10c1)'",
"where that range is empty), then the value is #NO_VALUES.",
0,
"std",
"Standard deviation			std(vr1...)",
"",
"The SAMPLE standard deviation.  ",
"To get the population standard deviation, use sqrt(var(...))",
"",
"Each value can be either a numeric type or a range.  If the value is a range, ",
"the values of all numeric cells in that range are used.",
"",
"If none of the arguments include valid numbers (e.g. `avg(r1:10c1)'",
"where that range is empty), then the value is #NO_VALUES.",
0,
"max",
"Maximum					max(vr1...)",
"",
"Return the maximum value of all the arguments.",
"",
"Each value can be either a numeric type or a range.  If the value is a range, ",
"the values of all numeric cells in that range are used.",
"",
"If none of the arguments include valid numbers (e.g. `max(r1:10c1)'",
"where that range is empty), then the value is #NO_VALUES.  To ensure",
"that the expression doesn't return an error in cases like that,",
"provide a default value as an extra argument to maximum (e.g. `max(0,",
"r1:10c1)').",
0,
"min",
"Minimum					min(vr1...)",
"",
"Return the minimum value of all the arguments.",
"",
"Each value can be either a numeric type or a range.  If the value is a range, ",
"the values of all numeric cells in that range are used.",
"",
"If none of the arguments  include valid numbers (e.g. `min(r1:10c1)'",
"where that range is empty), then the value is #NO_VALUES.  To ensure that the",
"expression doesn't return an error in cases like that, provide a default value",
"as an extra argument to minimum (e.g. `min(99999, r1:10c1)').",
0,
"cnt",
"Count numbers				cnt(vr1...)",
"",
"The number of numeric values found amongst the arguments.",
"",
"Each value can be either a numeric type or a range.  If the value is a range, ",
"the values of all numeric cells in that range are used.",
0,
"var",
"Population variance			var(vr1...)",
"",
"The population varianc of the arguments.",
"",
"Each value can be either a numeric type or a range.  If the value is a range, ",
"the values of all numeric cells in that range are used.",
"",
"To get the sample variance, use std(...)^2",
0,

  	/* string functions */
"len",
"String length				len(str)",
"",
"The number of characters in STR.",
0,
"strlwr",
"Conversion to lower case		strlwr(str)",
"",
"STR, converted to lower case.",
0,
"strupr",
"Conversion to upper case		strupr(str)",
"",
"STR, converted to upper case.",
0,
"strcap",
"String capitalization			strcap(str)",
"",
"STR, with each word capitalized.",
0,
"trim",
"String beautifier			trim(str)",
"",
"STR, with extra spaces and non-ascii characters removed.",
0,
"find",
"find(str1,str2,int)",
"",
"Return the location after INT where STR2 appears in STR1.",
0,
"substr",
"Extract substring by position		substr(int1,int2,str)",
"",
"Extract the substring from INT1 to INT2 of STR.",
"",
"Positive indexes are counted from the beginning of STR, starting with 1.",
"Negative indexes are counted from the end of STR, starting with -1.",
"See also, `mid'.",
0,
"mid",
"Extract substring by extent		mid(str,int1,int2)",
"",
"The characters in STR from INT1 and continuing for INT2 characters.",
"INT1 is counted from the beginning of the string, starting with 1.",
"See also, `substr'.",
0,
"edit",
"Delete part of a string			edit(str,int1,int2,...)",
"",
"Return STR with chars INT1 through INT2 removed.",
"INT1 and INT2 behave as with `substr'.",
0,
"repeat",
"Construct a repeated string		repeat(str,int)",
"",
"Return INT concatenations of STR; thus repeat(\"foo\",2) returns \"foofoo\".",
0,
"concat",
"Concatenate string 			concat(vr1,...)",
"",
"Return the concatenation of all strings in the arguments.",
"An argument may be a range, in which case the cell values in the range are",
"concatenated.",
0,


	/* busy-ness functions */
"pmt",
"Loan payments			pmt(p,r,t)",
"",
"Payment per period for a loan of principle P at rate R for T payments.",
0,
"pv",
"Present value of investment	pv(pmt,int,term)",
"",
"Present value of an investment that pays $PMT at the end of each of",
"TERM periods with a discount rate (interest) of INT.",
0,
"npv",
"Net present value		npv(rng,rate)",
"",
"Net Present Value of an investment which will pay uneaven payments.",
"The term is calculated from the number of cells in RNG.",
0,
"irr",
"Intrenal rate or return		irr(rng,guess)",
"",
"Internal Rate of Return.  This function is paticularly untested, and",
"should not be trusted.",
"",
"Returns #BAD_INPUT if it does not converge for the given input.",
0,
"fv",
"Future value of an annuity	fv(pmt,int,term)",
"",
"Future Value of an annuity.",
0,
"rate",
"rate(fut,pres,term)",
"",
"Interest rate required to turn $PRES into $FUT in TERM periods.",
"",
0,
"term",
"term(pmt,int,fut)",
"",
"Number of periods required to collect $FUT in payments of $PMT, where",
"depositd payments earn at a rate of INT.",
0,
"cterm",
"cterm(int,fut,pres)",
"",
"Number of periods required to collect $FUT from a single initial",
"deposit of $PRES, at an interest rate of INT.",
"",
0,
"sln",
"sln(cost,scrap,life)",
"",
"Straight line depreciation of an asset that cost",
"$COST when new, can be sold for $SCRAP, and will last for LIFE",
"periods.",
"",
0,
"syd",
"syd(cost,scrap,life,per)",
"",
"Sum-of-the-digits depreciation of an asset that cost $COST, can be",
"sold for $SCRAP and lasts LIFE, in period PER.",
0,
"ddb",
"ddb(cost,scrap,life,per)",
"",
"Double-declining-balance deprecion, otherwise similar to syd().",
0,
"anrate",
"anrate(pmt,pres,term)",
"",
"(undocumented -- documentation from volunteers welcome).",
0,
"anterm",
"anterm(pmt,prin,rate)",
"",
"(undocumented -- documentation from volunteers welcome).",
0,
"balance",
"balance(prin,rate,term,period)",
"",
"(undocumented -- documentation from volunteers welcome).",
0,
"paidint",
"paidint(prin,rate,term,period)",
"",
"(undocumented -- documentation from volunteers welcome).",
0,
"kint",
"kint(prin,rate,term,period)",
"",
"(undocumented -- documentation from volunteers welcome).",
0,
"kprin",
"kprin(prin,rate,term,period)",
"",
"(undocumented -- documentation from volunteers welcome).",
0,
"compbal",
"compbal(print,rate,term)",
"",
"(undocumented -- documentation from volunteers welcome).",
0, 

			     /* Date functions */
"hms_to_time",
"hms_to_time(hours, minutes, seconds)",
"",
"Convert HOURS, MINS, and SECS to a time value (a number of seconds).",
0,
"dhms_to_time",
"dhms_to_time(days, hours, minutes, seconds)",
"",
"Convert DAYS, HOURS, MINS, and SECS to a time value (a number of seconds).",
0,
"time_to_d",
"time_to_d(time)",
"",
"Return the number of days in TIME.  (TIME should be a number of seconds).",
0,
"time_to_h",
"time_to_h(time)",
"",
"Return the number of hours in TIME.  (TIME should be a number of seconds).",
"The return value will be in the range 0..23.",
0,
"time_to_m",
"time_to_m(time)",
"",
"Return the number of minutes in TIME.  (TIME should be a number of seconds).",
"The return value will be in the range 0..59.",
0,
"time_to_s",
"time_to_s(time)",
"",
"Return the number of seconds in TIME.  (TIME should be a number of seconds).",
"The return value will be in the range 0..59.",
0,
"ymd",
"ymd(year, month, day)",
"",
"Convert YEAR, MONTH, and DAY to a time value (a number of seconds).",
"Typicly the return value is the number of seconds since January 1, 1970.",
"The conversion assumes the local time zone.",
0,
"ymd_dst",
"ymd_dst(year, month, day, dst)",
"",
"Convert YEAR, MONTH, DAY and DST to a time value (a number of seconds).",
"Typicly the return value is the number of seconds since January 1, 1970.",
"The conversion assumes the local time zone except that daylight savings",
"time is assumed if dst is positive and stanard time is assumed if DST",
"is 0.  If DST is less than 0, this is the same as ymd(year,month,day).",
0,
"local_year",
"local_year(time)",
"",
"For a time (e.g., returned by now()) return its year in the local timezone.",
0,
"local_month",
"local_month(time)",
"",
"For a time (e.g., returned by now()) return its month in the local timezone.",
0,
"local_date",
"local_date(time)",
"",
"For a time (e.g., returned by now()) return its date in the local timezone.",
0,
"local_hour",
"local_hour(time)",
"",
"For a time (e.g., returned by now()) return its hour in the local timezone.",
0,
"local_min",
"local_min(time)",
"",
"For a time (e.g., returned by now()) return minutes in the local timezone.",
0,
"local_sec",
"local_sec(time)",
"",
"For a time (e.g., returned by now()) return seconds in the local timezone.",
0,
"local_isdst",
"local_isdst(time)",
"",
"For a time (e.g., returned by now()) return dst in the local timezone.",
"The return is positive if dst is in effect, 0 otherwise.",
0,
"local_yday",
"local_yday(time)",
"",
"For a time (e.g., returned by now()) give day-of-year in the local timezone.",
"The return value is in the range 0..364 (0..365 for leapyears)",
0,
"local_wday",
"local_wday(time)",
"",
"For a time (e.g., returned by now()) return day (0-6) in the local timezone.",
0,
"gmt_year",
"gmt_year(time)",
"",
"For a time (e.g., returned by now()) return its year in Greenwich.",
0,
"gmt_month",
"gmt_month(time)",
"",
"For a time (e.g., returned by now()) return its month in Greenwich.",
0,
"gmt_date",
"gmt_date(time)",
"",
"For a time (e.g., returned by now()) return its date in Greenwich.",
0,
"gmt_hour",
"gmt_hour(time)",
"",
"For a time (e.g., returned by now()) return its hour in Greenwich.",
0,
"gmt_min",
"gmt_min(time)",
"",
"For a time (e.g., returned by now()) return minutes in Greenwich.",
0,
"gmt_sec",
"gmt_sec(time)",
"",
"For a time (e.g., returned by now()) return seconds in Greenwich.",
0,
"gmt_isdst",
"gmt_isdst(time)",
"",
"For a time (e.g., returned by now()) tell if it's dst in Greenwich.",
"The return is positive if dst is in effect, 0 otherwise.",
0,
"gmt_yday",
"gmt_yday(time)",
"",
"For a time (e.g., returned by now()) the day-of-year (0-365) in Greenwich.",
0,
"gmt_wday",
"gmt_wday(time)",
"",
"For a time (e.g., returned by now()) return the day (0-6) in Greenwich.",
0,
"get_date",
"get_date(date_string)",
"",
"Parse a date and return its time (seconds since epoch).",
"The syntax of dates is the same as is understood by GNU tar or GNU date.",
0,
"posix_date",
"posix_date(posix_date_string)",
"",
"Parse a date and return its time (seconds since epoch).",
"The syntax of dates follows the Posix standard (as understood by GNU date).",
0,
"strftime",
"strftime(format_string, time_val)",
"",
"Return a string according to FORMAT describing TIME (as returned by now()).",
"The format string may contain these escape codes:",
"",
"This function is implemented by the C library function strftime.",
"The following documentation describes the GNU implementation of strftime.",
"Your version of Oleo may have been built with a different version, in",
"which case, you can find documentation in the strftime man page.",
"(In the future this anomoly will be removed).",
"",
"Performs `%' substitutions similar to those in printf.  Except",
"where noted, substituted fields have a fixed size; numeric fields are",
"padded if necessary.  Padding is with zeros by default; for fields",
"that display a single number, padding can be changed or inhibited by",
"following the `%' with one of the modifiers described below.  Unknown",
"field specifiers are copied as normal characters.  All other",
"characters are copied to the output without change.",
"",
"Supports a superset of the ANSI C field specifiers.",
"",
"Literal character fields:",
"%	%",
"n	newline",
"t	tab",
"",
"Numeric modifiers (a nonstandard extension):",
"-	do not pad the field",
"_	pad the field with spaces",
"",
"Time fields:",
"%H	hour (00..23)",
"%I	hour (01..12)",
"%k	hour ( 0..23)",
"%l	hour ( 1..12)",
"%M	minute (00..59)",
"%p	locale's AM or PM",
"%r	time, 12-hour (hh:mm:ss A/PM)",
"%R	time, 24-hour (hh:mm)",
"%S	second (00..61)",
"%T	time, 24-hour (hh:mm:ss)",
"%X	locale's time representation (%H:%M:%S)",
"%Z	time zone (EDT), or nothing if no time zone is determinable",
"",
"Date fields:",
"%a	locale's abbreviated weekday name (Sun..Sat)",
"%A	locale's full weekday name, variable length (Sunday..Saturday)",
"%b	locale's abbreviated month name (Jan..Dec)",
"%B	locale's full month name, variable length (January..December)",
"%c	locale's date and time (Sat Nov 04 12:02:33 EST 1989)",
"%C	century (00..99)",
"%d	day of month (01..31)",
"%e	day of month ( 1..31)",
"%D	date (mm/dd/yy)",
"%h	same as %b",
"%j	day of year (001..366)",
"%m	month (01..12)",
"%U	week number of year with Sunday as first day of week (00..53)",
"%w	day of week (0..6)",
"%W	week number of year with Monday as first day of week (00..53)",
"%x	locale's date representation (mm/dd/yy)",
"%y	last two digits of year (00..99)",
"%Y	year (1970...)",

0,


"help-with-help",
"",
"Valid help characters are:",
"",
"c  -- 	describe-character-briefly",
"	Type a command key sequence; it prints the function name that",
"	sequence runs.",
"f  --  describe-function",
"	Type a function name and get full documentation for that function.",
"F  --  describe-formula",
"	Type the name of a formula function, and get full documentation.",
"k  --	describe-key",
"	Type a command key sequence and get full documentation for the",
"	function that sequence runs.", 
"o  --  show-options",
"	Print the current settings of all user options.",
"v  --  show-variable",
"	Type a variable name and get it's binding.",
"^v --  show-all-variables",
"	Print a list of all variables and their bindings.",
"w  --	where-is",
"	Type a command name and get a keysequence that invokes that command.",
"W  --  view-wallchart",
"	Display a list of keybindings.",
"^W --  print-wallchart",
"	Write a list of keybindings to a file.",
0,
"graphing"
"",
"[graph-presets-verbosely]	--  Reset graphing parameters to default values.",
"[graph-clear-verbosely]	--  Clear the datasets of their assigned ranges.",
"[graph-select-output]	--  Choose the output type for graphs.",
"[graph-set-data]	--  Assign a range of data to a dataset in the graph.",
"[graph-verify]	--  Verify graph parameters.",
"[graph-plot]	--  Plot with the current parameters.",
""
"The following control optional parameters:",
"",
"[graph-x-axis]	--  Define parameters relating the X axis.",
"[graph-y-axis]	--  Define parameters relating the Y axis.",
"[graph-set-data-title]	--  Assign a title to a dataset.",
"[graph-set-style]	--  Assign a style to a dataset.",
"",
"Esc	--  End this command.",
0,
"graph-x-axis-help",
"",
"[graph-set-x-range-low]	--  Set the beginning of the range of the X axis.",
"[graph-set-x-range-high]	--  Set the end of the range of the X axis.",
"[graph-set-x-axis-symbolic]	--  Specify a symbolic range for X.",
"[graph-set-x-labels]	--  Provide labels for tic marks on the X axis.",
"[graph-default-x-labels]	--  Use the default tic marks on the X axis.",
"",
"",
"Esc	--  End this command.",
0,
"graph-y-axis-help",
"",
"[graph-set-y-range-low]	--  Set the beginning of the range of the Y axis.",
"[graph-set-y-range-high]	--  Set the end of the range of the Y axis.",
"[graph-set-y-labels]	--  Provide labels for tic marks on the Y axis.",
"[graph-default-y-labels]	--  Use the default tic marks on the Y axis.",
"",
"Esc	--  End this command.",
0,
"graph-output-types",
"",
"[graph-x11-mono]	--  Draw the graph in an X window, in black and white.",
"[graph-x11-color]	--  Draw the graph in an X window, in color.",
"[graph-postscript]	--  Write a file of postscript commands that draw that graph.",
0,
"keybindings-wallchart",
"",
"			   General Utility",
"[[main]]",
"Abort the current command, or partial keysequence	[break]",
"Set repeat counts and other prefix arguments		[universal-argument]",
"Jane, stop this crazy thing				[kill-oleo]",
"Redraw the screen					[redraw-screen]",
"Suspend Oleo						[suspend-oleo]",
"Call a command by name					[execute-command]",
"Recalculate						[recalculate]",
"",
"",
"			    Help Commands",
"",
"Describe key briefly	[describe-key-briefly]",
"Describe key		[describe-key]",
"Describe function	[describe-function]",
"Describe formula	[describe-formula]",
"Where is		[where-is]",
"",
"",
"When a complex command is being invoked (i.e., when Oleo is prompting",
"you for arguments), the next command displays documentation for the",
"command being invoked.  This can often be used to get more information",
"about what is being prompted for:",
"",
"Help with command	[help-with-command]",
"",
"",
"",
"			  Cell Cursor Motion",
"",
"Every window has it's own cell cursor.  The most recently used window",
"defines the current cell position.  There is one cell marker, global to ",
"the spreadsheet.",
"",
"Move the cell cursor to a specific address		[goto-cell]",
"Set the cell cursor and the cell mark			[goto-region]",
"",
"Set the cell mark to the current cell			[mark-cell]",
"(to set the cell cursor equal to the mark, and clear the mark,",
" use `[universal-argument][mark-cell]').",
"",
"Exchange the cell cursor and cell mark			[exchange-point-and-mark]",
"(To clear the mark, use `[universal-argument][exchange-point-and-mark]'.)",
"",
"",
"",
"			      Navigation",
"",
"Under X, and on some terminals (those following the ANSI standard)",
"arrow keys can be used to move the cell cursor.",
"",
"up	[up-cell]		down	[down-cell]",
"right	[right-cell]		left	[left-cell]",
"",
"Though they have no default bindings, there are also the commands:",
"   upright-cell, upleft-cell, downright-cell, downleft-cell",
"",
"Some commands go to extremes but leave their mark (if none is already set):",
"",
"Upper left	[upper-left]",
"Lower right	[lower-right]",
"",
"Beginning of row	[beginning-of-row]",
"Beginning of col	[beginning-of-col]",
"End of row		[end-of-row]",
"End of col		[end-of-col]",
"",
"These commands find the boundries between filled and empty cells. They",
"are similar to word motion commands in Emacs.",
"",
"Scan up		[scan-up]",
"Scan down	[scan-down]",
"Scan right	[scan-right]",
"Scan left	[scan-left]",
"",
"",
"			  Scrolling commands",
"",
"These are used to change the visible range of a window.",
"",
"Scroll up	[scroll-up]",
"Scroll down	[scroll-down]",
"Scroll right	[scroll-right]",
"Scroll left	[scroll-left]",
"",
"These commands are also availble but not normally bound:",
"scroll-upright, scroll-upleft, scroll-downright, scroll-downleft",
"",
"",
"",
"		      Commands related to macros",
"",
"Oleo can read keystrokes, and can save keysequences in cells for later",
"re-execution.",
"  ",
"Start entering macro	[start-entering-macro]",
"Stop entering macro	[stop-entering-macro]",
"Call last kbd macro	[call-last-kbd-macro]",
"End macro		[end-macro]",
"Store last macro	[store-last-macro]",
"Run string as macro	[run-string-as-macro]",
"",
"",
"",
"			    Global options",
"",
"These are global parameters under user control (e.g. The a0/noa0",
"option that selects a syntax for cell addresses (either A1 or R1C1)).",
"",
"Show options		[show-options]",
"Set option		[set-option]",
"",
"",
"",
"			      Variables",
"",
"Variables are symbolic names for regions of a spreadsheet.  Once",
"defined, they can be used in cell formulas as region addresses.  They",
"can also be used as arguments to any command that expects a region",
"address.",
"",
"Set variable		[set-variable]",
"Show variable		[show-variable]",
"Show all variables	[show-all-variables]",
"",
"",
"",
"			    File commands",
"",
"Read a spreadsheet	[find-alternate-spreadsheet]",
"Save a spreadsheet	[save-spreadsheet]",
"Merge spreadsheet	[merge-spreadsheet]",
"Write region to file	[write-region-to-file]",
"",
"By default, if a spreadsheet defines a variable `load_hooks', the",
"macro in that region is executed when the spreadsheet is first read.",
"This behavior can be disabled or reinabled by:",
"",
"Toggle load hooks	[toggle-load-hooks]",
"",
"The next command reads a file of commands (such as a .oleorc file):",
"",
"Read commands		[read-commands]",
"",
"",
"",
"			       Printing",
"",
"Write an ascii rendition of a region			[print-region]",
"Write an embedded postscript rendition of a region	[psprint-region]",
"Set page size for postscript printing			[set-page-size]",
"",
"",
"",
"			       Plotting",
"",
"The command `[graph-setup]' accesses the Oleo interface to gnuplot.  If",
"you have gnuplot, you can draw graphs of Oleo data, either on the",
"screen, or in postscript.",
"",
"",
"		     Operations on entire regions",
"",
"Copy region		[copy-region]",
"Copy values in region	[copy-values-in-region]",
"Move region		[move-region]",
"",
"Insert row		[insert-row]",
"Insert col		[insert-col]",
"",
"Delete row		[delete-row]",
"Delete col		[delete-col]",
"",
"Delete region		[delete-region]",
"Clear spreadsheet	[clear-spreadsheet]",
"",
"",
"Window Commands ",
"",
"Recenter window			[recenter-window]",
"Open window			[open-window]",
"Split window horizontally	[split-window-horizontally]",
"Split window vertically		[split-window-vertically]",
"Delete window			[delete-window]",
"Delete other windows		[delete-other-windows]",
"Close window			[close-window]",
"Goto window			[goto-window]",
"Goto minibuffer			[goto-minibuffer]",
"Other window			[other-window]",
"",
"",
"",
"Cell attribute commands",
"",
"Set region height		[set-region-height]",
"Set region width		[set-region-width]",
"Set region protection		[set-region-protection]",
"Set region alignment		[set-region-alignment]",
"Set region format		[set-region-format]",
"Set cell height			[set-cell-height]",
"Set cell width			[set-cell-width]",
"Set cell protection		[set-cell-protection]",
"Set cell alignment		[set-cell-alignment]",
"Set cell format			[set-cell-format]",
"Set default height		[set-default-height]",
"Set default width		[set-default-width]",
"Set default protection		[set-default-protection]",
"Set default alignment		[set-default-alignment]",
"Set default format		[set-default-format]",
"Define user format		[define-user-format]",
"",
"",
"",
"			       Keymaps",
"",
"Create keymap			[create-keymap]",
"Set map prompt			[set-map-prompt]",
"Bind key			[bind-key]",
"Bind set			[bind-set]",
"Bind all keys			[bind-all-keys]",
"Write keys			[write-keys]",
"",
"",
"",
"			    Editting cells",
"",
"Edit cell			[edit-cell]",
"Set region formula		[set-region-formula]",
"",
"Delete cell			[delete-cell]",
"Delete region			[delete-region]",
"",
"Clear spreadsheet		[clear-spreadsheet]",
"",
"From the main keymap, typing almost any printable character begins ",
"to edit the value of a cell.",
"",
"These commands provide efficent motion while editting cells:",
"[[read-formula]]",
"Next edit			[next-edit]",
"Next edit-set			[next-edit-set]",
"",
"",
"These commands set the directions used by `[next-edit]' and",
"`[next-edit-set]': ",
"",
"Auto move up			[auto-move-up]",
"Auto move down			[auto-move-down]",
"Auto move left			[auto-move-left]",
"Auto move right			[auto-move-right]",
"Auto move up left		[auto-move-up-left]",
"Auto move up right		[auto-move-up-right]",
"Auto move down left		[auto-move-down-left]",
"Auto move down right		[auto-move-down-right]",
"Auto move no motion		[auto-move-no-motion]",
"",
"",
"		      Editting in the input area",
"",
"Toggle overwrite		[toggle-overwrite]",
"Beginning of line		[beginning-of-line]",
"End of line			[end-of-line]",
"Backward char			[backward-char]",
"Backward word			[backward-word]",
"Backward delete char		[backward-delete-char]",
"Backward delete word		[backward-delete-word]",
"Delete to start			[delete-to-start]",
"Forward char			[forward-char]",
"Forward word			[forward-word]",
"Delete char			[delete-char]",
"Delete word			[delete-word]",
"Kill line			[kill-line]",
"Insert cell expression		[insert-cell-expression]",
"Insert cell value		[insert-cell-value]",
"Insert rel ref			[insert-rel-ref]",
"Insert abs ref			[insert-abs-ref]",
0,
"_NON_WARRANTY_",
"",
" Copyright (C) 1990, 1991, 1992, 1993 Free Software Foundation,Inc.",
"There is ABSOLUTELY NO WARRANTY for Oleo; see the file COPYING",
"for details.  Oleo is free software and you are welcome to distribute",
"copies of it under certain conditions; see the file COPYING to see the",
"conditions.",
"",
"		The help character is ^H",
"",
"		[Press any key to begin]",
0,
0,
};


/* Search for some formula documentation. */

#ifdef __STDC__
char **
forminfo_text (char * name)
#else
char **
forminfo_text (name)
     char * name;
#endif
{
  char ** pos = formula_info;
  while (*pos)
    if (!stricmp (name, *pos))
      return pos;
    else
      while (*pos++) ;
  return 0;
}

