/*
 *	Since using watchpoints can be very slow, we have to take some pains to
 *	ensure that we don't run too long with them enabled or we run the risk
 *	of having the test timeout.  To help avoid this, we insert some marker
 *	functions in the execution stream so we can set breakpoints at known
 *	locations, without worrying about invalidating line numbers by changing
 *	this file.  We use null bodied functions are markers since gdb does
 *	not support breakpoints at labeled text points at this time.
 *
 *	One place we need is a marker for when we start executing our tests
 *	instructions rather than any process startup code, so we insert one
 *	right after entering main().  Another is right before we finish, before
 *	we start executing any process termination code.
 *
 *	Another problem we have to guard against, at least for the test
 *	suite, is that we need to ensure that the line that causes the
 *	watchpoint to be hit is still the current line when gdb notices
 *	the hit.  Depending upon the specific code generated by the compiler,
 *	the instruction after the one that triggers the hit may be part of
 *	the same line or part of the next line.  Thus we ensure that there
 *	are always some instructions to execute on the same line after the
 *	code that should trigger the hit.
 */

int count = -1;
int ival1 = -1;
int ival2 = -1;
int ival3 = -1;
int ival4 = -1;

void marker1 ()
{
}

void marker2 ()
{
}

int main ()
{
  marker1 ();
  for (count = 0; count < 4; count++) {
    ival1 = count;
    ival2 = count;
    ival3 = count; ival4 = count;
  }
  ival1 = count;
  ival2 = count;
  ival3 = count; ival4 = count;
  marker2 ();
  return 0;
}
