/* C code produced by gperf version 2.5 (GNU C++ version) */
/* Command-line: gperf -p -j1 -g -o -t -N is_reserved_word -k1,4,7,$ ../../devo/gcc/gplus.gperf  */
/* Command-line: gperf -p -j1 -g -o -t -N is_reserved_word -k1,4,$,7 gplus.gperf  */
struct resword { char *name; short token; enum rid rid;};

#define TOTAL_KEYWORDS 82
#define MIN_WORD_LENGTH 2
#define MAX_WORD_LENGTH 13
#define MIN_HASH_VALUE 4
#define MAX_HASH_VALUE 142
/* maximum key range = 139, duplicates = 0 */

#ifdef __GNUC__
inline
#endif
static unsigned int
hash (str, len)
     register char *str;
     register int unsigned len;
{
  static unsigned char asso_values[] =
    {
     143, 143, 143, 143, 143, 143, 143, 143, 143, 143,
     143, 143, 143, 143, 143, 143, 143, 143, 143, 143,
     143, 143, 143, 143, 143, 143, 143, 143, 143, 143,
     143, 143, 143, 143, 143, 143, 143, 143, 143, 143,
     143, 143, 143, 143, 143, 143, 143, 143, 143, 143,
     143, 143, 143, 143, 143, 143, 143, 143, 143, 143,
     143, 143, 143, 143, 143, 143, 143, 143, 143, 143,
     143, 143, 143, 143, 143, 143, 143, 143, 143, 143,
     143, 143, 143, 143, 143, 143, 143, 143, 143, 143,
     143, 143, 143, 143, 143,   0, 143,  72,   1,  67,
      36,   0,   5,   4,   2,  34, 143,   1,  10,  24,
      27,   0,  34, 143,  26,   0,   8,  14,  26,  53,
       0,  46, 143, 143, 143, 143, 143, 143,
    };
  register int hval = len;

  switch (hval)
    {
      default:
      case 7:
        hval += asso_values[str[6]];
      case 6:
      case 5:
      case 4:
        hval += asso_values[str[3]];
      case 3:
      case 2:
      case 1:
        hval += asso_values[str[0]];
    }
  return hval + asso_values[str[len - 1]];
}

#ifdef __GNUC__
inline
#endif
struct resword *
is_reserved_word (str, len)
     register char *str;
     register unsigned int len;
{
  static struct resword wordlist[] =
    {
      {"",}, {"",}, {"",}, {"",}, 
      {"else",  ELSE, NORID,},
      {"",}, {"",}, 
      {"__asm__",  GCC_ASM_KEYWORD, NORID},
      {"goto",  GOTO, NORID,},
      {"",}, 
      {"__headof__",  HEADOF, NORID},
      {"sizeof",  SIZEOF, NORID,},
      {"this",  THIS, NORID,},
      {"__headof",  HEADOF, NORID},
      {"except",  EXCEPT, NORID		/* Extension */,},
      {"",}, 
      {"switch",  SWITCH, NORID,},
      {"__const__",  TYPE_QUAL, RID_CONST},
      {"__volatile",  TYPE_QUAL, RID_VOLATILE},
      {"typeof",  TYPEOF, NORID,},
      {"__volatile__",  TYPE_QUAL, RID_VOLATILE},
      {"__classof__",  CLASSOF, NORID},
      {"long",  TYPESPEC, RID_LONG,},
      {"__const",  TYPE_QUAL, RID_CONST},
      {"__classof",  CLASSOF, NORID},
      {"typedef",  SCSPEC, RID_TYPEDEF,},
      {"",}, {"",}, 
      {"struct",  AGGR, RID_RECORD,},
      {"__asm",  GCC_ASM_KEYWORD, NORID},
      {"",}, 
      {"raise",  RAISE, NORID		/* Extension */,},
      {"raises",  RAISES, NORID		/* Extension */,},
      {"extern",  SCSPEC, RID_EXTERN,},
      {"for",  FOR, NORID,},
      {"",}, {"",}, {"",}, 
      {"do",  DO, NORID,},
      {"short",  TYPESPEC, RID_SHORT,},
      {"__extension__",  EXTENSION, NORID},
      {"if",  IF, NORID,},
      {"delete",  DELETE, NORID,},
      {"double",  TYPESPEC, RID_DOUBLE,},
      {"__signed__",  TYPESPEC, RID_SIGNED},
      {"int",  TYPESPEC, RID_INT,},
      {"union",  AGGR, RID_UNION,},
      {"friend",  SCSPEC, RID_FRIEND,},
      {"__alignof__",  ALIGNOF, NORID},
      {"headof",  HEADOF, NORID,},
      {"",}, 
      {"__alignof",  ALIGNOF, NORID},
      {"enum",  ENUM, NORID,},
      {"__attribute",  ATTRIBUTE, NORID},
      {"",}, 
      {"__attribute__",  ATTRIBUTE, NORID},
      {"__typeof__",  TYPEOF, NORID},
      {"try",  TRY, NORID			/* Extension */,},
      {"template",  TEMPLATE, NORID,},
      {"__typeof",  TYPEOF, NORID},
      {"operator",  OPERATOR, NORID,},
      {"virtual",  SCSPEC, RID_VIRTUAL,},
      {"__inline",  SCSPEC, RID_INLINE},
      {"",}, 
      {"__inline__",  SCSPEC, RID_INLINE},
      {"",}, 
      {"throw",  THROW, NORID		/* Extension */,},
      {"private",  VISSPEC, RID_PRIVATE,},
      {"while",  WHILE, NORID,},
      {"signed",  TYPESPEC, RID_SIGNED,},
      {"exception",  AGGR, RID_EXCEPTION	/* Extension */,},
      {"case",  CASE, NORID,},
      {"class",  AGGR, RID_CLASS,},
      {"return",  RETURN, NORID,},
      {"inline",  SCSPEC, RID_INLINE,},
      {"",}, 
      {"auto",  SCSPEC, RID_AUTO,},
      {"",}, 
      {"__signed",  TYPESPEC, RID_SIGNED},
      {"break",  BREAK, NORID,},
      {"const",  TYPE_QUAL, RID_CONST,},
      {"static",  SCSPEC, RID_STATIC,},
      {"",}, 
      {"new",  NEW, NORID,},
      {"classof",  CLASSOF, NORID,},
      {"all",  ALL, NORID			/* Extension */,},
      {"",}, {"",}, {"",}, {"",}, 
      {"float",  TYPESPEC, RID_FLOAT,},
      {"__label__",  LABEL, NORID},
      {"unsigned",  TYPESPEC, RID_UNSIGNED,},
      {"",}, 
      {"register",  SCSPEC, RID_REGISTER,},
      {"protected",  VISSPEC, RID_PROTECTED,},
      {"",}, 
      {"continue",  CONTINUE, NORID,},
      {"",}, 
      {"asm",  ASM_KEYWORD, NORID,},
      {"",}, {"",}, 
      {"void",  TYPESPEC, RID_VOID,},
      {"mutable",  SCSPEC, RID_MUTABLE,},
      {"",}, 
      {"reraise",  RERAISE, NORID		/* Extension */,},
      {"",}, {"",}, {"",}, {"",}, 
      {"__wchar_t",  TYPESPEC, RID_WCHAR  /* Unique to ANSI C++ */,},
      {"",}, {"",}, {"",}, {"",}, {"",}, 
      {"volatile",  TYPE_QUAL, RID_VOLATILE,},
      {"public",  VISSPEC, RID_PUBLIC,},
      {"",}, {"",}, {"",}, {"",}, {"",}, 
      {"char",  TYPESPEC, RID_CHAR,},
      {"",}, {"",}, {"",}, {"",}, {"",}, {"",}, {"",}, 
      {"default",  DEFAULT, NORID,},
      {"",}, {"",}, {"",}, {"",}, {"",}, {"",}, {"",}, {"",}, {"",}, 
      {"catch",  CATCH, NORID,},
      {"overload",  OVERLOAD, NORID,},
    };

  if (len <= MAX_WORD_LENGTH && len >= MIN_WORD_LENGTH)
    {
      register int key = hash (str, len);

      if (key <= MAX_HASH_VALUE && key >= 0)
        {
          register char *s = wordlist[key].name;

          if (*s == *str && !strcmp (str + 1, s + 1))
            return &wordlist[key];
        }
    }
  return 0;
}
